/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import com.fasterxml.jackson.annotation.JsonFormat;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.modules.sys.entity.User;

import java.util.Date;

/**
 * 资金挂账Entity
 * @author lyy
 * @version 2016-08-16
 */
public class PaymentOnAccount extends DataEntity<PaymentOnAccount> {
	
	private static final long serialVersionUID = 1L;
	private String memberCode;		// 会员号
	private String name;		// 名称
	private String cardNo;		// 资金账号
	private String money;		// 金额
	private String balance;		// 余额money为总钱数。 balance为余额，剩余的未转入的钱
	private String log;		// 日志，记录挂账金额的流水信息
	private String paymentWay;	//支付方式
	private Date addTime;		//挂账时间
	private String isChange;
	private String proccessRemarks;//挂账转入操作的备注
	private Date startAddTime;	//查询开始时间
	private Date endAddTime;	 //查询结束时间
	
	private User user;
	
	
	
	
	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public PaymentOnAccount() {
		super();
	}

	public PaymentOnAccount(String id){
		super(id);
	}

	@Length(min=0, max=60, message="会员号长度必须介于 0 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=1, max=255, message="资金来源的姓名长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=20, message="银行卡号长度必须介于 0 和 20 之间")
	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}
	
	public String getMoney() {
		return money;
	}

	public void setMoney(String money) {
		this.money = money;
	}
	
	public String getBalance() {
		return balance;
	}

	public void setBalance(String balance) {
		this.balance = balance;
	}
	
	@Length(min=0, max=1000, message="日志，记录挂账金额的流水信息长度必须介于 0 和 1000 之间")
	public String getLog() {
		return log;
	}

	public void setLog(String log) {
		this.log = log;
	}
	@Length(min=0, max=64, message="支付方式长度必须介于 0 和 64 之间")
	public String getPaymentWay() {
		return paymentWay;
	}

	public void setPaymentWay(String paymentWay) {
		this.paymentWay = paymentWay;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAddTime() {
		return addTime;
	}

	public void setAddTime(Date addTime) {
		this.addTime = addTime;
	}
	@Length(min=0, max=1, message="是否转账长度必须介于 0 和 1 之间")
	public String getIsChange() {
		return isChange;
	}

	public void setIsChange(String isChange) {
		this.isChange = isChange;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartAddTime() {
		return startAddTime;
	}

	public void setStartAddTime(Date startAddTime) {
		this.startAddTime = startAddTime;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndAddTime() {
		return endAddTime;
	}

	public void setEndAddTime(Date endAddTime) {
		this.endAddTime = endAddTime;
	}

	public String getProccessRemarks() {
		return proccessRemarks;
	}

	public void setProccessRemarks(String proccessRemarks) {
		this.proccessRemarks = proccessRemarks;
	}
}