package com.cku.oa.dog.service;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogStickerApplyDao;
import com.cku.oa.dog.dao.DogStickerDao;
import com.cku.oa.dog.entity.*;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.partner.club.dao.CompanionDogAppraisalDao;
import com.cku.restful.v1.dog.service.RestDogService;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 犬只等级贴纸申请Service
 *
 * @author lgl
 * @version 2018-11-21
 */
@Service
@Transactional(readOnly = true)
public class DogStickerApplyService extends CrudService<DogStickerApplyDao, DogStickerApply> {
	private static Long DATA = null;// 判定出生纸的申请日期是2019年2月1日前的均需收回

	static {
		try {
			DATA = new SimpleDateFormat("yyyy-MM-dd").parse("2019-02-01").getTime();
		} catch (ParseException e) {
			System.out.println("判定出生纸的申请日期是2019年2月1日前的均需收回出错");
		}
	}

	// public static final String CAB_PASSPORT_STARTS_WITH = "N";
	// 新需求 新护照号开头改成J
	public static final String CAB_PASSPORT_STARTS_WITH = "J";
	private static final String CLASS_BUSINESS_NAME = "等级贴纸";
	private static final String BIRTH_BUSINESS_NAME = "纯种犬身份登记卡";
	@Autowired
	ChampionLoginDao championLoginDao;
	@Autowired
	ShowResultsDao showResultsDao;
	@Autowired
	DogDao dogDao;
	@Autowired
	DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	DogStickerDao dogStickerDao;
	@Autowired
	MemberDao memberDao;
	@Autowired
	DogStickerApplyDao dogStickerApplyDao;
	@Autowired
	DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	public DogTypeService dogTypeService;
	@Autowired
	public DogColorMarkService dogColorMarkService;
	@Autowired
	public ExpressQueueService expressQueueService;
	@Autowired
	private KennelDao kennelDao;
	@Autowired
	private CompanionDogAppraisalDao companionDogAppraisalDao;
	@Autowired
	@Lazy
	private RestDogService restDogService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentRecordDao paymentRecordDao;
	@Autowired
	private PaymentOrderService paymentOrderService;

	public DogStickerApply get(String id) {
		return super.get(id);
	}
	
	/**
	 * 根据芯片号查询
	 * @param identificationFlag
	 * @return
	 */
	public String getApplyClassByIdentificationFlag(String identificationFlag) {
		return dogStickerApplyDao.selectApplyClassByIdentificationFlag(identificationFlag);
	}


	public List<DogStickerApply> findList(DogStickerApply dogStickerApply) {
		return super.findList(dogStickerApply);
	}

	public Page<DogStickerApply> findPage(Page<DogStickerApply> page, DogStickerApply dogStickerApply) {
		dogStickerApply.setPage(page);
		String stickerStates = dogStickerApply.getStickerStates();
		if (StringUtils.isNotBlank(stickerStates)) {
			if (stickerStates.equals("1")) {
				dogStickerApply.setPaymentState("1");
			} else if (stickerStates.equals("2")) {
				dogStickerApply.setPaymentState("2");
				dogStickerApply.setRegisterCardPrintFlag("0");
				dogStickerApply.setStickerPrintFlag("0");
			} else if (stickerStates.equals("3")) {
				dogStickerApply.setPaymentState("2");
				dogStickerApply.setRegisterCardPrintFlag("0");
			} else if (stickerStates.equals("4")) {
				dogStickerApply.setPaymentState("2");
				dogStickerApply.setStickerPrintFlag("0");
			} else if (stickerStates.equals("5")) {
				dogStickerApply.setPaymentState("2");
				dogStickerApply.setRegisterCardPrintFlag("1");
				dogStickerApply.setStickerPrintFlag("1");
				dogStickerApply.getSqlMap().put("unExpressMap", stickerStates);
			} else if (stickerStates.equals("6")) {
				dogStickerApply.getSqlMap().put("expressMap", stickerStates);
			}
		}
		dogStickerApply.setPage(page);
		page.setList(dao.findPageExt(dogStickerApply));
		return page;
	}

	@Transactional(readOnly = false)
	public void save(DogStickerApply dogStickerApply) {
		super.save(dogStickerApply);
	}

	@Transactional(readOnly = false)
	public void delete(DogStickerApply dogStickerApply) {
		super.delete(dogStickerApply);
	}

	// TODO: 2019/8/15 逻辑变更
	public int getMaxApplyClass(Dog dog) {
		int i = 0;
		// SS级贴纸校验
		if (sStickerValidate(dog) && StickerBolidate(dog))
			i = 4;
		// S级贴纸校验
		if (sStickerValidate(dog) && (sStickerValidate(dog.getPedigreeCertifiedCode()) || StickerBolidate(dog)))
			if (i == 0)
				i = 3;
		if (i == 0)
			i = 2;
		return i;

	}

	// SS级贴纸校验

	public boolean sStickerValidate(Dog dog) {
		// 有赛事记录
		boolean flag1 = showResultsDao.getByKey(dog.getPedigreeCertifiedCode()).size() > 0;
		// 失格次数<3
		boolean flag2 = !(StringUtils.isNumeric(dog.getDisqualificationNumber())
				&& Integer.parseInt(dog.getDisqualificationNumber()) >= 3);
		// 3代及以上
		boolean flag3 = restDogService.getDogGeneration(dog.getPedigreeCertifiedCode()) >= 3;

		return flag1 && flag2 && flag3;
	}

	/**
	 * 冠军登陆头衔 校验
	 *
	 * @param dog
	 * @return
	 */
	public boolean StickerBolidate(Dog dog) {
		// 以获得冠军登陆头衔 championLoginList.size()>0
		ChampionLogin championLogin = new ChampionLogin();
		championLogin.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		championLogin.setPrintState("1");
		List<ChampionLogin> championLoginList = championLoginDao.findList(championLogin);
		return championLoginList != null && championLoginList.size() > 0;
	}

	/**
	 * S级贴纸校验 后加 评价EX+VP>=2 or 冠军登陆头衔 true
	 *
	 * @param pedcode
	 * @return
	 */
	public boolean sStickerValidate(String pedcode) {
		Long s = companionDogAppraisalDao.customSql(String.format(
				"select sum(a.s) from (select  count(appraisal) as s from "
						+ "show_results where (appraisal='VP' or appraisal='EX' )and pedigree_certified='%s'  \n"
						+ "UNION\n"
						+ "select count( appraisal) as s from show_results_bov where (appraisal='VP' or appraisal='EX' ) and pedigree_certified='%s' ) a",
				pedcode, pedcode));

		return s >= 2;
	}

	public int getMaxApplyClass(DogBirthCertificate dogBirthCertificate) {
		Dog dog = dogDao.getByBirthCertificateLevelCode(dogBirthCertificate.getBirthCerRegCode());
		if (dog != null) {
			return getMaxApplyClass(dog);
		} else {
			return 1;
		}
	}

	public String getAlreadyHaveClass(String identificationFlag) {
		String applyClass = "";
		List<DogSticker> dogStickerList = dogStickerDao.getByIdentificationFlag(identificationFlag);
		if (dogStickerList.size() > 0) {
			String[] array = new String[dogStickerList.size()];
			for (int i = 0, j = dogStickerList.size(); i < j; i++) {
				array[i] = dogStickerList.get(i).getStickerClass();
			}
			applyClass = StringUtils.join(array, ",");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(identificationFlag);
		if (dogBirthCertificate != null && (dogBirthCertificate.getClassPrintStatus().equals("9")
				|| dogBirthCertificate.getCreateDate().getTime() >= DogBirthCertificateService.ACTICATION_OFF_MILLS))
			if (StringUtils.isNotEmpty(applyClass) && !applyClass.contains("1"))
				applyClass = applyClass + "," + 1;
			else
				applyClass = "1";
		return applyClass;
	}

	public int getAlreadyHaveMaxClass(String identificationFlag) {
		List<DogSticker> dogStickerList = dogStickerDao.getByIdentificationFlag(identificationFlag);
		if (dogStickerList.size() > 0) {
			return Integer.parseInt(dogStickerList.get(0).getStickerClass());
		} else {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByIdentificationFlag(identificationFlag);
			if (dogBirthCertificate != null && !dogBirthCertificate.getClassPrintStatus().equals("9"))
				// 2020-05-01日起取消E级贴纸
				if (dogBirthCertificate.getCreateDate().getTime() >= DogBirthCertificateService.ACTICATION_OFF_MILLS)
					return 1;
				else
					return 0;

			return 1;
		}
	}

	public String getApplyClass(Dog dog) {
		return getApplyClass(getMaxApplyClass(dog), getAlreadyHaveMaxClass(dog.getIdentificationFlag()),
				dog.getIdentificationFlag());
	}

	public String getApplyClass(DogBirthCertificate dogBirthCertificate) {
		return getApplyClass(getMaxApplyClass(dogBirthCertificate),
				getAlreadyHaveMaxClass(dogBirthCertificate.getIdentificationFlag()), null);
	}

	public String getApplyClass(int maxApplyClass, int alreadyHaveMaxClass, String identificationFlag) {
		String applyClass = "";
		int len = maxApplyClass - alreadyHaveMaxClass;
		if (len > 0) {
			List<String> list = Lists.newArrayList();
			for (int i = 0; i < len; i++) {
				if (maxApplyClass - i == 1) {
					DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
							.getByIdentificationFlag(identificationFlag);
					// E级贴纸，且从dog进来的，需要查询是否有出生纸，没有出生纸不可申请E级
					if (dogBirthCertificate == null) {
						continue;
					}
				}
				list.add(String.valueOf(maxApplyClass - i));
			}
			applyClass = StringUtils.join(list, ",");
		}
		return applyClass;
	}

	public void validateBusiness(DogStickerApply po) {
		Dog dog = dogDao.getNewOneByIdentificationFlag(po.getIdentificationFlag());
		// 单独申请血统证书号必须CKU前缀
		if (!dog.getPedigreeCertifiedCode().toUpperCase().startsWith("CKU")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "等级贴纸单独申请,仅限血统证书以CKU开头的犬只申请");
		}
		// 等级贴纸申请基础校验
		basicValidate(po.getIdentificationFlag(), po.getPaymentMemberCode());
		// 有未付款业务记录，不能申请
		DogStickerApply example = new DogStickerApply();
		example.setIdentificationFlag(po.getIdentificationFlag());
		example.setPaymentState("1");
		List<DogStickerApply> dogStickerApplyList = dao.findList(example);
		if (dogStickerApplyList.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只目前有未付款贴纸申请");
		}
	}

	// 等级贴纸申请基础校验
	public void basicValidate(String identificationFlag, String memberCode) {
		validateMember(identificationFlag, memberCode);
		checkSticker(dogDao.getNewOneByIdentificationFlag(identificationFlag));
	}

	public void validateMember(String identificationFlag, String memberCode) {
		// 只能为自己名下的犬只申请,持有血统证书或出生纸皆可
		Dog dog = dogDao.getNewOneByIdentificationFlag(identificationFlag);
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(identificationFlag);
		boolean dogMemberCodeNotEquals = (dog != null && !dog.getMemberCode().equals(memberCode));
		boolean dogBirthCertificateMemberCodeNotEquals = (dogBirthCertificate != null
				&& !dogBirthCertificate.getMemberCode().equals(memberCode));
		// 会员中心会员宠爱护照等级贴纸申请时，出现犬只已做犬主变更，系统判断犬主与出生纸犬只不为同一人，导致无法申请宠爱护照等级贴纸。现需修改为宠爱护照仅由犬主人申请，不再判断出生纸主人
		if (dogMemberCodeNotEquals) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只能为自己名下的犬只申请等级贴纸");
		}
	}

	public String getStickerClass(String stickerClassString) {
		List<String> stickerClassList = Lists.newArrayList();
		for (String stickerClass : stickerClassString.split(",")) {
			stickerClassList.add(DictUtils.getDictLabel(stickerClass, "sticker_class", ""));
		}
		return StringUtils.join(stickerClassList, "/");
	}

	public void checkSticker(Dog dog) {
		if (dog == null) {
			return;
		}
		int maxApplyClass = getMaxApplyClass(dog);
		int alreadyHaveMaxClass = getAlreadyHaveMaxClass(dog.getIdentificationFlag());
		if (maxApplyClass <= alreadyHaveMaxClass) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只目前没有可申请的贴纸");
		}
	}

	// public void checkSticker(DogBirthCertificate dogBirthCertificate) {
	// int maxApplyClass = getMaxApplyClass(dogBirthCertificate);
	// int alreadyHaveMaxClass =
	// getAlreadyHaveMaxClass(dogBirthCertificate.getIdentificationFlag());
	// if (maxApplyClass == alreadyHaveMaxClass) {
	// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只目前没有可申请的贴纸");
	// }
	// }

	@Transactional(readOnly = false)
	public String printSticker(String id, Model model) {
		DogStickerApply dogStickerApply = super.get(id);
		if (dogStickerApply == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "找不到该申请记录");
		}
		if (StringUtils.isBlank(dogStickerApply.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空，无法打印");
		}
		if (StringUtils.isBlank(dogStickerApply.getCabPassport())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "护照号为空，无法打印");
		}
		// if (StringUtils.isBlank(dogStickerApply.getPaymentState()) &&
		// !"2".equals(dogStickerApply.getPaymentState())) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该申请未交费，无法打印");
		// }
		if (StringUtils.isBlank(dogStickerApply.getNeedNewPassport())
				&& !"1".equals(dogStickerApply.getNeedNewPassport())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有新版护照、无法打印登记卡");
		}
		if (!"0".equals(dogStickerApply.getStickerPrintFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请的贴纸已打印");
		}
		String applyClass = dogStickerApply.getApplyClass();
		if (StringUtils.isBlank(applyClass)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "没有申请等级贴纸，无法打印");
		}
		if (dogStickerApply.getCreateDate().getTime() > DogBirthCertificateService.newBusinessTimeMillis) {
			// 打印毛色只显示中文
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogStickerApply.getColorFlag());
			if (dogColorMark != null) {
				String colorFlag = dogColorMark.getDogColorMarkCn();
				if (colorFlag != null) {
					dogStickerApply.setColorFlag(colorFlag.substring(colorFlag.indexOf("-") + 1));
				}
			}
		}
		List<DogSticker> dogStickerList = new ArrayList<DogSticker>();
		for (String stickerClass : applyClass.split(",")) {
			DogSticker dogSticker = dogStickerDao
					.getByIdentificationFlagAndClass(dogStickerApply.getIdentificationFlag(), stickerClass);
			if (dogSticker == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "找不到该贴纸信息、无法打印");
			}
			String stickerNo = dogSticker.getStickerNo();
			String stickerClassName = getStickerClass(stickerClass);
			Dog dog = dogDao.getNewOneByIdentificationFlag(dogStickerApply.getIdentificationFlag());
			if (dog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "找不到该犬只信息");
			}
			String cabRegisterCode = dog.getCabRegisterCode();
			if (StringUtils.isBlank(cabRegisterCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "纯种犬身份登记编号为空");
			}
			dogStickerApply.setBirthday(dog.getBirthdate());
			dogStickerApply.setCabRegisterCode(dog.getCabRegisterCode());
			dogStickerApply.setColorFlag(dog.getColorFlag());
			Kennel kennel = kennelDao.getKennelByMemberCode(dog.getBreederMemberCode());
			if (kennel == null || StringUtils.isBlank(kennel.getName())) {
				dogStickerApply.setKennnelName("---");
			}
			if (StringUtils.isNotBlank(dogStickerApply.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogStickerApply.getDogBreed());
				if (dogType != null) {
					dogStickerApply.setBreedCnName(dogType.getBreedCnName());
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, CLASS_BUSINESS_NAME + stickerNo + "的犬种"
							+ dogStickerApply.getDogBreed() + ",在犬种表无法找到对应的记录，请检查是否有该犬种");
				}
			}
			List<DogBirthCertificate> dogbirthList = dogBirthCertificateService
					.getByIdentificationFlagList(dogStickerApply.getIdentificationFlag());
			if (CollectionUtils.isNotEmpty(dogbirthList) && dogbirthList.get(0).getCreateDate()
					.getTime() > DogBirthCertificateService.newBusinessTimeMillis) {
				// 打印毛色只显示中文
				DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dogStickerApply.getColorFlag());
				if (dogColorMark != null) {
					String colorFlag = dogColorMark.getDogColorMarkCn();
					if (colorFlag != null) {
						dogStickerApply.setColorFlag(colorFlag.substring(colorFlag.indexOf("-") + 1));
					}
				}
			}
			expressQueueService.push(dogStickerApply.getPaymentMemberCode(), dogStickerApply.getRunningNumber(),
					stickerClassName, stickerNo, "dog_sticker_apply", dogStickerApply.getId(), null);
			dogSticker.setStickerClassName(getStickerClass(stickerClass));
			dogSticker.setNameEn(dogStickerApply.getNameEn());
			dogSticker.setCabPassport(dogStickerApply.getCabPassport());
			dogSticker.setColorFlag(dogStickerApply.getColorFlag());
			dogSticker.setBirthday(dogStickerApply.getBirthday());
			dogSticker.setBreedCnName(dogStickerApply.getBreedCnName());
			dogSticker.setDogGender(dogStickerApply.getDogGender());
			dogStickerList.add(dogSticker);
		}
		dogStickerApply.setStickerPrintFlag("1");
		dao.update(dogStickerApply);
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, CLASS_BUSINESS_NAME + "打印", dogStickerApply.getPaymentMemberCode(),
				"dog_sticker_apply", dogStickerApply.getId(), dogStickerApply.getRunningNumber(), (str) -> {
				});
		model.addAttribute("dogStickerList", dogStickerList);
		return "oa/dog/dogstickerapply/dogStickerPrint";
	}

	private String getStickerNoByClass(String applyClass, String cabPassport) {
		String stickerNo = "";
		if (applyClass.equals("1")) {
			stickerNo = cabPassport.replace("N", "E");
		} else if (applyClass.equals("2")) {
			stickerNo = cabPassport.replace("N", "P");
		} else if (applyClass.equals("3")) {
			stickerNo = cabPassport.replace("N", "S");
		} else if (applyClass.equals("4")) {
			stickerNo = cabPassport.replace("N", "SS");
		}
		return stickerNo;
	}

	public String getClassEnNameByClass(int stickerClass) {
		String applyClass = "";
		if (stickerClass == 1) {
			applyClass = "E";
		} else if (stickerClass == 2) {
			applyClass = "P";
		} else if (stickerClass == 3) {
			applyClass = "S";
		} else if (stickerClass == 4) {
			applyClass = "SS";
		}
		return applyClass;
	}

	@Transactional(readOnly = false)
	public void resetPrintSticker(DogStickerApply dogStickerApply) {
		DogStickerApply po = dao.get(dogStickerApply.getId());
		po.setStickerPrintFlag("0");
		save(po);
	}

	@Transactional(readOnly = false)
	public String printRegisterCard(DogStickerApply dogStickerApply, Model model) throws ZAException {
		DogStickerApply po = dao.get(dogStickerApply.getId());
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "找不到该申请记录");
		}
		if (StringUtils.isBlank(po.getRegisterCardPrintFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "没有申请纯种犬身份登记卡");
		}
		if ("1".equals(dogStickerApply.getRegisterCardPrintFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请的贴纸已打印");
		}
		if (StringUtils.isBlank(dogStickerApply.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空，无法打印");
		}
		if (StringUtils.isBlank(dogStickerApply.getCabPassport())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "护照号为空，无法打印");
		}
		if (StringUtils.isBlank(dogStickerApply.getPaymentState()) && !"2".equals(dogStickerApply.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该申请未交费，无法打印");
		}
		Dog dog = dogDao.getNewOneByIdentificationFlag(po.getIdentificationFlag());
		String cabRegisterCode = "";
		String breederMemberCode = "";
		String color = "";
		Date birthdate = null;
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "找不到该犬只信息");
		} else {
			breederMemberCode = dog.getBreederMemberCode();
			birthdate = dog.getBirthdate();
			color = dog.getColorFlag();
			cabRegisterCode = dog.getCabRegisterCode();
			if (StringUtils.isBlank(cabRegisterCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "纯种犬身份登记编号为空");
			}
			if (StringUtils.isBlank(color) || StringUtils.isBlank(breederMemberCode) || birthdate == null) {
				List<DogBirthCertificate> birthList = dogBirthCertificateService
						.getByIdentificationFlagList(po.getIdentificationFlag());
				if (!Collections3.isEmpty(birthList)) {
					breederMemberCode = birthList.get(0).getBreederMemberCode();
					birthdate = birthList.get(0).getDogBirthday();
					color = birthList.get(0).getColorFlag();
				}
			}
		}
		po.setBirthday(birthdate);
		po.setCabRegisterCode(cabRegisterCode);
		po.setColorFlag(color);
		Kennel kennel = kennelDao.getKennelByMemberCode(breederMemberCode);
		if (kennel == null || StringUtils.isBlank(kennel.getName())) {
			po.setKennnelName("---");
		} else {
			po.setKennnelName(kennel.getName());
		}
		if (StringUtils.isNotBlank(dogStickerApply.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(dogStickerApply.getDogBreed());
			if (dogType != null) {
				po.setBreedCnName(dogType.getBreedCnName());
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, BIRTH_BUSINESS_NAME + cabRegisterCode + "的犬种"
						+ dogStickerApply.getDogBreed() + ",在犬种表无法找到对应的记录，请检查是否有该犬种");
			}
		}
		List<DogBirthCertificate> dogbirthList = dogBirthCertificateService
				.getByIdentificationFlagList(dogStickerApply.getIdentificationFlag());
		if (CollectionUtils.isNotEmpty(dogbirthList)
				&& dogbirthList.get(0).getCreateDate().getTime() > DogBirthCertificateService.newBusinessTimeMillis) {
			// 打印毛色只显示中文
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(po.getColorFlag());
			if (dogColorMark != null) {
				String colorFlag = dogColorMark.getDogColorMarkCn();
				if (colorFlag != null) {
					po.setColorFlag(colorFlag.substring(colorFlag.indexOf("-") + 1));
				}
			}
			
			po.setBirthCerRegCode(dogbirthList.get(0).getBirthCerRegCode());
		}
		expressQueueService.push(dogStickerApply.getPaymentMemberCode(), dogStickerApply.getRunningNumber(),
				BIRTH_BUSINESS_NAME, cabRegisterCode, "dog_sticker_apply", dogStickerApply.getId(), null);
		if (dogStickerApply.getNeedNewPassport().equals("1")) {
			expressQueueService.push(dogStickerApply.getPaymentMemberCode(), dogStickerApply.getRunningNumber(),
					"宠爱护照3.0", dogStickerApply.getCabPassport(), "dog_sticker_apply", dogStickerApply.getId(), null);
		}
		po.setRegisterCardPrintFlag("1");
		// 2020-05-01日起申请的等级贴纸不再打印、登记卡打印时等级贴纸变成已打印状态、但等级贴纸不插入dog_sticker表
		if (po.getCreateDate().getTime() >= DogBirthCertificateService.ACTICATION_OFF_MILLS) {
			po.setStickerPrintFlag("1");
		}
		save(po);
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, BIRTH_BUSINESS_NAME + "打印", dogStickerApply.getPaymentMemberCode(),
				"dog_sticker_apply", dogStickerApply.getId(), dogStickerApply.getRunningNumber(), (str) -> {
				});
		
		
		model.addAttribute("dogStickerApply", po);
		if (po.getCreateDate().getTime() >= DogBirthCertificateService.DOG_LEVELPRINT_MILLIS)
			return "oa/dog/dogstickerapply/registerCardNewPrint";
		else
			return "oa/dog/dogstickerapply/registerCardPrint";
	}

	private void volidateParam(DogStickerApply dogStickerApply) throws ZAException {
		if (StringUtils.isBlank(dogStickerApply.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空，无法打印");
		}
		if (StringUtils.isBlank(dogStickerApply.getCabPassport())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "护照号为空，无法打印");
		}
		if (StringUtils.isBlank(dogStickerApply.getPaymentState()) && !"2".equals(dogStickerApply.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该申请未交费，无法打印");
		}

	}

	@Transactional(readOnly = false)
	public void resetPrintRegisterCard(DogStickerApply dogStickerApply) {
		DogStickerApply po = dao.get(dogStickerApply.getId());
		po.setRegisterCardPrintFlag("0");
		save(po);
	}

	public void applySticker(Dog dog, String memberCode, String runningNumber) {
		String identificationFlag = dog.getIdentificationFlag();
		// 芯片号为空不能办理
		if (StringUtils.isBlank(identificationFlag)) {
			return;
		}
		int maxApplyClass = getMaxApplyClass(dog);
		int alreadyHaveMaxClass = getAlreadyHaveMaxClass(identificationFlag);
		if (maxApplyClass != alreadyHaveMaxClass) {
			Member member = memberDao.getByMemberCode(memberCode);
			DogStickerApply po = buildPo(identificationFlag, member);
			po.setPaymentState("2");
			po.setRunningNumber(runningNumber);
			save(po);
			startOne(po);
		}
	}

	/**
	 * 整窝办理血统证书申请贴纸
	 * 
	 * @param dog
	 * @param memberCode
	 * @param runningNumber
	 */
	public void applyAllNestSticker(Dog dog, String memberCode, String runningNumber, String needNewPassport) {
		String identificationFlag = dog.getIdentificationFlag();
		// 芯片号为空不能办理
		if (StringUtils.isBlank(identificationFlag)) {
			return;
		}
		int maxApplyClass = getMaxApplyClass(dog);
		int alreadyHaveMaxClass = getAlreadyHaveMaxClass(identificationFlag);
		if (maxApplyClass != alreadyHaveMaxClass) {
			Member member = memberDao.getByMemberCode(memberCode);
			DogStickerApply po = buildPo(identificationFlag, member);
			po.setPaymentState("2");
			po.setApplyClass("2");
			po.setRunningNumber(runningNumber);
			// 整窝办理、办理血统证书时需要新的护照
			po.setNeedNewPassport("1");
			// 2010-05-01 登记卡是否打印跟随护照
			po.setRegisterCardPrintFlag("0");
			// 2020年7月8日后申请缴费的整窝办理犬只，等级申请时取消是否需求新护照，变更为否
			if ("0".equals(needNewPassport)) {
				po.setNeedNewPassport("0");
			}
			save(po);
			startOne(po);
		}
	}

	public DogStickerApply buildPo(String identificationFlag, Member member) {
		DogStickerApply po = new DogStickerApply();
		po.setIdentificationFlag(identificationFlag);
		// 换发犬根据芯片号查会有两条记录，晚生成的记录血统证书号才是CKU血统证书号
		Dog dog = dogDao.getNewOneByIdentificationFlag(identificationFlag);
		if (dog != null) {
			po.setCabPassport(dog.getCabPassport());
			po.setDogBreed(dog.getDogBreed());
			po.setDogGender(dog.getGender());
			po.setPedigreeCertified(dog.getPedigreeCertifiedCode());
			po.setNameEn(dog.getNameEn());
			po.setApplyClass(getApplyClass(dog));
			po.setCabPassport(dog.getCabPassport());
			// 纯种犬身份登记卡打印标识
			if (StringUtils.isBlank(dog.getCabRegisterCode())) {
				po.setRegisterCardPrintFlag("0");
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优宠级（E）贴纸单独申请渠道暂未开放，开放时间请关注官网通知。您可在申请血统证书时完成宠爱护照及等级申请。");
			// DogBirthCertificate dogBirthCertificate =
			// dogBirthCertificateDao.getByIdentificationFlag(identificationFlag);
			// po.setCabPassport(dogBirthCertificate.getCabPassport());
			// po.setDogBreed(dogBirthCertificate.getDogBreed());
			// po.setDogGender(dogBirthCertificate.getDogGender());
			// po.setNameEn(dogBirthCertificate.getDogEnName());
			// po.setApplyClass(getApplyClass(dogBirthCertificate));
			// po.setCabPassport(dogBirthCertificate.getCabPassport());
			// if (StringUtils.isBlank(dogBirthCertificate.getCabRegisterCode())) {
			// po.setRegisterCardPrintFlag("0");
			// }
		}
		po.setPaymentMemberCode(member.getMemberCode());
		po.setPaymentMemberName(member.getName());
		po.setAlreadyHaveClass(getAlreadyHaveClass(identificationFlag));
		// 无护照或护照不以N开头，都需要新办护照
		// if (StringUtils.isEmpty(po.getCabPassport()))
		// po.setNeedNewPassport("1");//没有护照显示 是
		// else {
		// if (isNewCabPassport(po.getCabPassport()))
		// po.setNeedNewPassport("0");//有新护照 显示否
		// else
		// po.setNeedNewPassport("1"); //有老护照显示 是
		// }

		// TODO: 2019/8/30 N改成了J
		// if (dog != null && dog.getCreateDate() != null
		// && dog.getCreateDate().getTime() < DATA
		// && StringUtils.isNotEmpty(po.getCabPassport()))
		// if (isNewCabPassport(po.getCabPassport()))
		// po.setNeedNewPassport("0");//有新护照 不需要发放新护照
		// else
		// po.setNeedNewPassport("1"); //有老护照 需要发放新护照
		// else
		// po.setNeedNewPassport("1");//没有护照 需要发放新护照
		// TODO: 2019/8/14 更改原有需求
		// //旧护照需要寄回
		// if (StringUtils.isNotBlank(po.getCabPassport()) &&
		// !po.getCabPassport().startsWith(CAB_PASSPORT_STARTS_WITH)) {
		// po.setNeedReturnOldPassport("1");
		// } else {
		// po.setNeedReturnOldPassport("0");
		// }
		// TODO: 2019/9/2 源码 发放新护照字段 是根据dog表的护照号判断的， 源码 寄回老护照字段 是根据出生纸表护照号判断的。现在改成
		// 都根据出生纸表的护照号判断
		// 一.护照类型的判断逻辑：
		// (一)新护照：
		// 1.有出生纸，且2019年2月1日以前发放的，以J开头的护照。
		// 2.有出生纸，且2019年2月1日(含)以后发放的，以N开头的护照。
		// 3.无出生纸，且有以J开头的护照.
		// (二)老护照：
		// 1.有出生纸，且2019年2月1日以前发放的，以N或C开头的护照。
		// (三)无护照：
		// 1.有出生纸，护照号字段为空的。
		// 2.无出生纸、护照号字段为空。
		// 二.回寄老护照、发放新护照的逻辑：
		// 1.有新护照的：不需要回寄老护照，不需要发放新护照，护照号不变。
		// 2.有老护照的：需要回寄老护照，需要发放新护照。新护照号以J开头。
		// 3.没有护照的：不需要回寄老护照，需要发放新护照。新护照号以J开头。
		// `need_return_old_passport` tinyint(1) NOT NULL DEFAULT '0' COMMENT
		// '是否需要寄回旧护照:0不需要;1需要',
		// `need_new_passport` tinyint(1) NOT NULL DEFAULT '0' COMMENT
		// '是否需要新护照:0不需要;1需要',
		
		// update by zjw 2023-02-17 宠爱护照及贴纸不在发放 【ID1005116】取消宠爱护照发放恢复原出生纸捆绑芯片申请
		po.setNeedReturnOldPassport("0");
		po.setNeedNewPassport("0");
		po.setRegisterCardPrintFlag(null);
		po.setStickerPrintFlag(null);
		/**
		DogBirthCertificate dogb = dogBirthCertificateService.getByIdentificationFlag(identificationFlag);
		if (dogb != null && StringUtils.isNotEmpty(dogb.getCabPassport())) {
			String c = dogb.getCabPassport().toUpperCase();
			if (dogb.getCreateDate() != null && dogb.getCreateDate().getTime() < DATA
					&& (c.startsWith("N") || c.startsWith("C")))// 老护照
			{
				po.setNeedReturnOldPassport("1");// 寄回旧护照
				po.setNeedNewPassport("1");// 需要发放新护照
			}
			if (dogb.getCreateDate() != null
					&& ((dogb.getCreateDate().getTime() < DATA && c.startsWith(CAB_PASSPORT_STARTS_WITH))
							|| (dogb.getCreateDate().getTime() >= DATA) && c.startsWith("N"))) {
				po.setNeedReturnOldPassport("0"); // 旧护照不需要寄回
				po.setNeedNewPassport("0");// 不需要发放新护照
			}
		} else {
			// 无出生纸，并且dog表里有J开头的护照号 新护照
			if (StringUtils.isNotEmpty(po.getCabPassport())
					&& po.getCabPassport().toUpperCase().startsWith(CAB_PASSPORT_STARTS_WITH)) {
				po.setNeedReturnOldPassport("0"); // 旧护照不需要寄回
				po.setNeedNewPassport("0");// 不需要发放新护照
			}
			if (StringUtils.isEmpty(po.getCabPassport())) {
				po.setNeedReturnOldPassport("0");// 没有护照的：不需要回寄老护照
				po.setNeedNewPassport("1");// 没有护照 需要发放新护照
			}
		}
		// 2020-05-01日起 贴纸发放与否跟随护照 等级贴纸不再打印
		if (new Date().getTime() >= DogBirthCertificateService.ACTICATION_OFF_MILLS) {
			if (StringUtils.isNotBlank(po.getNeedNewPassport()) && "1".equals(po.getNeedNewPassport())) {
				po.setRegisterCardPrintFlag("0");
			} else {
				po.setRegisterCardPrintFlag(null);
			}
			po.setStickerPrintFlag(null);
		}**/
		return po;
	}

	@Transactional(readOnly = false)
	public void afterPay(String businessIds) {
		DogStickerApply po = dao.get(businessIds);
		startOne(po);
	}

	public void startOne(DogStickerApply po) {
		// 生成纯种犬登记卡编号
		updateDogCabRegisterCode(po);
		// 更新护照号
		updateCabPassport(po);
		// 贴纸表增加记录
		insertDogSticker(po);
	}

	// 贴纸表增加记录
	@Transactional(readOnly = false)
	public void insertDogSticker(DogStickerApply po) {
		po = dao.get(po.getId());
		// 已有等级贴纸
		List<String> stickerClass = Lists.newArrayList();
		List<DogSticker> dogStickerList = dogStickerDao.getByIdentificationFlag(po.getIdentificationFlag());
		for (DogSticker dogSticker : dogStickerList) {
			stickerClass.add(dogSticker.getStickerClass());
		}
		for (String dogClass : po.getApplyClass().split(",")) {
			if (!stickerClass.contains(dogClass)) {
				DogSticker dogSticker = new DogSticker();
				dogSticker.setIdentificationFlag(po.getIdentificationFlag());
				String cabPassport = po.getCabPassport();
				String stickerNo = cabPassport.substring(1);
				if ("1".equals(dogClass)) {
					stickerNo = "E" + stickerNo;
				} else if ("2".equals(dogClass)) {
					stickerNo = "P" + stickerNo;
				} else if ("3".equals(dogClass)) {
					stickerNo = "S" + stickerNo;
				} else if ("4".equals(dogClass)) {
					stickerNo = "SS" + stickerNo;
				}
				dogSticker.setStickerNo(stickerNo);
				dogSticker.setStickerClass(dogClass);
				dogSticker.preInsert();
				dogStickerDao.insert(dogSticker);
			}
		}
	}

	// 生成纯种犬登记卡编号
	@Transactional(readOnly = false)
	public void updateDogCabRegisterCode(DogStickerApply po) {
		Dog dog = dogDao.getNewOneByIdentificationFlag(po.getIdentificationFlag());
		if (StringUtils.isBlank(dog.getCabRegisterCode())) {
			dog.setCabRegisterCode(getCabRegisterCode(po));
			dog.preUpdate();
			dogDao.update(dog);
		}
	}

	// 获取纯种犬身份登记卡编号
	public String getCabRegisterCode(DogStickerApply po) {
		String identificationFlag = po.getIdentificationFlag();
		StringBuilder stringBuilder = new StringBuilder("A");
		stringBuilder.append(DateFormatUtils.format(po.getCreateDate(), "ddMM"));
		stringBuilder.append(identificationFlag.substring(identificationFlag.length() - 6));
		stringBuilder.append("/");
		stringBuilder.append(DateFormatUtils.format(po.getCreateDate(), "yy"));
		return stringBuilder.toString();
	}

	// 更新护照号
	@Transactional(readOnly = false)
	public void updateCabPassport(DogStickerApply po) {
		Dog dog = dogDao.getNewOneByIdentificationFlag(po.getIdentificationFlag());
		if (dog != null) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByIdentificationFlag(po.getIdentificationFlag());
			boolean b;
			if (dogBirthCertificate != null)
				b = isOldCabPassport(dogBirthCertificate.getCabPassport(),
						dogBirthCertificate.getCreateDate().getTime());
			else
				b = isOldCabPassport(dog.getCabPassport(), dog.getCreateDate().getTime());
			if (!b)
				return;
			// if (!isNewCabPassport(dog.getCabPassport())) {
			// 生成护照号
			Map<String, String> resultMap = dogBirthCertificateService.createCabCodeReGet(po.getIdentificationFlag(),po.getPedigreeCertified());
			String cabPassport = resultMap.get("cabPassport");
			// 更新dog表护照号
			dog.setCabPassport(cabPassport);
			dog.preUpdate();
			dogDao.update(dog);

			if (dogBirthCertificate != null) {
				// 更新dog_birth_certificate表护照号
				dogBirthCertificate.setCabPassport(cabPassport);
				dogBirthCertificate.preUpdate();
				dogBirthCertificateDao.update(dogBirthCertificate);
			}
			// 更新dog_sticker_apply表护照号
			po = dao.get(po.getId());
			po.setCabPassport(cabPassport);
			save(po);
		}
	}

	// //判断是否是新护照
	// private boolean isNewCabPassport(String cabPassport) {
	// //J开头的是新护照
	// if (StringUtils.isNotBlank(cabPassport) &&
	// cabPassport.toUpperCase().startsWith(CAB_PASSPORT_STARTS_WITH))
	// return true;
	// return false;
	// }
	// 判断是否是新护照
	// 老护照 或者没有护照 需要生成新护照 新生成护照J开头
	private boolean isOldCabPassport(String c, Long l) {
		c = c.toUpperCase();
		// 护照号为空
		if (StringUtils.isEmpty(c))
			return true;
		// 老护照：.有出生纸，且2019年2月1日以前发放的，以N或C开头的护照。
		if (l != null && l < DATA && (c.startsWith("N") || c.startsWith("C")))
			return true;
		return false;
	}

	public String getBusinessStates(DogStickerApply po) {
		String registerCardPrintFlag = po.getRegisterCardPrintFlag();
		Date sendDate = po.getSendDate();
		String paymentState = po.getPaymentState();
		String stickerPrintFlag = po.getStickerPrintFlag();
		if (!"2".equals(paymentState)) {
			return "待缴费";
		} else {
			return "已完成";
//			if (!"1".equals(registerCardPrintFlag) && !"1".equals(stickerPrintFlag)) {
//				return "待打印";
//			} else if (!"1".equals(registerCardPrintFlag)) {
//				if (StringUtils.isNotBlank(registerCardPrintFlag)) {
//					return "待打印登记卡";
//				} else {
//					if (null != sendDate && System.currentTimeMillis() >= sendDate.getTime()) {
//						return "已邮寄";
//					}
//					return "待邮寄";
//				}
//			} else if (!"1".equals(stickerPrintFlag)) {
//				return "待打印等级贴纸";
//			} else {
//				if (null != sendDate && System.currentTimeMillis() >= sendDate.getTime()) {
//					return "已邮寄";
//				}
//				return "待邮寄";
//			}
		}
	}

	@Transactional(readOnly = false)
	public RESTResponse post(HttpServletRequest request) {
		// 获取参数
		// JSONObject jo = JSONObject.fromObject(json);
		String identificationFlag = request.getParameter("identificationFlag");
		String memberCode = request.getParameter("memberCode");
		String orderCode = request.getParameter("orderCode");
		String chargingItemId = request.getParameter("chargingItemId");
		String detailId = request.getParameter("id");
		// 参数校验
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		// 获取会员号
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		// 获取订单号 收费项id
		if (StringUtils.isBlank(orderCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单为空");
		}
		if (StringUtils.isBlank(chargingItemId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收费项为空");
		}
		Member member = memberService.getByMemberCode(memberCode);
		// 构造持久对象(复用会员中心接口)
		DogStickerApply po = this.buildPo(identificationFlag, member);
		// 业务校验(复用会员中心接口)
		this.validateBusiness(po);
		// 写入业务表(复用会员中心接口)
		this.save(po);
		String sqlOrder = "UPDATE payment_order_detail set business_ids='" + po.getId()
				+ "',business_table='dog_sticker_apply' where order_code='" + orderCode + "'" + " and id='" + detailId
				+ "'";
		int a = paymentRecordDao.changePaymentState(sqlOrder);
		if (a <= 0) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改订单业务状态失败！");
		}
		// 查询订单
		PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(orderCode);
		String paymentTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(paymentOrder.getPaymentTime());
		// 修改业务状态为以支付
		StringBuffer sql = new StringBuffer();
		sql.append("UPDATE " + "dog_sticker_apply" + " SET payment_state = 2,payment_time = '" + paymentTime
				+ "',running_number='" + orderCode + "' WHERE id = '").append(po.getId()).append("'");
		int j = paymentRecordDao.changePaymentState(sql.toString());
		if (j <= 0) {
			throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改业务状态失败！");
		}
		// 付款后
		this.afterPay(po.getId());
		JSONObject data = new JSONObject();
		return new RESTResponse("data", data);
	}

}
