package com.cku.oa.dog.service;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.cku.util.ChineseUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedExportDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.service.dogamphimixis.DogAmphimixisProveService;
import com.cku.oa.dog.util.PedigreeCertifiedCodeUtil;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.restful.v1.dog.model.SysCountry;
import com.cku.util.DateUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/**
 * 出口证书申请Service
 * 
 * @author lgl
 * @version 2016-08-19
 */
@Service
@Transactional(readOnly = true)
public class DogPedigreeCertifiedExportService
		extends CrudService<DogPedigreeCertifiedExportDao, DogPedigreeCertifiedExport> {

	private static final String BUSINESS_NAME = "证书出口";

	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private DogNewbornDao dogNewbornDao;
	@Autowired
	private ExpressQueueService expressQueueService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private DogAmphimixisProveService dogAmphimixisProveService;
	@Autowired
	private BusinessBanService businessBanService;
	@Autowired
	private KennelDao kennelDao;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;

	public DogPedigreeCertifiedExport get(String id) {
		return super.get(id);
	}

	/**
	 * 
	 * @description: 证书出口打印
	 * @author: laiguanglong
	 * @date: 2016年8月30日 下午2:30:45
	 */
	@Transactional(readOnly = false)
	public String print(DogPedigreeCertifiedExport print, Model model) throws ZAException {
		DogPedigreeCertifiedExport dogPedigreeCertifiedExport = super.get(print.getId());
		Dog dog = dogService.get(dogPedigreeCertifiedExport.getDogId());
		return dogService.processPrintBusiness(dog,model,Boolean.TRUE);
	}

	public String getMemberNameEn(String memberCode) {
		StringBuffer name = new StringBuffer();
		if (StringUtils.isNotBlank(memberCode)) {
			Member member = memberService.getByMemberCode(memberCode);
			if (Objects.nonNull(member)) {
				if (StringUtils.isNoneBlank(member.getName()) && !ChineseUtils.isContainChinese(member.getName())) {
					name.append(member.getName());
				} else {
					if (StringUtils.isNoneBlank(member.getNameEn())) {
						// 英文名 字母串中间第一个空格分割 把第一分部放到字符串最后
						String[] nameStrs = member.getNameEn().split(" ", 2);
						if (nameStrs.length > 1) {
							name.append(nameStrs[1]);
							name.append(" ");
							name.append(nameStrs[0]);
						} else {
							name.append(member.getNameEn());
						}
					}
				}
				if (StringUtils.isBlank(name)) {
					name.append(ChineseUtils.getFullSpell(member.getNameEn()));
				}
			}
		}
		return name.toString();
	}


	public void set3GenerationNew(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Dog dog) {
		// logger.info("dog:" + dog.getPedigreeCertifiedCode());
		dogPedigreeCertifiedExport.setDog(dog);
		dog.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedCode()));
		dog.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedEn()));
		Dog dog1 = dogService.getByPedigreeCertifiedCode(dog.getFdogPedigreeCertified());
		if (dog1 != null && StringUtils.isNotBlank(dog.getFdogPedigreeCertified())) {
			// logger.info("dog1:" + dog1.getPedigreeCertifiedCode());
			dog1.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog1.getPedigreeCertifiedCode()));
			dog1.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog1.getPedigreeCertifiedEn()));
			dogPedigreeCertifiedExport.setDog1(dog1);
			Dog dog3 = dogService.getByPedigreeCertifiedCode(dog1.getFdogPedigreeCertified());
			// logger.info("dog3:" + dog3.getPedigreeCertifiedCode());
			if (dog3 != null && StringUtils.isNotBlank(dog1.getFdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog3(dog3);
			}
			// if(dog3!=null&&StringUtils.isNotBlank(dog1.getFdogPedigreeCertified())){
			// dog3.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog3.getPedigreeCertifiedCode()));
			// dog3.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog3.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog3(dog3);
			// Dog dog7 =
			// dogService.getByPedigreeCertifiedCode(dog3.getFdogPedigreeCertified());
			// logger.info("dog7:" + dog7.getPedigreeCertifiedCode());
			// if(dog7!=null&&StringUtils.isNotBlank(dog3.getFdogPedigreeCertified())){
			// dog7.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog7.getPedigreeCertifiedCode()));
			// dog7.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog7.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog7(dog7);
			// Dog dog15 =
			// dogService.getByPedigreeCertifiedCode(dog7.getFdogPedigreeCertified());
			// logger.info("dog15:" + dog15.getPedigreeCertifiedCode());
			// if(dog15!=null&&StringUtils.isNotBlank(dog7.getFdogPedigreeCertified())){
			// dog15.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog15.getPedigreeCertifiedCode()));
			// dog15.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog15.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog15(dog15);
			// }
			// Dog dog16 =
			// dogService.getByPedigreeCertifiedCode(dog7.getMdogPedigreeCertified());
			// logger.info("dog16:" + dog16.getPedigreeCertifiedCode());
			// if(dog16!=null&&StringUtils.isNotBlank(dog7.getMdogPedigreeCertified())){
			// dog16.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog16.getPedigreeCertifiedCode()));
			// dog16.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog16.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog16(dog16);
			// }
			// }
			// Dog dog8 =
			// dogService.getByPedigreeCertifiedCode(dog3.getMdogPedigreeCertified());
			// logger.info("dog8:" + dog8.getPedigreeCertifiedCode());
			// if(dog8!=null&&StringUtils.isNotBlank(dog3.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog8(dog8);
			// dog8.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog8.getPedigreeCertifiedCode()));
			// dog8.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog8.getPedigreeCertifiedEn()));
			// Dog dog17 =
			// dogService.getByPedigreeCertifiedCode(dog8.getFdogPedigreeCertified());
			// logger.info("dog17:" + dog17.getPedigreeCertifiedCode());
			// if(dog17!=null&&StringUtils.isNotBlank(dog8.getFdogPedigreeCertified())){
			// dog17.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog17.getPedigreeCertifiedCode()));
			// dog17.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog17.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog17(dog17);
			// }
			// Dog dog18 =
			// dogService.getByPedigreeCertifiedCode(dog8.getMdogPedigreeCertified());
			// logger.info("dog18:" + dog18.getPedigreeCertifiedCode());
			// if(dog18!=null&&StringUtils.isNotBlank(dog8.getMdogPedigreeCertified())){
			// dog18.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog18.getPedigreeCertifiedCode()));
			// dog18.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog18.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog18(dog18);
			// }
			// }
			// }
			Dog dog4 = dogService.getByPedigreeCertifiedCode(dog1.getMdogPedigreeCertified());
			if (dog4 != null && StringUtils.isNotBlank(dog1.getMdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog4(dog4);
			}
			// logger.info("dog4:" + dog4.getPedigreeCertifiedCode());
			// if(dog4!=null&&StringUtils.isNotBlank(dog1.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog4(dog4);
			// dog4.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog4.getPedigreeCertifiedCode()));
			// dog4.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog4.getPedigreeCertifiedEn()));
			// Dog dog9 =
			// dogService.getByPedigreeCertifiedCode(dog4.getFdogPedigreeCertified());
			// logger.info("dog9:" + dog9.getPedigreeCertifiedCode());
			// if(dog9!=null&&StringUtils.isNotBlank(dog4.getFdogPedigreeCertified())){
			// dog9.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog9.getPedigreeCertifiedCode()));
			// dog9.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog9.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog9(dog9);
			// Dog dog19 =
			// dogService.getByPedigreeCertifiedCode(dog9.getFdogPedigreeCertified());
			// logger.info("dog19:" + dog19.getPedigreeCertifiedCode());
			// if(dog19!=null&&StringUtils.isNotBlank(dog9.getFdogPedigreeCertified())){
			// dog19.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog19.getPedigreeCertifiedCode()));
			// dog19.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog19.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog19(dog19);
			// }
			// Dog dog20 =
			// dogService.getByPedigreeCertifiedCode(dog9.getMdogPedigreeCertified());
			// logger.info("dog20:" + dog20.getPedigreeCertifiedCode());
			// if(dog20!=null&&StringUtils.isNotBlank(dog9.getMdogPedigreeCertified())){
			// dog20.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog20.getPedigreeCertifiedCode()));
			// dog20.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog20.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog20(dog20);
			// }
			// }
			// Dog dog10 =
			// dogService.getByPedigreeCertifiedCode(dog4.getMdogPedigreeCertified());
			// logger.info("dog10:" + dog10.getPedigreeCertifiedCode());
			// if(dog10!=null&&StringUtils.isNotBlank(dog4.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog10(dog10);
			// dog10.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog10.getPedigreeCertifiedCode()));
			// dog10.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog10.getPedigreeCertifiedEn()));
			// Dog dog21 =
			// dogService.getByPedigreeCertifiedCode(dog10.getFdogPedigreeCertified());
			// logger.info("dog21:" + dog21.getPedigreeCertifiedCode());
			// if(dog21!=null&&StringUtils.isNotBlank(dog10.getFdogPedigreeCertified())){
			// dog21.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog21.getPedigreeCertifiedCode()));
			// dog21.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog21.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog21(dog21);
			// }
			// Dog dog22 =
			// dogService.getByPedigreeCertifiedCode(dog10.getMdogPedigreeCertified());
			// logger.info("dog22:" + dog22.getPedigreeCertifiedCode());
			// if(dog22!=null&&StringUtils.isNotBlank(dog10.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog22(dog22);
			// dog22.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog22.getPedigreeCertifiedCode()));
			// dog22.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog22.getPedigreeCertifiedEn()));
			// }
			// }
			// }
		}
		Dog dog2 = dogService.getByPedigreeCertifiedCode(dog.getMdogPedigreeCertified());
		// logger.info("dog2:" + dog2.getPedigreeCertifiedCode());
		if (dog2 != null && StringUtils.isNotBlank(dog.getMdogPedigreeCertified())) {
			dogPedigreeCertifiedExport.setDog2(dog2);
			dog2.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog2.getPedigreeCertifiedCode()));
			dog2.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog2.getPedigreeCertifiedEn()));
			Dog dog5 = dogService.getByPedigreeCertifiedCode(dog2.getFdogPedigreeCertified());
			// logger.info("dog5:" + dog5.getPedigreeCertifiedCode());
			if (dog5 != null && StringUtils.isNotBlank(dog2.getFdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog5(dog5);
			}
			// if(dog5!=null&&StringUtils.isNotBlank(dog2.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog5(dog5);
			// dog5.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog5.getPedigreeCertifiedCode()));
			// dog5.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog5.getPedigreeCertifiedEn()));
			// Dog dog11 =
			// dogService.getByPedigreeCertifiedCode(dog5.getFdogPedigreeCertified());
			// logger.info("dog11:" + dog11.getPedigreeCertifiedCode());
			// if(dog11!=null&&StringUtils.isNotBlank(dog5.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog11(dog11);
			// dog11.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog11.getPedigreeCertifiedCode()));
			// dog11.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog11.getPedigreeCertifiedEn()));
			// Dog dog23 =
			// dogService.getByPedigreeCertifiedCode(dog11.getFdogPedigreeCertified());
			// logger.info("dog23:" + dog23.getPedigreeCertifiedCode());
			// if(dog23!=null&&StringUtils.isNotBlank(dog11.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog23(dog23);
			// dog23.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog23.getPedigreeCertifiedCode()));
			// dog23.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog23.getPedigreeCertifiedEn()));
			// }
			// Dog dog24 =
			// dogService.getByPedigreeCertifiedCode(dog11.getMdogPedigreeCertified());
			// logger.info("dog24:" + dog24.getPedigreeCertifiedCode());
			// if(dog24!=null&&StringUtils.isNotBlank(dog11.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog24(dog24);
			// dog24.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog24.getPedigreeCertifiedCode()));
			// dog24.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog24.getPedigreeCertifiedEn()));
			// }
			// }
			// Dog dog12 =
			// dogService.getByPedigreeCertifiedCode(dog5.getMdogPedigreeCertified());
			// logger.info("dog12:" + dog12.getPedigreeCertifiedCode());
			// if(dog12!=null&&StringUtils.isNotBlank(dog5.getMdogPedigreeCertified())){
			// dog12.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog12.getPedigreeCertifiedCode()));
			// dog12.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog12.getPedigreeCertifiedEn()));
			// dogPedigreeCertifiedExport.setDog12(dog12);
			// Dog dog25 =
			// dogService.getByPedigreeCertifiedCode(dog12.getFdogPedigreeCertified());
			// logger.info("dog25:" + dog25.getPedigreeCertifiedCode());
			// if(dog25!=null&&StringUtils.isNotBlank(dog12.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog25(dog25);
			// dog25.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog25.getPedigreeCertifiedCode()));
			// dog25.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog25.getPedigreeCertifiedEn()));
			// }
			// Dog dog26 =
			// dogService.getByPedigreeCertifiedCode(dog12.getMdogPedigreeCertified());
			// logger.info("dog26:" + dog26.getPedigreeCertifiedCode());
			// if(dog26!=null&&StringUtils.isNotBlank(dog12.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog26(dog26);
			// dog26.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog26.getPedigreeCertifiedCode()));
			// dog26.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog26.getPedigreeCertifiedEn()));
			// }
			// }
			// }
			Dog dog6 = dogService.getByPedigreeCertifiedCode(dog2.getMdogPedigreeCertified());
			// logger.info("dog6:" + dog6.getPedigreeCertifiedCode());
			if (dog6 != null && StringUtils.isNotBlank(dog2.getMdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog6(dog6);
			}
			// if(dog6!=null&&StringUtils.isNotBlank(dog2.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog6(dog6);
			// dog6.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog6.getPedigreeCertifiedCode()));
			// dog6.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog6.getPedigreeCertifiedEn()));
			// Dog dog13 =
			// dogService.getByPedigreeCertifiedCode(dog6.getFdogPedigreeCertified());
			// logger.info("dog13:" + dog13.getPedigreeCertifiedCode());
			// if(dog13!=null&&StringUtils.isNotBlank(dog6.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog13(dog13);
			// dog13.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog13.getPedigreeCertifiedCode()));
			// dog13.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog13.getPedigreeCertifiedEn()));
			// Dog dog27 =
			// dogService.getByPedigreeCertifiedCode(dog13.getFdogPedigreeCertified());
			// logger.info("dog27:" + dog27.getPedigreeCertifiedCode());
			// if(dog27!=null&&StringUtils.isNotBlank(dog13.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog27(dog27);
			// dog27.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog27.getPedigreeCertifiedCode()));
			// dog27.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog27.getPedigreeCertifiedEn()));
			// }
			// Dog dog28 =
			// dogService.getByPedigreeCertifiedCode(dog13.getMdogPedigreeCertified());
			// logger.info("dog28:" + dog28.getPedigreeCertifiedCode());
			// if(dog28!=null&&StringUtils.isNotBlank(dog13.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog28(dog28);
			// dog28.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog28.getPedigreeCertifiedCode()));
			// dog28.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog28.getPedigreeCertifiedEn()));
			// }
			// }
			// Dog dog14 =
			// dogService.getByPedigreeCertifiedCode(dog6.getMdogPedigreeCertified());
			// logger.info("dog14:" + dog14.getPedigreeCertifiedCode());
			// if(dog14!=null&&StringUtils.isNotBlank(dog6.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog14(dog14);
			// dog14.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog14.getPedigreeCertifiedCode()));
			// dog14.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog14.getPedigreeCertifiedEn()));
			// Dog dog29 =
			// dogService.getByPedigreeCertifiedCode(dog14.getFdogPedigreeCertified());
			// logger.info("dog29:" + dog29.getPedigreeCertifiedCode());
			// if(dog29!=null&&StringUtils.isNotBlank(dog14.getFdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog29(dog29);
			// dog29.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog29.getPedigreeCertifiedCode()));
			// dog29.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog29.getPedigreeCertifiedEn()));
			// }
			// Dog dog30 =
			// dogService.getByPedigreeCertifiedCode(dog14.getMdogPedigreeCertified());
			// logger.info("dog30:" + dog30.getPedigreeCertifiedCode());
			// if(dog30!=null&&StringUtils.isNotBlank(dog14.getMdogPedigreeCertified())){
			// dogPedigreeCertifiedExport.setDog30(dog30);
			// dog30.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog30.getPedigreeCertifiedCode()));
			// dog30.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog30.getPedigreeCertifiedEn()));
			// }
			// }
			// }
		}
	}

	/**
	 * 
	 * @description: 设置上三代的信息
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午2:42:46
	 */
	public void set3Generation(DogPedigreeCertifiedExport dogPedigreeCertifiedExport, Dog dog) {
		dogPedigreeCertifiedExport.setDog(dog);
		dog.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedCode()));
		dog.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog.getPedigreeCertifiedEn()));
		Dog dog1 = dogService.getByPedigreeCertifiedCode(dog.getFdogPedigreeCertified());
		if (dog1 != null && StringUtils.isNotBlank(dog.getFdogPedigreeCertified())) {
			dog1.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog1.getPedigreeCertifiedCode()));
			dog1.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog1.getPedigreeCertifiedEn()));
			dogPedigreeCertifiedExport.setDog1(dog1);
			Dog dog3 = dogService.getByPedigreeCertifiedCode(dog1.getFdogPedigreeCertified());
			if (dog3 != null && StringUtils.isNotBlank(dog1.getFdogPedigreeCertified())) {
				dog3.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog3.getPedigreeCertifiedCode()));
				dog3.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog3.getPedigreeCertifiedEn()));
				dogPedigreeCertifiedExport.setDog3(dog3);
				Dog dog7 = dogService.getByPedigreeCertifiedCode(dog3.getFdogPedigreeCertified());
				if (dog7 != null && StringUtils.isNotBlank(dog3.getFdogPedigreeCertified())) {
					dog7.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog7.getPedigreeCertifiedCode()));
					dog7.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog7.getPedigreeCertifiedEn()));
					dogPedigreeCertifiedExport.setDog7(dog7);
					Dog dog15 = dogService.getByPedigreeCertifiedCode(dog7.getFdogPedigreeCertified());
					if (dog15 != null && StringUtils.isNotBlank(dog7.getFdogPedigreeCertified())) {
						dog15.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog15.getPedigreeCertifiedCode()));
						dog15.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog15.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog15(dog15);
					}
					Dog dog16 = dogService.getByPedigreeCertifiedCode(dog7.getMdogPedigreeCertified());
					if (dog16 != null && StringUtils.isNotBlank(dog7.getMdogPedigreeCertified())) {
						dog16.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog16.getPedigreeCertifiedCode()));
						dog16.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog16.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog16(dog16);
					}
				}
				Dog dog8 = dogService.getByPedigreeCertifiedCode(dog3.getMdogPedigreeCertified());
				if (dog8 != null && StringUtils.isNotBlank(dog3.getMdogPedigreeCertified())) {
					dogPedigreeCertifiedExport.setDog8(dog8);
					dog8.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog8.getPedigreeCertifiedCode()));
					dog8.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog8.getPedigreeCertifiedEn()));
					Dog dog17 = dogService.getByPedigreeCertifiedCode(dog8.getFdogPedigreeCertified());
					if (dog17 != null && StringUtils.isNotBlank(dog8.getFdogPedigreeCertified())) {
						dog17.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog17.getPedigreeCertifiedCode()));
						dog17.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog17.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog17(dog17);
					}
					Dog dog18 = dogService.getByPedigreeCertifiedCode(dog8.getMdogPedigreeCertified());
					if (dog18 != null && StringUtils.isNotBlank(dog8.getMdogPedigreeCertified())) {
						dog18.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog18.getPedigreeCertifiedCode()));
						dog18.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog18.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog18(dog18);
					}
				}
			}
			Dog dog4 = dogService.getByPedigreeCertifiedCode(dog1.getMdogPedigreeCertified());
			if (dog4 != null && StringUtils.isNotBlank(dog1.getMdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog4(dog4);
				dog4.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog4.getPedigreeCertifiedCode()));
				dog4.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog4.getPedigreeCertifiedEn()));
				Dog dog9 = dogService.getByPedigreeCertifiedCode(dog4.getFdogPedigreeCertified());
				if (dog9 != null && StringUtils.isNotBlank(dog4.getFdogPedigreeCertified())) {
					dog9.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog9.getPedigreeCertifiedCode()));
					dog9.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog9.getPedigreeCertifiedEn()));
					dogPedigreeCertifiedExport.setDog9(dog9);
					Dog dog19 = dogService.getByPedigreeCertifiedCode(dog9.getFdogPedigreeCertified());
					if (dog19 != null && StringUtils.isNotBlank(dog9.getFdogPedigreeCertified())) {
						dog19.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog19.getPedigreeCertifiedCode()));
						dog19.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog19.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog19(dog19);
					}
					Dog dog20 = dogService.getByPedigreeCertifiedCode(dog9.getMdogPedigreeCertified());
					if (dog20 != null && StringUtils.isNotBlank(dog9.getMdogPedigreeCertified())) {
						dog20.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog20.getPedigreeCertifiedCode()));
						dog20.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog20.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog20(dog20);
					}
				}
				Dog dog10 = dogService.getByPedigreeCertifiedCode(dog4.getMdogPedigreeCertified());
				if (dog10 != null && StringUtils.isNotBlank(dog4.getMdogPedigreeCertified())) {
					dogPedigreeCertifiedExport.setDog10(dog10);
					dog10.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog10.getPedigreeCertifiedCode()));
					dog10.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog10.getPedigreeCertifiedEn()));
					Dog dog21 = dogService.getByPedigreeCertifiedCode(dog10.getFdogPedigreeCertified());
					if (dog21 != null && StringUtils.isNotBlank(dog10.getFdogPedigreeCertified())) {
						dog21.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog21.getPedigreeCertifiedCode()));
						dog21.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog21.getPedigreeCertifiedEn()));
						dogPedigreeCertifiedExport.setDog21(dog21);
					}
					Dog dog22 = dogService.getByPedigreeCertifiedCode(dog10.getMdogPedigreeCertified());
					if (dog22 != null && StringUtils.isNotBlank(dog10.getMdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog22(dog22);
						dog22.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog22.getPedigreeCertifiedCode()));
						dog22.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog22.getPedigreeCertifiedEn()));
					}
				}
			}
		}
		Dog dog2 = dogService.getByPedigreeCertifiedCode(dog.getMdogPedigreeCertified());
		if (dog2 != null && StringUtils.isNotBlank(dog.getMdogPedigreeCertified())) {
			dogPedigreeCertifiedExport.setDog2(dog2);
			dog2.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog2.getPedigreeCertifiedCode()));
			dog2.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog2.getPedigreeCertifiedEn()));
			Dog dog5 = dogService.getByPedigreeCertifiedCode(dog2.getFdogPedigreeCertified());
			if (dog5 != null && StringUtils.isNotBlank(dog2.getFdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog5(dog5);
				dog5.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog5.getPedigreeCertifiedCode()));
				dog5.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog5.getPedigreeCertifiedEn()));
				Dog dog11 = dogService.getByPedigreeCertifiedCode(dog5.getFdogPedigreeCertified());
				if (dog11 != null && StringUtils.isNotBlank(dog5.getFdogPedigreeCertified())) {
					dogPedigreeCertifiedExport.setDog11(dog11);
					dog11.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog11.getPedigreeCertifiedCode()));
					dog11.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog11.getPedigreeCertifiedEn()));
					Dog dog23 = dogService.getByPedigreeCertifiedCode(dog11.getFdogPedigreeCertified());
					if (dog23 != null && StringUtils.isNotBlank(dog11.getFdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog23(dog23);
						dog23.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog23.getPedigreeCertifiedCode()));
						dog23.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog23.getPedigreeCertifiedEn()));
					}
					Dog dog24 = dogService.getByPedigreeCertifiedCode(dog11.getMdogPedigreeCertified());
					if (dog24 != null && StringUtils.isNotBlank(dog11.getMdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog24(dog24);
						dog24.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog24.getPedigreeCertifiedCode()));
						dog24.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog24.getPedigreeCertifiedEn()));
					}
				}
				Dog dog12 = dogService.getByPedigreeCertifiedCode(dog5.getMdogPedigreeCertified());
				if (dog12 != null && StringUtils.isNotBlank(dog5.getMdogPedigreeCertified())) {
					dog12.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog12.getPedigreeCertifiedCode()));
					dog12.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog12.getPedigreeCertifiedEn()));
					dogPedigreeCertifiedExport.setDog12(dog12);
					Dog dog25 = dogService.getByPedigreeCertifiedCode(dog12.getFdogPedigreeCertified());
					if (dog25 != null && StringUtils.isNotBlank(dog12.getFdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog25(dog25);
						dog25.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog25.getPedigreeCertifiedCode()));
						dog25.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog25.getPedigreeCertifiedEn()));
					}
					Dog dog26 = dogService.getByPedigreeCertifiedCode(dog12.getMdogPedigreeCertified());
					if (dog26 != null && StringUtils.isNotBlank(dog12.getMdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog26(dog26);
						dog26.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog26.getPedigreeCertifiedCode()));
						dog26.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog26.getPedigreeCertifiedEn()));
					}
				}
			}
			Dog dog6 = dogService.getByPedigreeCertifiedCode(dog2.getMdogPedigreeCertified());
			if (dog6 != null && StringUtils.isNotBlank(dog2.getMdogPedigreeCertified())) {
				dogPedigreeCertifiedExport.setDog6(dog6);
				dog6.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog6.getPedigreeCertifiedCode()));
				dog6.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog6.getPedigreeCertifiedEn()));
				Dog dog13 = dogService.getByPedigreeCertifiedCode(dog6.getFdogPedigreeCertified());
				if (dog13 != null && StringUtils.isNotBlank(dog6.getFdogPedigreeCertified())) {
					dogPedigreeCertifiedExport.setDog13(dog13);
					dog13.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog13.getPedigreeCertifiedCode()));
					dog13.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog13.getPedigreeCertifiedEn()));
					Dog dog27 = dogService.getByPedigreeCertifiedCode(dog13.getFdogPedigreeCertified());
					if (dog27 != null && StringUtils.isNotBlank(dog13.getFdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog27(dog27);
						dog27.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog27.getPedigreeCertifiedCode()));
						dog27.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog27.getPedigreeCertifiedEn()));
					}
					Dog dog28 = dogService.getByPedigreeCertifiedCode(dog13.getMdogPedigreeCertified());
					if (dog28 != null && StringUtils.isNotBlank(dog13.getMdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog28(dog28);
						dog28.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog28.getPedigreeCertifiedCode()));
						dog28.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog28.getPedigreeCertifiedEn()));
					}
				}
				Dog dog14 = dogService.getByPedigreeCertifiedCode(dog6.getMdogPedigreeCertified());
				if (dog14 != null && StringUtils.isNotBlank(dog6.getMdogPedigreeCertified())) {
					dogPedigreeCertifiedExport.setDog14(dog14);
					dog14.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(dog14.getPedigreeCertifiedCode()));
					dog14.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog14.getPedigreeCertifiedEn()));
					Dog dog29 = dogService.getByPedigreeCertifiedCode(dog14.getFdogPedigreeCertified());
					if (dog29 != null && StringUtils.isNotBlank(dog14.getFdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog29(dog29);
						dog29.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog29.getPedigreeCertifiedCode()));
						dog29.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog29.getPedigreeCertifiedEn()));
					}
					Dog dog30 = dogService.getByPedigreeCertifiedCode(dog14.getMdogPedigreeCertified());
					if (dog30 != null && StringUtils.isNotBlank(dog14.getMdogPedigreeCertified())) {
						dogPedigreeCertifiedExport.setDog30(dog30);
						dog30.setPedigreeCertifiedCode(
								PedigreeCertifiedCodeUtil.getCode(dog30.getPedigreeCertifiedCode()));
						dog30.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(dog30.getPedigreeCertifiedEn()));
					}
				}
			}
		}
	}

	/**
	 * 
	 * @description: 重置证书出口打印
	 * @author: laiguanglong
	 * @date: 2016年9月1日 下午3:13:01
	 */
	@Transactional(readOnly = false)
	public void resetPrint(DogPedigreeCertifiedExport resetPrint) {
		// 准备打印数据
		DogPedigreeCertifiedExport dogPedigreeCertifiedExport = super.get(resetPrint.getId());
		Dog dog = dogService.get(dogPedigreeCertifiedExport.getDogId());
		// 修改打印状态
		if ("03".equals(dog.getPrintState())) {
			dog.setPrintState("3");
			dogService.updatePrintState(dog);
		}
	}

	public List<DogPedigreeCertifiedExport> findList(DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		if (StringUtils.isBlank(dogPedigreeCertifiedExport.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogPedigreeCertifiedExport.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogPedigreeCertifiedExport.getSqlMap().put("dogBreedMap",
					" ='" + dogPedigreeCertifiedExport.getDogBreed() + "'");
		}
		return super.findList(dogPedigreeCertifiedExport);
	}

	public Page<DogPedigreeCertifiedExport> findPage(Page<DogPedigreeCertifiedExport> page,
			DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		if (StringUtils.isBlank(dogPedigreeCertifiedExport.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogPedigreeCertifiedExport.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogPedigreeCertifiedExport.getSqlMap().put("dogBreedMap",
					" ='" + dogPedigreeCertifiedExport.getDogBreed() + "'");
		}
		return super.findPage(page, dogPedigreeCertifiedExport);
	}

	@Transactional(readOnly = false)
	public void save(DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		super.save(dogPedigreeCertifiedExport);
	}

	@Transactional(readOnly = false)
	public void delete(DogPedigreeCertifiedExport dogPedigreeCertifiedExport) {
		super.delete(dogPedigreeCertifiedExport);
	}

	/**
	 * 
	 * @description: 证书出口审核
	 * @author: laiguanglong
	 * @date: 2016年8月19日 下午5:12:20
	 */
	@Transactional(readOnly = false)
	public void audit(DogPedigreeCertifiedExport audit) throws ZAException {
		try {
			//0待审核 1通过 2未通过 3已注销
			DogPedigreeCertifiedExport dogPedigreeCertifiedExport = super.get(audit.getId());
			// 审核状态为“未通过”的数据，可审核未待审核外的任何状态，此处将“未通过”的数据当做“待审核”的数据来处理
			if ("2".equals(dogPedigreeCertifiedExport.getReviewState())) {
				dogPedigreeCertifiedExport.setReviewState("0");
			}
			SysContext sysContext = new SysContext(dogPedigreeCertifiedExport.getPaymentState(),
					dogPedigreeCertifiedExport.getReviewState(), dogPedigreeCertifiedExport.getProcessState());
			if ("1".equals(audit.getReviewState())) {
				// 已审核
				dogPedigreeCertifiedExport.setReviewState("1");
				sysContext.confirmSuccess(sysContext, BUSINESS_NAME, dogPedigreeCertifiedExport.getPaymentMemberCode(),
						"dog_pedigree_certified_export", dogPedigreeCertifiedExport.getId(),
						dogPedigreeCertifiedExport.getRunningNumber(), (str) -> {
						});
			} else if ("2".equals(audit.getReviewState())) {
				// 不通过
				dogPedigreeCertifiedExport.setReviewState("2");
				sysContext.confirmFail(sysContext, BUSINESS_NAME, audit.getReviewRemarks(),
						dogPedigreeCertifiedExport.getPaymentMemberCode(), "dog_pedigree_certified_export",
						dogPedigreeCertifiedExport.getId(), dogPedigreeCertifiedExport.getRunningNumber(), (str) -> {
						});
			}else if ("3".equals(audit.getReviewState())) {
				// 已注销
				dogPedigreeCertifiedExport.setReviewState("3");
			}
			dogPedigreeCertifiedExport.setReviewRemarks(audit.getReviewRemarks());
			dogPedigreeCertifiedExport.setReviewTime(new Date());
			super.save(dogPedigreeCertifiedExport);
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * 
	 * @description: 证书出口处理
	 * @author: laiguanglong
	 * @date: 2016年8月19日 下午5:21:56
	 */
	@Transactional(readOnly = false)
	public void resolve(DogPedigreeCertifiedExport resolve) throws ZAException {
		try {
			// 修改证书出口的处理状态
			DogPedigreeCertifiedExport dogPedigreeCertifiedExport = super.get(resolve.getId());
			SysContext sysContext = new SysContext(dogPedigreeCertifiedExport.getPaymentState(),
					dogPedigreeCertifiedExport.getReviewState(), dogPedigreeCertifiedExport.getProcessState());
			sysContext.updateData(sysContext, BUSINESS_NAME, dogPedigreeCertifiedExport.getPaymentMemberCode(),
					"dog_pedigree_certified_export", dogPedigreeCertifiedExport.getId(),
					dogPedigreeCertifiedExport.getRunningNumber(), (str) -> {
					});
			dogPedigreeCertifiedExport.setProcessState("1");
			dogPedigreeCertifiedExport.setProcessTime(new Date());
			super.save(dogPedigreeCertifiedExport);
			// 证书出口处理更新Dog表
			dao.resolveUpdateDog(dogPedigreeCertifiedExport.getDogId(), dogPedigreeCertifiedExport.getExporter(), "5",
					"3");
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * 
	 * @description: 添加犬只出口订单页面，根据血统证书号查询犬只信息
	 * @author: laiguanglong
	 * @date: 2016年8月23日 下午5:22:03
	 */
	public HashMap<String, String> getDogByPedigreeCertified(String pedigreeCertified) {
		HashMap<String, String> map = new HashMap<String, String>();
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertified);
		if (dog != null) {
			map.put("dogId", dog.getId());
			map.put("dogOwner", dog.getDogOwner());
			map.put("dogOwnerMemberCode", dog.getMemberCode());
			map.put("nameEn", dog.getNameEn());
			map.put("birthdate", DateUtils.dateToStr(dog.getBirthdate()));
			map.put("gender", DictUtils.getDictLabel(dog.getGender(), "dog_gender", ""));
			map.put("colorFlag", dog.getColorFlag());
			map.put("identificationFlag", dog.getIdentificationFlag());
			map.put("dogState", dog.getDogState());// 犬只状态
			map.put("DNA", dog.getDna());
			String dogGeneration = "false";
			if (!"".equals(dog.getDogGeneration()) && dog.getDogGeneration() != null
					&& new Integer(dog.getDogGeneration()) >= 3) {
				dogGeneration = "true";
			} else {
				dogGeneration = "false";
			}
			map.put("dogGeneration", dogGeneration);// 犬只代数是否满足3代标识
			Date birthdate = dog.getBirthdate();
			int age = getMonthAge(new Date(), birthdate);
			String MonthAge = "";
			if (age < 15) {
				MonthAge = "false";
			} else {
				MonthAge = "true";
			}
			map.put("MonthAge", MonthAge);// 月龄是否满足15个月标识
			Member member = memberService.getByMemberCode(dog.getMemberCode() == null ? "" : dog.getMemberCode());
			map.put("memberType", member.getMemberType());
			DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
			if (dogType != null) {
				map.put("dogBreed", dogType.getBreedCnName());
			}
		}
		return map;
	}

	/**
	 * 
	 * @Description：计算月龄
	 * @author: zhuoHeng
	 * @version: 2016年10月21日 上午10:17:52
	 */
	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH) - birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}

	/**
	 * 
	 * @description: 保存证书出口申请
	 * @author: laiguanglong
	 * @date: 2016年8月23日 下午5:36:49
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void add(DogPedigreeCertifiedExport add) throws ZAException {
		DogPedigreeCertifiedExport dogPedigreeCertifiedExport = new DogPedigreeCertifiedExport();
		Dog dog = dogService.getByPedigreeCertifiedCode(add.getPedigreeCertified());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
		}
		if (!dog.getMemberCode().equals(add.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只不属于该会员，操作失败");
		}
		// 业务禁止校验
		businessBanService.validateBusinessBan(dog, "该犬为禁止繁殖状态");
		// 查重
		DogPedigreeCertifiedExport example = new DogPedigreeCertifiedExport();
		example.setDogId(dog.getId());
		example.setReviewStateStr("3");
		if (dao.findList(example).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已有出口申请记录");
		}
		dogPedigreeCertifiedExport.setDogId(dog.getId());
		dogPedigreeCertifiedExport.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		dogPedigreeCertifiedExport.setExportCountry(add.getExportCountry().toUpperCase());
		dogPedigreeCertifiedExport.setExportDestination(add.getExportDestination().toUpperCase());
		dogPedigreeCertifiedExport.setExporter(add.getExporter().toUpperCase());
		dogPedigreeCertifiedExport.setPaymentMemberCode(add.getPaymentMemberCode());
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(add.getPaymentChargingItemId());
		dogPedigreeCertifiedExport.setPrice(paymentChargingItem.getPrice());
		dogPedigreeCertifiedExport.setReviewState("0");
		dogPedigreeCertifiedExport.setRunningNumber(add.getRunningNumber());
		dogPedigreeCertifiedExport.setPaymentState("2");
		dogPedigreeCertifiedExport
				.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(add.getRunningNumber()));
		dogPedigreeCertifiedExport.setProcessState("0");
		super.save(dogPedigreeCertifiedExport);
	}

	/**
	 * 
	 * @description: 获取已付款待审核的犬只鉴定申请记录数
	 * @author: laiguanglong
	 * @date: 2016年8月29日 下午4:21:12
	 */
	public int getAuditCount() {
		DogPedigreeCertifiedExport dogPedigreeCertifiedExport = new DogPedigreeCertifiedExport();
		// 已付款
		dogPedigreeCertifiedExport.setPaymentState("2");
		// 未审核
		dogPedigreeCertifiedExport.setReviewState("0");
		return dao.listCount(dogPedigreeCertifiedExport);
	}

	/**
	 * 
	 * @description: 根据犬id进行查询
	 * @author: laiguanglong
	 * @date: 2016年9月1日 下午4:35:47
	 */
	public DogPedigreeCertifiedExport getByDogId(String dogId) {
		return dao.getByDogId(dogId);
	}

	/**
	 * 
	 * @description: 证书出口业务校验
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午6:18:14
	 */
	public void validateBusiness(DogPedigreeCertifiedExport po) {
		Member member = UserUtils.getLoginMember();
		// 校验会员为有效会员
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "该业务仅限有效会员办理");
		}
		// 犬主必须是有效永久犬舍
		Kennel kennel = kennelDao.getKennelByMemberCode(member.getMemberCode());
		if (kennel == null || !"permanent".equals(kennel.getType())) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "请确认会员注册了永久犬舍");
		}
		// 犬舍状态必须为已通过
		if (!"1".equals(kennel.getReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "该业务仅限有效且审核通过的犬舍办理");
		}
		Dog dog = dogService.get(po.getDogId());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id有误");
		}

		if (!member.getMemberCode().equals(dog.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id有误");
		}
		// 犬只状态都得为正常
		if (!"0".equals(dog.getDogState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬状态不为正常，不允许申请证书出口");
		}
		// 业务禁止校验
		businessBanService.validateBusinessBan(dog, "该犬为禁止繁殖状态");
		// 犬只血统不足4代血统不允许提交
		if (StringUtils.isBlank(dog.getDogGeneration()) || Integer.parseInt(dog.getDogGeneration()) < 4) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只血统不足4代，不允许申请证书出口");
		}

		// 4代内包含禁止出口犬只，此犬无法申请出口
		dogService.dogChangeBan(dog);

		// 重复订单校验
		DogPedigreeCertifiedExport example = new DogPedigreeCertifiedExport();
		example.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		// List<DogPedigreeCertifiedExport> list = findList(example);

		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		List<DogPedigreeCertifiedExport> list = dao.findListFyx(example);
		if (list.size() != 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有证书出口订单");
		}

		// 位点分析
		if (po.getDogDnaArchiveFlag() != null && po.getDogDnaArchiveFlag()) {
			DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
			if (dogDnaArchive != null && "1".equals(dogDnaArchive.getPaymentState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询到此犬只有一条未交费的DNA位点分析订单，请进行交费或删除后再申请。");
			}
		}
		//执行时间自2025年1月1日起至2025年12月31日 判断申请出口的本犬及父母犬是否留存过DNA位点
		if(DateUtils.getNow().after(DateUtils.strToDate("2025-01-01"))
				&& DateUtils.getNow().before(DateUtils.strToDate("2026-01-01"))) {
			if(StringUtils.isNotBlank(dog.getMdogPedigreeCertified()) ) {
				DogDnaArchive maleDna = dogDnaArchiveDao.getByPedigreeCertifiedCode(dog.getMdogPedigreeCertified());
				if (Objects.isNull(maleDna)  || !"2".equals(maleDna.getPaymentState())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬的母犬未留存DNA位点！");
				}
			}
			if(StringUtils.isNotBlank(dog.getFdogPedigreeCertified()) ) {
				DogDnaArchive femaleDna =  dogDnaArchiveDao.getByPedigreeCertifiedCode(dog.getFdogPedigreeCertified());
				if (Objects.isNull(femaleDna)  || !"2".equals(femaleDna.getPaymentState())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬的父犬未留存DNA位点！");
				}
			}
		}
	}

	public List<SysCountry> getCountryList() {
		return dao.getCountryList();
	}

	public SysCountry getCountry(String en) {
		return dao.getCountry(en);
	}
	
	
	
	public DogPedigreeCertifiedExport getByPedigreeCertified(String pedigreeCertified) {
		return dao.getByPedigreeCertified(pedigreeCertified);
		
	}

}