/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.restful.v1.dog.vo.request.GoldCertifiedPageRequest;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedPageResp;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * DNA双亲比对DAO接口
 *
 * @author lgl
 * @version 2016-11-24
 */
@MyBatisDao
public interface DogDnaParentsCompareDao extends CrudDao<DogDnaParentsCompare> {
	public DogDnaParentsCompare getByBirthCode(@Param("birthCode") String birthCode);

	public DogDnaParentsCompare getByBirthCodeAndNullRunningNumber(@Param("birthCode") String birthCode);

	/**
	 * @description: 根据id进行物理删除
	 * @author: laiguanglong
	 * @date: 2016/12/20 17:44
	 */
	int deleteYes(DogDnaParentsCompare dogDnaParentsCompare);

	/**
	 * 获取金质证书分页
	 *
	 * @author yuanshuai
	 * @date 2023/6/12 11:00
	 */
	List<GoldCertifiedPageResp> findGoldCertifiedPage(@Param("request") GoldCertifiedPageRequest request,
			@Param("memberCode") String memberCode);

	GoldCertifiedPageResp findGoldCertifiedDetail(@Param("id") String id, @Param("memberCode") String memberCode);

	/**
	 * 通过证书号查询
	 *
	 * @author yuanshuai
	 * @date 2023/6/13 16:51
	 */
	DogDnaParentsCompare getByPedigreeCertified(@Param("pedigreeCertified") String pedigreeCertified);

	List<DogDnaParentsCompare> findInfoByPage(DogDnaParentsCompare dogDnaParentsCompare);
}