package com.cku.oa.contest.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.contest.entity.Language;
import com.cku.oa.contest.service.LanguageService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.contest.entity.ContestClass;
import com.cku.oa.contest.service.ContestClassService;

/**
 * 犬展活动区域年龄组别Controller
 * @author yuanshuai
 * @version 2020-10-12
 */
@Controller
@RequestMapping(value = "${adminPath}/contest/contestClass")
public class ContestClassController extends BaseController {

	@Autowired
	private ContestClassService contestClassService;
	@Autowired
	private LanguageService languageService;

	
	@ModelAttribute
	public ContestClass get(@RequestParam(required=false) String id) {
		ContestClass entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = contestClassService.get(id);
		}
		if (entity == null){
			entity = new ContestClass();
		}
		return entity;
	}
	
	@RequiresPermissions("contest:contestClass:view")
	@RequestMapping(value = {"list", ""})
	public String list(ContestClass contestClass, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ContestClass> page = contestClassService.findPage(new Page<>(request, response), contestClass);
		model.addAttribute("page", page);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestClassList";
	}

	@RequiresPermissions("contest:contestClass:view")
	@RequestMapping(value = "form")
	public String form(ContestClass contestClass, Model model) {
		model.addAttribute("contestClass", contestClass);
		model.addAttribute("languageList", languageService.findList(new Language()));
		return "oa/contest/contestClassForm";
	}

	@RequiresPermissions("contest:contestClass:edit")
	@RequestMapping(value = "save")
	public String save(ContestClass contestClass, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, contestClass)){
			return form(contestClass, model);
		}
		contestClassService.save(contestClass);
		addMessage(redirectAttributes, "保存犬展活动区域年龄组别成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestClass/?repage";
	}
	
	@RequiresPermissions("contest:contestClass:del")
	@RequestMapping(value = "delete")
	public String delete(ContestClass contestClass, RedirectAttributes redirectAttributes) {
		contestClassService.delete(contestClass);
		addMessage(redirectAttributes, "删除犬展活动区域年龄组别成功");
		return "redirect:"+Global.getAdminPath()+"/contest/contestClass/?repage";
	}

}