/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import com.cku.restful.v1.contest.model.RestContestWinner;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛场成绩Entity
 *
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestWinner extends DataEntity<ContestWinner> {

	private static final long serialVersionUID = 1L;
	private String exhibitNo;        // 秩序号
	private String code;        // 成绩编号
	private String position;        // 名次
	private String gender;        // 性别
	private String classNo;        // 年龄组别编号
	private String breedNo;        // 犬种编号
	private String groupNo;        // 犬种组编号
	private String contestNo;        // 子赛事编号
	private String contestEventNo;        // 组赛事编号
	private String display;        // 是否显示

	public ContestWinner() {
		super();
	}

	public ContestWinner(String id) {
		super(id);
	}

	public ContestWinner(RestContestWinner rest) {
		this.exhibitNo = "null".equals(rest.getExhibit_no()) || StringUtils.isBlank(rest.getExhibit_no()) ? "0" : rest.getExhibit_no();
		this.code = rest.getCode();
		this.position = rest.getPosition();
		this.gender = rest.getGender();
		this.classNo = rest.getClass_no();
		this.breedNo = rest.getBreed_no();
		this.groupNo = rest.getGroup_no();
		this.contestNo = rest.getContest_no();
		this.contestEventNo = rest.getContest_event_no();
		this.display = rest.getDisplay();
	}

	@Length(min = 1, max = 11, message = "秩序号长度必须介于 1 和 11 之间")
	public String getExhibitNo() {
		return exhibitNo;
	}

	public void setExhibitNo(String exhibitNo) {
		this.exhibitNo = exhibitNo;
	}

	@Length(min = 1, max = 32, message = "成绩编号长度必须介于 1 和 32 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Length(min = 1, max = 1, message = "名次长度必须介于 1 和 1 之间")
	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	@Length(min = 1, max = 1, message = "性别长度必须介于 1 和 1 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	@Length(min = 1, max = 11, message = "年龄组别编号长度必须介于 1 和 11 之间")
	public String getClassNo() {
		return classNo;
	}

	public void setClassNo(String classNo) {
		this.classNo = classNo;
	}

	@Length(min = 1, max = 11, message = "犬种编号长度必须介于 1 和 11 之间")
	public String getBreedNo() {
		return breedNo;
	}

	public void setBreedNo(String breedNo) {
		this.breedNo = breedNo;
	}

	@Length(min = 1, max = 11, message = "犬种组编号长度必须介于 1 和 11 之间")
	public String getGroupNo() {
		return groupNo;
	}

	public void setGroupNo(String groupNo) {
		this.groupNo = groupNo;
	}

	@Length(min = 1, max = 11, message = "子赛事编号长度必须介于 1 和 11 之间")
	public String getContestNo() {
		return contestNo;
	}

	public void setContestNo(String contestNo) {
		this.contestNo = contestNo;
	}

	@Length(min = 0, max = 11, message = "组赛事编号长度必须介于 0 和 11 之间")
	public String getContestEventNo() {
		return contestEventNo;
	}

	public void setContestEventNo(String contestEventNo) {
		this.contestEventNo = contestEventNo;
	}

	@Length(min = 1, max = 1, message = "是否显示长度必须介于 1 和 1 之间")
	public String getDisplay() {
		return display;
	}

	public void setDisplay(String display) {
		this.display = display;
	}

}