/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.dao;

import com.cku.oa.contest.entity.ContestBreed;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 赛场犬种DAO接口
 *
 * @author yuanshuai
 * @version 2020-10-12
 */
@MyBatisDao
public interface ContestBreedDao extends CrudDao<ContestBreed> {

	/**
	 * @Description： 根据犬种代码获得犬种
	 * @author: yuanshuai
	 * @date: 2020/10/12 16:20
	 */
	List<ContestBreed> getByBreedCode(@Param("breedCode") String breedCode);

	ContestBreed getByBreedNo(@Param("breedNo") String breedNo, @Param("language") String language);
}