//犬主变更添加页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.pedigreeCertifiedCode = ko.observable("");
        me.dogId = ko.observable("");
        //根据血统证书号查出来的狗信息
        me.mydog = ko.observable({});
        //获取价格
        me.showPrice = ko.observable("0");
        me.semenNumber = ko.observable("");
        me.breedDate = ko.observable("");
        me.acquisitionTime = ko.observable("");
        //是否展开注意事项
        me.isOpen = ko.observable(false);
        me.isShow = function(){
            me.isOpen(!me.isOpen());
        }
        /**
         * 我的犬只列表根据血统证书号查询
         */
        me.getDog = function(){
            if(me.pedigreeCertifiedCode()){
                var sendData = {};
                sendData["pedigreeCertifiedCode"] = me.pedigreeCertifiedCode();
                sendData["businessType"] = "1";
                util.sendAjax({
                    url:'dog/dogFrozenSemen/checkByPedigreeCertifiedCode',
                    data:sendData,
                    async:true,
                    loadFlag:true,
                    type:'GET',
                    cache:false,
                    success:function(json){
                        if(json.rc==0){
                            if(json.data!=null){
                                me.mydog(json.data);
                                me.dogId(json.data.id);
                                me.getPrice();
                            }else{
                                layer.msg("查询信息失败，请输入正确的血统证书号！");
                                me.mydog({});
                                me.showPrice("0");
                            }
                        }else{
                            layer.msg("查询信息失败:"+json.msg);
                            me.mydog({});
                        }
                    }
                });
            }else{
                layer.msg("血统证书号不能为空！");
            }
        }
        //获取价格
        me.getPrice = function(){
            var sendData = {};
            sendData["businessType"] = "1";
            util.sendAjax({
                url:'dog/dogFrozenSemen/getPrice',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.showPrice(json.data.price);
                    }else{
                        layer.msg("获取价格失败:"+json.msg);
                    }
                }
            });
        }
        /**
         * 保存
         */
        me.saveCart = function(){
            var sendData = {};
            var originalSemenCode = [];
            if(me.dogId()==''){
                layer.msg("请查询犬只信息后提交");
                return;
            }
            if($("#breedDate").val()==''){
                layer.msg("请填写采集时间");
                return;
            }
            if(me.semenNumber()==''){
                layer.msg("请填写精子数量");
                return;
            }
            var flag = false;
            var msg = "";
            $(".originalSemenCode").each(function (i,val) {
                if($(this).val()==''){
                    flag = true;
                    return;
                }
                originalSemenCode.push($(this).val());
                var index = i+1;
                msg +=index+"&nbsp&nbsp&nbsp"+$(this).val()+"</br>"
            });
            if(flag){
                layer.msg("原精子编号不能为空");
                return;
            }
            sendData["dogId"] = me.mydog().dogId;
            sendData["originalSemenCode"] = originalSemenCode;
            sendData["businessType"] = "1";
            sendData["acquisitionTime"] = $("#breedDate").val();
            layer.confirm(msg, {
                title:"请再次确认原精液编号"
                ,time: 0 //不自动关闭
                ,btn: ['确认', '修改']
                ,btn1: function(index){
                    util.sendAjax({
                        url:'dog/dogFrozenSemen',
                        data:JSON.stringify(sendData),
                        async:true,
                        loadFlag:true,
                        type:'POST',
                        cache:false,
                        success:function(json){
                            if(json.rc ==0){
                                context.app.changeCart();
                                layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                                    time: 0 //不自动关闭
                                    ,btn: ['跳转', '取消']
                                    ,yes: function(index){
                                        layer.close(index);
                                        location.href = location.href.split("#")[0]+"#/order/check";
                                    }
                                });
                            }else{
                                layer.msg("种犬报备申请失败:"+json.msg);
                            }
                        }
                    });
                    layer.close(index);
                },btn2:function(index){
                    layer.close(index);
                }
            });
        }


        me.changeLine = function(){
            var num = parseInt(me.semenNumber());
            var html = '';
            for (var i = 0; i < num; i++) {
                html += '<input type="text" class="originalSemenCode"/></br>';
            }
            $("#div1").html(html);
        }

        context.app.loading(false);
        context.app.isShop(false);
    }
});