<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员分布信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }					
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">会员分布信息</a></li>
		<li class=""><a href="${ctx}/statistics/member/regionalConsumption">会员分地区消费信息</a></li>
		<li class=""><a href="${ctx}/statistics/member/memberConsumption">会员总消费统计</a></li>
	</ul>



	<form id="searchForm"  action="${ctx}/statistics/member/regionalDistribution" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>选择地区：</label>			
			
				<select id="province" name="province" class="input-small">
					<c:if test="${selectedProvince!='' && selectedProvince!=null}">
						<option value="${fns:escapeHtml(selectedProvince)}" selected>${fns:escapeHtml(selectedProvince)}</option>
					</c:if>
					<option value="">全国</option>					
					<c:forEach items="${province}" var="p">
						<option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</option>
					</c:forEach>
				</select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>省份</th>
				<th colspan="2">基础会员</th>
				<th colspan="2">专业会员</th>
				<th colspan="2">年度犬舍</th>
				<th colspan="2">永久犬舍</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${results}" var="result">
			<tr>
				<td>
					${fns:escapeHtml(result.province)}
				</td>
				<td>
					已缴费：<a href=# target='_blank'>${fns:escapeHtml(result.basic_paid)}</a>
				</td>
				<td>
					未缴费：<a href=#>${fns:escapeHtml(result.basic_nopaid)}</a>
				</td>
				<td>
					已缴费：<a href=#>${fns:escapeHtml(result.professional_paid)}</a>
				</td>
				<td>
					未缴费：<a href=#>${fns:escapeHtml(result.professional_nopaid)}</a>
				</td>
				<td>
					已缴费：<a href=#>${fns:escapeHtml(result.k_y_paid)}</a>
				</td>
				<td>
					未缴费：<a href=#>${fns:escapeHtml(result.k_y_nopaid)}</a>
				</td>
				<td>
					已缴费：<a href=#>${fns:escapeHtml(result.k_f_paid)}</a>
				</td>
				<td>
					未缴费：<a href=#>${fns:escapeHtml(result.k_f_nopaid)}</a>
				</td>
			</tr>
		</c:forEach>
		<c:if test="${selectedProvince=='' || selectedProvince==null}">
		<tr>
			<td>
				<b>合计</b>
			</td>			
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
			<td>
			</td>
		</tr>
		</c:if>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
<script type="text/javascript">
	if(document.getElementById('contentTable').getElementsByTagName('tr').length-1!=1)
	{
		calcTotal(document.getElementById('contentTable'),1,'已缴费');
		calcTotal(document.getElementById('contentTable'),2,'未缴费');
		calcTotal(document.getElementById('contentTable'),3,'已缴费');
		calcTotal(document.getElementById('contentTable'),4,'未缴费');
		calcTotal(document.getElementById('contentTable'),5,'已缴费');
		calcTotal(document.getElementById('contentTable'),6,'未缴费');
		calcTotal(document.getElementById('contentTable'),7,'已缴费');
		calcTotal(document.getElementById('contentTable'),8,'未缴费');
	}
	function calcTotal(table,column,text){			
		var trs=table.getElementsByTagName('tr');		
		var start=1,//忽略第一行的表头
		end=trs.length-1;//忽略最后合计的一行
		var total=0;    
		for(var i=start;i<end;i++){
			var td=trs[i].getElementsByTagName('td')[column];		
			var t=parseInt(td.innerText.substring(4,td.innerText.length));
			if(t)total+=t;
		}
		trs[end].getElementsByTagName('td')[column].innerHTML='<b>'+text+'：'+total+'</b>';
	}
</script>	
</body>
</html>
