<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬展活动区域鉴定报名管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //悬浮提示插件
            $(document).tooltip();
            $("#btnExport").click(function(){
                $.jBox($("#importBox").html(), {title:"犬展活动区域鉴定报名导出", buttons:{"关闭":true},
                    bottomText:"只有犬展活动区域鉴定报名已截止后才能导出数据"});
            });
        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
        function dogAppraisalApply(identifyType, paymentMemberCode, paymentChargingItemId, runningNumber) {
            parent.layer.open({
                type: 2,
                title: ['纯种犬鉴定申请', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['600px', '450px'],
                content: ctx + "/dogappraisal/dogAppraisal/dogAppraisalApply?identifyType=" + identifyType + "&paymentMemberCode=" + paymentMemberCode + "&paymentChargingItemId=" + paymentChargingItemId + "&runningNumber=" + runningNumber,
                end: function () {
                    if (parent.isYes) {
                        var mainF = parent.$("#mainFrame");
                        mainF.contents().find("#searchForm").submit();
                    }
                    ;
                }
            });
        }

        function setExportParam(){
            var showCodePrefix = $(":input[name='showCodePrefix']").get(1).value;
            if(showCodePrefix.length!=6){
                $("a[name='exportURL']:eq(1)").attr('href','#');
                return;
            }
            //校验是否可以打印
            $.getJSON("${ctx}/apply/dogAppraisal/checkShowCode?showCodePrefix="+showCodePrefix,function(json){
                if(json==true){
                    $("div[name='checkShowCodeMsg']:eq(1)").hide();
                    var exportURL = "${ctx}/apply/dogAppraisal/printList?showCodePrefix=";
                    $("a[name='exportURL']:eq(1)").attr('href',exportURL+showCodePrefix);
                }else{
                    $("div[name='checkShowCodeMsg']:eq(1)").show();
                    $("a[name='exportURL']:eq(1)").attr('href','javascript:return false;');
                }
            });
        }
    </script>
    <!-- 悬浮提示插件 -->
    <link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
<div id="importBox" class="hide">
    <form id="importForm" class="form-search" style="padding-left:20px;text-align:center;"><br/>
        <label>请输入需要导出的6位犬展编号</label>
        <input name="showCodePrefix" type="text" onblur="setExportParam()" style="width:100px"/><br/><br/>
        <div name="checkShowCodeMsg" style="display:none;"><font color="red">报名还未截止，不能打印</font></div>
        <a name="exportURL" href="javascript:return false;" target="_Blank">导出</a>
    </form>
</div>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/apply/dogAppraisal/">犬展活动区域鉴定报名列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="dogAppraisal" action="${ctx}/apply/dogAppraisal/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>犬展信息：</label>
            <form:input path="mainShowInfo" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>会员号/姓名：</label>
            <form:input path="dogOwnerName" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>犬名：</label>
            <form:input path="dogName" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>犬种：</label>
            <form:input path="dogBreed" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <shiro:hasPermission name="apply:dogAppraisal:print">
      <!-- <li class="btns"><input id="btnExport" class="btn btn-primary" type="button" value="导出犬展活动区域鉴定报名信息"/></li>
       -->  
        </shiro:hasPermission>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>犬展信息</th>
        <th>犬展活动区域鉴定编号</th>
        <th>犬主姓名</th>
        <th>犬主会员号</th>
        <th>犬名</th>
        <th>犬种</th>
        <th>犬毛色</th>
        <th>犬性别</th>
        <th>出生日期</th>
        <th>缴费时间</th>
        <shiro:hasPermission name="apply:dogAppraisal:print">
            <th>打印</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogAppraisal">
        <tr>
            <td>
                    ${fns:escapeHtml(dogAppraisal.mainShowInfo)}
            </td>
            <td>
                    ${fns:escapeHtml(dogAppraisal.showAppraisalCode)}
            </td>
            <td>
                    ${fns:escapeHtml(dogAppraisal.dogOwnerName)}
            </td>
            <td>
                    ${fns:escapeHtml(dogAppraisal.dogOwnerCode)}
            </td>
            <td>
                    ${fns:escapeHtml(dogAppraisal.dogName)}
            </td>
            <td title="${fns:escapeHtml(dogAppraisal.breedCnName)}">
                    ${fns:escapeHtml(dogAppraisal.dogBreed)}
            </td>
            <td>
                    ${fns:escapeHtml(dogAppraisal.dogFurColor)}-${fns:escapeHtml(dogAppraisal.dogColorMarkCn)}
            </td>
            <td>
                    ${fns:getDictLabel(dogAppraisal.dogGender, 'dog_gender', '')}
            </td>
            <td>
                <fmt:formatDate value="${dogAppraisal.birthday}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <fmt:formatDate value="${dogAppraisal.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <shiro:hasPermission name="apply:dogAppraisal:print">
                <td>
                    <c:if test="${dogAppraisal.showAppraisalPrintFlag=='1'}"><a href="${ctx}/apply/dogAppraisal/printOne?id=${dogAppraisal.id}" target="_Blank">打印</a></c:if>
                    <c:if test="${dogAppraisal.showAppraisalPrintFlag=='0'}">报名未结束</c:if>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>