<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部账户</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/shop/shopMember/moneyList">俱乐部账户收支信息</a></li>
		<li><a href="${ctx}/shop/shopMember/list">俱乐部账户</a></li>
		<shiro:hasPermission name="shop:shopMember:recharge">
			<li><a href="${ctx}/shop/shopMember/form">俱乐部充值</a></li>
			<li><a href="${ctx}/shop/shopMember/refund">俱乐部退款</a></li>
		</shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="shopPayRecord" action="${ctx}/shop/shopMember/moneyList" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>开始时间：</label>
				<input id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${startDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label style="width:100px;">结束时间：</label>
				<input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate"
				value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>订单编号</th>
				<th>会员号</th>
				<th>订单金额</th>
				<th>支付方式</th>
				<th>支付类型</th>
				<th>操作员</th>
				<th>时间</th>
				<th>备注</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="shopPayRecord">
			<tr>
				<td>
					${fns:escapeHtml(shopPayRecord.shopOrderCode)}
				</td>
				<td>
					${fns:escapeHtml(shopPayRecord.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(shopPayRecord.paymentMoney)}
				</td>
				<td>
					${fns:getDictLabel(shopPayRecord.paymentWay, 'payment_way', '')}
				</td>
				<td>
					${fns:getDictLabel(shopPayRecord.paymentType, 'shop_payment_type', '')}
				</td>
				<td>
					${fns:escapeHtml(shopPayRecord.updateBy.name)}
				</td>
				<td>
					<fmt:formatDate value="${shopPayRecord.paymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
						${fns:escapeHtml(shopPayRecord.paymentRemarks)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>