<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>活动录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					var showCode="";
					$(".showCode").each(function(){
						showCode+=$(this).val()+",";
					});

					var showType = $("#showType").val();
					if(showType == '10'||showType == '11'){
						var result = $('input[name="levels"]').is(":checked");
						if(result == false){
							$.jBox.alert("请选择级别","提示");
							return false;
						}
					} else if(showType == '12'||showType == '13'){
						var result = $('input[name="levels"]').is(":checked");
						if(result == false){
							$.jBox.alert("请选择级别","提示");
							return false;
						}
					} else {
						var result = $('input[name="testLevel"]').is(":checked");
						if(result == false){
							$.jBox.alert("请选择级别","提示");
							return false;
						}
					}
					
				 	$.ajax({
						type: "POST",
		                dataType:"json",
		                url:"${ctx}/handler/handlerShow/codeCheck?showCode="+showCode,
		                async: false,
		                error: function(request, textStatus, errorThrown) {
		                    alert("请求失败！");
		                },
		                success: function(data) {
		                	if(data.rc == 1){
		                		$.jBox.alert("此["+data.showCode+"]编号已存在","提示");
		                	}else{
								if($("#showPhoto").val()==""){
									alert("活动图片不能为空！");
									return false;
								}
								form.submit(); 
		                	}
		                }
					});
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$("#examinerRoleDiv").hide();
			$("#otherRoleDiv").hide();
			$("#groomerExaminerRoleDiv").hide();
			$("#partnerLevelDiv").hide();
			// 展示不同div
			$("#showType").on('change' , function(){
			     var value = $("#showType").val();
			     if("10" == value){
			    	 $("#examinerRoleDiv").show();
					 $("#otherRoleDiv").hide();
					 $("#groomerExaminerRoleDiv").hide();
					 $("#partnerLevelDiv").hide();
					 $('input[name="testLevel"]:checked').removeAttr("checked");
					 // 报名费
					 $("#fee").val(0);
					 $("#fee").attr("disabled","disabled");
					 $("#groomerExaminerRoleDiv").find("*").attr("disabled","disabled");
					 $("#examinerRoleDiv").find("*").removeAttr("disabled");
				 }else if("11" == value){
			    	 $("#groomerExaminerRoleDiv").show();
					 $("#otherRoleDiv").hide();
					 $("#examinerRoleDiv").hide();
					 $("#partnerLevelDiv").hide();
					 $('input[name="testLevel"]:checked').removeAttr("checked");
					 // 报名费
					 $("#fee").val(0);
					 $("#fee").attr("disabled","disabled");
					 $("#examinerRoleDiv").find("*").attr("disabled","disabled");
					 $("#groomerExaminerRoleDiv").find("*").removeAttr("disabled");
				 } else if("12" == value || "13" == value) {

					 $("#examinerRoleDiv").hide();
					 $("#otherRoleDiv").hide();
					 $("#groomerExaminerRoleDiv").hide();
					 $("#partnerLevelDiv").show();
					 $('input[name="levels"][value="none"]:checkbox').remove();
					 // 取消全选
					 $("[name=levels]:checkbox").each(function (i, u) {
						 $(u).prop("checked",false);
					 });

					 // 报名费
					 $("#fee").val();
					 $("#fee").removeAttr("disabled");
					 $("#examinerRoleDiv").find("*").attr("disabled","disabled");
					 $("#groomerExaminerRoleDiv").find("*").attr("disabled","disabled");
				 }else{
					 $("#examinerRoleDiv").hide();
					 $("#otherRoleDiv").show();
					 $("#groomerExaminerRoleDiv").hide();
					 $("#partnerLevelDiv").hide();
					 // 取消全选
					 $("[name=levels]:checkbox").each(function (i, u) {
		                    $(u).prop("checked",false);
		             });
					 // 报名费
					 $("#fee").val();
					 $("#fee").removeAttr("disabled");
					 $("#examinerRoleDiv").find("*").attr("disabled","disabled");
					 $("#groomerExaminerRoleDiv").find("*").attr("disabled","disabled");
				 }
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerShow/form">活动录入</a></li>
	</ul>
	<form:form id="inputForm" modelAttribute="handlerShow" action="${ctx}/handler/handlerShow/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>

		<div class="control-group">
			<label class="control-label">活动编号：</label>
			<div class="controls">
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动名称：</label>
			<div class="controls">
				<form:input path="showName" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动类别：</label>
			<div class="controls">
				<form:select path="showType" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('handler_show_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		
		<div id="examinerRoleDiv">
			<div class="control-group">
				<label class="control-label">级别：</label>
				<div id="examinerLevel" class="controls">
					<form:checkboxes path="levels" items="${fns:getDictList('handler_test_level_examiner')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</div>
			</div>
			
			<div class="control-group">
				<label class="control-label">人数限制：</label>
				<div class="controls ">
					<form:input path="maxNumber" htmlEscape="false" maxlength="6" min="1" type="number" class="input-mini "/>
				</div>
			</div>
			
		</div>
		
		<div id="groomerExaminerRoleDiv">
			<div class="control-group">
				<label class="control-label">级别：</label>
				<div id="examinerLevel" class="controls">
					<form:checkboxes path="levels" items="${fns:getDictList('groomer_examiner_course_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</div>
			</div>
			
			<div class="control-group">
				<label class="control-label">人数限制：</label>
				<div class="controls ">
					<form:input path="maxNumber" htmlEscape="false" maxlength="6" min="1" type="number" class="input-mini "/>
				</div>
			</div>
			
		</div>
		
		<div id="otherRoleDiv">
			<div class="control-group">
				<label class="control-label">级别：</label>
				<div id="otherlevel" class="controls">
					<form:radiobuttons path="testLevel" items="${fns:getDictList('handler_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</div>
			</div>
		</div>

		<div id="partnerLevelDiv">
			<div class="control-group">
				<label class="control-label">级别：</label>
				<div id="partnerLevel" class="controls">
					<form:checkboxes path="levels" items="${fns:getDictListWithoutNone('handler_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</div>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">开始日期：</label>
			<div class="controls">
				<input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${handlerShow.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束日期：</label>
			<div class="controls">
				<input name="endTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${handlerShow.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名截止时间：</label>
			<div class="controls">
				<input name="registerEndTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${handlerShow.registerEndTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</div>
		</div>
		
		  <div class="control-group">
              <label class="control-label">官网是否展示：</label>
                <div class="controls">
                	<form:radiobutton path="isShowWebsite"  value="0"  class="input-xlarge required"/>展示
                	<form:radiobutton path="isShowWebsite"  value="1"  class="input-xlarge required" />不展示
                </div>
            </div>
		
		<div class="control-group" style="width:80%">
           <label class="control-label">活动图片：</label>
           <div class="controls">
	           <sys:singleMultiImgUpload moduleId="showPhoto" module="member" imgId="${handlerShow.showPhoto}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1"/>
	           <form:input path="showPhoto" id="showPhoto" htmlEscape="false" maxlength="255" class="input-xlarge" type="hidden"/>
           </div>
        </div>
		
		<div class="control-group" style="width:80%">      
            <label class="control-label">网站缩略图：</label>
            <div class="controls">         
	            <sys:singleMultiImgUpload state="1" moduleId="websitePhoto" module="member" imgId="${handlerShow.websitePhoto}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*1024*1"/>
	            <form:input path="websitePhoto" id="websitePhoto" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            </div>
        </div>
		 <!-- 文件上传成功的回调方法 -->
        <script type="text/javascript">
            function uploadSuccessCallback(moduleId,file,response){
                $("#"+moduleId).val(response.id);
            }
        </script>
		
		<div class="control-group">
			<label class="control-label">缩略图地址：</label>
			<div class="controls">
				<form:input path="photoRoute" htmlEscape="false" maxlength="100" class="input-xlarge"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">活动地点：</label>
			<div class="controls">
				<form:input path="showAddress" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判：</label>
			<div class="controls">
                <form:select id="referee" path="referee" class="input-xxlarge required" multiple="true">
                	<form:options items="${showRefereeList}" itemLabel="refereeNameCn" itemValue="id" htmlEscape="false"/>
                </form:select>
                <ul>
                   <li><font color="#FF0000">注：可以多选裁判！ </font></li>
                </ul>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名费：</label>
			<div class="controls">
				<form:input path="fee" htmlEscape="false" maxlength="6" min="0" type="number" class="input-mini required"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="handler:handlerShow:add"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>