<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"成绩导入", buttons:{"关闭":true}, 
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
		
		//录入成绩
		function inputForm(id){
 			parent.layer.open({
				type: 2,
				title: ['成绩录入', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '400px'],
				content: ctx+"/handler/handlerRegister/inputForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerRegister/grade">成绩管理</a></li>
	</ul>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/handler/handlerRegister/import" method="post" enctype="multipart/form-data"
			class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
		</form>
	</div>
	<form:form id="searchForm" modelAttribute="handlerRegister" action="${ctx}/handler/handlerRegister/grade" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>报名序号：</label>
				<form:input path="registerCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>赛事编号：</label>
				<form:input path="showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>姓名/会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>成绩：</label>
				<form:select path="grade" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('handler_grade')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>参赛级别：</label>
				<form:select path="showLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
			<shiro:hasPermission name="handler:grade:import">
				<input id="btnImport" class="btn btn-primary" type="button" value="导入"/>
			</shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>性别</th>
				<th>移动电话</th>
				<th>培训学校</th>
				<th>比赛犬种</th>
				<th>赛事编号</th>
				<th>参赛级别</th>
				<th>成绩</th>
				<th>查看</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerRegister">
			<tr>
				<td>
					${fns:escapeHtml(handlerRegister.registerCode)}
				</td>
				<td>
					<a href="${ctx}/sys/user/member/toMemberView?memberCode=${handlerRegister.memberCode}">
					${fns:escapeHtml(handlerRegister.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.name)}
				</td>
				<td>
					${fns:getDictLabel(handlerRegister.gender, 'user_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.mobile)}
				</td>
				<td>
					${fns:unescapeHtml(handlerRegister.schoolNameCn)}
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.desktopReviewerDog)}
					${fns:escapeHtml(handlerRegister.floorReviewerDog)}
					${fns:escapeHtml(handlerRegister.anyBreed)}
					${fns:escapeHtml(handlerRegister.groomerBreed)}				
				</td>
				<td>
					${fns:escapeHtml(handlerRegister.showCode)}
				</td>
				<td>
					${fns:getDictLabel(handlerRegister.showLevel, 'groomer_test_level', '')}
				</td>
				<shiro:hasPermission name="handlerRegister:grade:add">
				<td title="${fns:escapeHtml(handlerRegister.referee)}">
					<c:choose>
						<c:when test="${handlerRegister.grade==null}">
							  <a   onclick="inputForm('${fns:escapeHtml(handlerRegister.id)}')" >录入成绩</a>
						</c:when>
						<c:when test="${handlerRegister.grade=='0' or handlerRegister.grade=='1'}">
							<font color="red">${fns:getDictLabel(handlerRegister.grade, 'handler_grade', '')}</font>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(handlerRegister.grade, 'handler_grade', '')}</font>
						</c:otherwise>
					</c:choose>
				</td>
				</shiro:hasPermission>
				<td>
					<a href="${ctx}/handler/handlerRegister/gradeView?id=${fns:escapeHtml(handlerRegister.id)}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>