<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬运动犬只管理</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			//查看还是编辑回显
			if('${isView}' == 1){
				$("#btnSubmit").hide();
			}

			//回显会员号
			$("#tempMemberCode").val('${dogSportingDogs.memberCode}')

			$("#btnSubmit").click(function () {
				let dogName = $("#dogName").val();
				if (dogName.length > 40) {
					alert("犬只名称需小于40个字符");
					return;
				}
				let identificationFlag = $("#identificationFlag").val();
				if (identificationFlag.length > 20) {
					alert("犬只芯片号需小于20个字符");
					return;
				}
				let noseCode = $("#noseCode").val();
				if (noseCode.length > 20) {
					alert("犬只鼻纹号需小于20个字符");
					return;
				}
				let colorFlag = $("#colorFlag").val();
				if (colorFlag.length > 20) {
					alert("犬只毛色需小于20个字符");
					return;
				}
				if ($("#memberCode").val() != $("#tempMemberCode").val()) {
					alert("请先查询犬主人会员信息");
					return;
				}

				//提交
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid()) {
							return false;
						}
					},
					success: function (data) {
						if (data.rc == 0) {
							layer.msg("保存成功！");
							window.location = "${ctx}/dogsporting/dog/"
						} else {
							layer.msg(data.msg);
						}
					},
					error: function (err) {
						layer.msg("操作失败!");
					}
				});
			});
		});

		function getMemberByMemberCode() {
			var memberCode = $("#memberCode").val();
			if (memberCode == '') {
				alert("请先输入会员号");
				return;
			}
			$.get('${ctx}/dogsporting/member/getByMemberCode', {
				memberCode: memberCode
			}, function (json) {
				if (json.rc != 0) {
					alert(json.msg)
					$("#memberName").val("");
					$("#tempMemberCode").val("");
				} else {
					$("#memberName").val(json.data.name);
					$("#tempMemberCode").val(memberCode);
				}
			});
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogsporting/dog/">犬运动犬只列表</a></li>

		<li class="active">
			<c:choose>
				<c:when test="${isView==1}">
					<a href="${ctx}/dogsporting/dog/viewForm?id=${dogSportingDogs.id}">犬运动会员查看</a>
				</c:when>
				<c:otherwise>
					<a href="${ctx}/dogsporting/dog/editForm?id=${dogSportingDogs.id}">犬运动犬只<shiro:hasPermission name="dogsporting:member:edit">${not empty dogSportingDogs.id?'修改':'添加'}</shiro:hasPermission>
					</a>
				</c:otherwise>
			</c:choose>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogSportingDogs" action="${ctx}/dogsporting/dog/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>
        <div class="control-group">
            <label class="control-label">犬只图片：</label>
            <div class="controls">
                <sys:singleImgUpload module="dogSportingDogs" imgId="${dogSportingDogs.dogImage}" fileSizeLimit="1024*1024*1" fileSingleSizeLimit="1024*500*1" successCallback="uploadSuccess"/>
                <form:input path="dogImage" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
                <!-- 文件上传成功的回调方法 -->
                <script type="text/javascript">
                    function uploadSuccess(file,response){
                        $("#dogImage").val(response.id);
                    }
                </script>
            </div>
        </div>

		<div class="control-group">
			<label class="control-label">犬主会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="32" class="input-xlarge required"/>
				<input type="hidden" id="tempMemberCode"/>
				<input id="" class="btn btn-primary" type="button" onclick="getMemberByMemberCode()" value="查询"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
        <div class="control-group">
            <label class="control-label">犬主姓名：</label>
            <div class="controls">
                <form:input path="memberName" htmlEscape="false" maxlength="32" class="input-xlarge required" readonly="true"/>
                <span class="help-inline"><font color="red">*</font> </span>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">证书号：</label>
            <div class="controls">
                <form:input path="certificateCode" htmlEscape="false" maxlength="32" class="input-xlarge" readonly="true"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只性别：</label>
			<div class="controls">
				<form:select path="dogGender" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只品种：</label>
			<div class="controls">
				<form:select path="dogType" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${dogTypeList}" itemLabel="breedCnName" itemValue="dogBreedCode" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只体型：</label>
			<div class="controls">
				<form:select path="somatotype" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('dog_somatotype')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${dogSportingDogs.birthday}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false,maxDate:'%y-%M-{%d}'});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只毛色：</label>
			<div class="controls">
				<form:input path="colorFlag" htmlEscape="false" maxlength="32" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
				<form:input path="identificationFlag" htmlEscape="false" maxlength="32" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鼻纹编号：</label>
			<div class="controls">
				<form:input path="noseCode" htmlEscape="false" maxlength="32" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dogsporting:dog:edit">
				<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;
			</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>