<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>开屏广告配置管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		
		 function uploadedCallback(file,res){
			 $("#fileUrl").val(res.fileUrl);
			 var fileHtml = ' <img   src="'+ res.fileUrl +'"  class="file-img" width="250" height="380" />';
			 $("#fileUrlImgDiv").html("").append(fileHtml);	
			 
	        }
	</script>
</head>
<body>
 <img alt="" src="" >
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/banner/appSplashAds/">开屏广告配置列表</a></li>
		<li class="active"><a href="${ctx}/banner/appSplashAds/form?id=${appSplashAds.id}">开屏广告配置<shiro:hasPermission name="banner:appSplashAds:edit">${not empty appSplashAds.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="banner:appSplashAds:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="appSplashAds" action="${ctx}/banner/appSplashAds/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">广告位名称：</label>
			<div class="controls">
				<form:input path="adName" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">是否上架：</label>
			<div class="controls">
				<form:select path="status" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('on_off_sale')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">跳转类型：</label>
			<div class="controls">
				<form:select path="jumpType" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('jump_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">跳转链接：</label>
			<div class="controls">
				<form:input path="jumpRoute" htmlEscape="false" maxlength="500" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开屏保留时间：</label>
			<div class="controls">
				<form:input path="residentSeconds" htmlEscape="false" maxlength="2" class="input-xlarge  digits"/>(单位:秒)
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${appSplashAds.startDate}" pattern="yyyy-MM-dd 00:00:00"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd 00:00:00',isShowClear:false});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${appSplashAds.endDate}" pattern="yyyy-MM-dd 23:59:59"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd 23:59:59',isShowClear:false});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">优先级：</label>
			<div class="controls">
				<form:input path="priority" htmlEscape="false" maxlength="4" class="input-xlarge  digits"/>(单位:数字大优先级高)
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">弹窗频率：</label>
			<div class="controls">
				<form:select path="frequency" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('ads_frequency')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group" style="width:60%">
			<label class="control-label">文件链接：</label>
			<div class="controls">
				<form:hidden path="fileUrl" readonly="true"  htmlEscape="false"  class="input-xlarge required" />
				<div id="fileUrlImgDiv" style="padding: 0px 10px 10px 0px">
					<c:if test="${appSplashAds.fileUrl !='' and  appSplashAds.fileUrl !=null}">
							<img src="${ appSplashAds.fileUrl}"  class="file-img" width="250" height="380" />
					</c:if>
				</div>
				<sys:ossUpload module="appSplashAds" duplicate="true" maxCount="10" maxSize="20480" messageTime="2000" successHideFile="true" 
					successCallback="uploadedCallback" accept="gif,jpg,jpeg,bmp,png" ></sys:ossUpload>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">文件类型：</label>
			<div class="controls">
				<form:select path="fileType" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('file_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">小程序号：</label>
			<div class="controls">
				<form:input path="programId" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="banner:appSplashAds:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>