package com.cku.schools.mrschool.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.annotation.MultiSubmit;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerShowService;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

@Controller
@RequestMapping("/schools/schoolsGroomerRegister")
public class SchoolGroomerRegisterController extends BaseController {

	@Autowired
	private GroomerRegisterService groomerRegisterService;

	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private GroomerShowService groomerShowService;

	@ModelAttribute
	public GroomerRegister get(@RequestParam(required = false) String id) {
		GroomerRegister entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerRegisterService.get(id);
		}
		if (entity == null) {
			entity = new GroomerRegister();
		}
		return entity;
	}

	@RequestMapping(value = "/getMemberMessage")
	@ResponseBody
	public Object getMemberMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		String memberCode = request.getParameter("memberCode");
		String showCode = request.getParameter("showCode");
		try {
			map = groomerRegisterService.getMemberMessage(memberCode, showCode);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequestMapping(value = "view")
	public String view(GroomerRegister groomerRegister, Model model) {
		GroomerShow  groomerShow = groomerShowService.getShowCode(groomerRegister.getShowCode());
		groomerRegister.setShowCategory(groomerShow.getShowCategory());
		groomerRegister.setShowDogBreedStr(groomerRegister.getShowDogBreed().replace("无", ""));
		model.addAttribute("groomerRegister", groomerRegister);
		return "schools/groomer/groomerRegisterView";
	}

	@RequestMapping(value = "form")
	public String form(GroomerRegister groomerRegister, Model model) {
		logger.info("--------------------groomerRegister : {}", JSONObjectUtils.toJsonString(groomerRegister));
		GroomerShow  groomerShow = groomerShowService.getShowCode(groomerRegister.getShowCode());
		logger.info("--------------------groomerShow : {}", JSONObjectUtils.toJsonString(groomerShow));
		groomerRegister.setShowCategory(groomerShow.getShowCategory());
		model.addAttribute("groomerRegister", groomerRegister);
		model.addAttribute("groomerShow",groomerShow);
		model.addAttribute("groomerShowTypeMap",groomerShowService.getShowTypeMap(groomerShow.getShowCode()));
		return "schools/groomer/groomerRegisterForm";
	}

	@RequestMapping(value = "/getRegisterMessage")
	public void getRegisterMessage(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String id = request.getParameter("id");
		response.setContentType("text/Xml;charset=utf-8");
		String str = groomerRegisterService.getRegisterMessage(id);
		response.getWriter().write(str);
	}

	@RequestMapping(value = "registerCheck")
	@ResponseBody
	public String registerCheck(HttpServletRequest request, HttpServletResponse response) {
		String showCode = request.getParameter("showCode");
		String memberCode = request.getParameter("memberCode");
		return groomerRegisterService.registerCheck(memberCode, showCode);
	}

	@ResponseBody
	@RequestMapping(value = "webFrom")
	public ResultDto<Boolean> webFrom(GroomerRegister groomerRegister, Model model, RedirectAttributes redirectAttributes) {
		try {
			TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
			groomerRegister.setSchoolNameCn(ti.getSchoolNameCn());
			groomerRegisterService.mobileSaveBySchool(groomerRegister);
			return ResultDto.success("报名成功",Boolean.TRUE);
		} catch (Exception e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_ERROR,e.getMessage());
		}
	}
	
	@RequestMapping(value = "webFormBatch")
	public String webFormBatch(GroomerRegister groomerRegister, Model model, RedirectAttributes redirectAttributes) {
		try {
			TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
			groomerRegister.setSchoolNameCn(ti.getSchoolNameCn());
			groomerRegisterService.mobileSaveBatch(groomerRegister);
			addMessage(redirectAttributes, "报名成功");
		} catch (Exception e) {
			e.printStackTrace();
			addMessage(redirectAttributes, "报名失败：" + e.getMessage());
			return "redirect:/schools/schoolsGroomer/registerBatchForm?id="+groomerRegister.getGroomerShowId();
		}
		return "redirect:/schools/schoolsGroomerRegister/groomerRegisterList";
	}

	
	@RequestMapping(value = "groomerRegisterList")
	public String list(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");

		groomerRegister.setSchoolsId(ti.getSchoolUserId());
		Page<GroomerRegister> page = groomerRegisterService.findPage(new Page<GroomerRegister>(request, response),
				groomerRegister);
		// 查询有没有退款或退款中 fmdog_breed_certified_code
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<GroomerRegister> list = page.getList().stream().map(a -> {
			GroomerRegisterVO b = new GroomerRegisterVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			b.setShowDogBreedStr(a.getShowDogBreed().replace("无,", ""));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		return "schools/groomer/groomerRegisterList";
	}

	@RequestMapping(value = "save")
	public String save(GroomerRegister groomerRegister, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerRegister)) {
			return form(groomerRegister, model);
		}
		groomerRegisterService.saveImg(groomerRegister);
		
		addMessage(redirectAttributes, "保存美容师报名表成功");
		return "redirect:/schools/schoolsGroomerRegister/groomerRegisterList/?repage";
	}
}
