package com.cku.restful.v1.sys.utils;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.util.MD5Generator;
import com.cku.util.ServletUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class CkuInterfaceUtil {
	private static final Logger logger = LoggerFactory.getLogger(CkuInterfaceUtil.class);

	private static final String KEY = "chongaibao123!@#";

	public static void main(String[] args) {
		System.out.println(MD5Generator.generate("Userid=1234&dogSex=&key=CKU-122001278/08&t=1475128792" + KEY));
	}

	private static final String KEY_MC = "ckumc@vo&TI8*hOm";

	/**
	 *
	 * @description: CKU接口校验
	 * @author: laiguanglong
	 * @date: 2016年9月29日 下午4:01:36
	 */
	public static void validate(HttpServletRequest request) {
		String t = request.getParameter("t");
		String m = request.getParameter("m");
		if (StringUtils.isBlank(t) || StringUtils.isBlank(m)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少参数t或m");
		}
		Enumeration<String> em = request.getParameterNames();
		List<String> keyList = new ArrayList<String>();
		while (em.hasMoreElements()) {
			String key = em.nextElement();
			if (!"m".equals(key)) {
				keyList.add(key);
			}
		}
		Collections.sort(keyList);
		StringBuilder sb = new StringBuilder();
		for (String key : keyList) {
			sb.append(key).append("=").append(request.getParameter(key)).append("&");
		}
		sb.deleteCharAt(sb.length() - 1);
		String md5 = MD5Generator.generate(sb.toString() + KEY);
		if (!m.equals(md5)) {
			logger.debug(sb.toString() + "|md5=" + md5);
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请检查KEY是否一致");
		}
	}

	/**
	 *
	 * @description: 接口校验并处理校验异常
	 * @author: laiguanglong
	 * @date: 2016年9月29日 下午5:05:23
	 */
	public static boolean handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
		try {
			validate(request);
			return true;
		} catch (Exception ex) {
			if (ex instanceof ZAException) {
				ZAException e = (ZAException) ex;
				int code = e.get_code();
				String message = e.getMessage();
				RESTResponse result = new RESTResponse(code, message);
				ServletUtils.writeResponse(response, result);
			}
			return false;
		}
	}

	/**
	 *
	 * @description: CKU接口校验
	 * @author: laiguanglong
	 * @date: 2016年9月29日 下午4:01:36
	 */
	public static void validateV2(HttpServletRequest request) {
		String t = request.getParameter("t");
		String m = request.getParameter("m");
		if (StringUtils.isBlank(t) || StringUtils.isBlank(m)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少参数t或m");
		}
		Enumeration<String> em = request.getParameterNames();
		List<String> keyList = new ArrayList<String>();
		while (em.hasMoreElements()) {
			String key = em.nextElement();
			if (!"m".equals(key)) {
				keyList.add(key);
			}
		}
		Collections.sort(keyList);
		StringBuilder sb = new StringBuilder();
		for (String key : keyList) {
			sb.append(key).append("=").append(request.getParameter(key)).append("&");
		}
		sb.deleteCharAt(sb.length() - 1);
		String key = sb.toString() + KEY;
		String md5 = null;
		try {
			md5 = MD5Generator.generate(key.getBytes("UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "获取编码失败");
		}
		if (!m.equals(md5)) {
			logger.debug(sb.toString() + "|md5=" + md5);
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请检查KEY是否一致");
		}
	}

	/**
	 *
	 * @description: 接口校验并处理校验异常
	 * @author: laiguanglong
	 * @date: 2016年9月29日 下午5:05:23
	 */
	public static boolean handleV2(HttpServletRequest request, HttpServletResponse response) throws IOException {
		try {
			validateV2(request);
			return true;
		} catch (Exception ex) {
			if (ex instanceof ZAException) {
				ZAException e = (ZAException) ex;
				int code = e.get_code();
				String message = e.getMessage();
				RESTResponse result = new RESTResponse(code, message);
				ServletUtils.writeResponse(response, result);
			}
			return false;
		}
	}

	public static boolean handleMC(HttpServletRequest request, HttpServletResponse response) throws IOException {
		try {

			String t = request.getParameter("t");
			String m = request.getParameter("m");
			if (StringUtils.isBlank(t) || StringUtils.isBlank(m)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少参数t或m");
			}
			Enumeration<String> em = request.getParameterNames();
			List<String> keyList = new ArrayList<String>();
			while (em.hasMoreElements()) {
				String key = em.nextElement();
				if (!"m".equals(key)) {
					keyList.add(key);
				}
			}
			Collections.sort(keyList);
			StringBuilder sb = new StringBuilder();
			for (String key : keyList) {
				sb.append(key).append("=").append(request.getParameter(key)).append("&");
			}
			sb.deleteCharAt(sb.length() - 1);
			String key = sb.toString() + KEY_MC;
			String md5 = null;
			try {
				md5 = MD5Generator.generate(key.getBytes("UTF-8"));
			} catch (UnsupportedEncodingException e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "获取编码失败");
			}
			if (!m.equals(md5)) {
				logger.debug(sb.toString() + "|md5=" + md5);
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请检查KEY是否一致");
			}
			return true;
		} catch (Exception ex) {
			if (ex instanceof ZAException) {
				ZAException e = (ZAException) ex;
				int code = e.get_code();
				String message = e.getMessage();
				RESTResponse result = new RESTResponse(code, message);
				ServletUtils.writeResponse(response, result);
			}
			return false;
		}
	}

}