package com.cku.restful.v1.groomer.web;

import com.cku.core.RESTResponse;
import com.cku.oa.handler.entity.APPHandlerRegister;
import com.cku.oa.handler.entity.AppHandlerShow;
import com.cku.oa.handler.entity.AppHandlerShowDetail;
import com.cku.restful.v1.groomer.service.AppHandlerShowService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 训犬师活动报名Controller
 *
 * @author zhangxiang
 * @version 2020-10-16
 */
@Api(tags = "人才板块-训练犬板块-张向")
@Controller
@RequestMapping(value = "/app/v1/handler/show")
public class AppGroomerShowController extends BaseRestController {

	@Autowired
	private AppHandlerShowService appHandlerShowService;


	/**
	 * 训犬活动报名列表
	 */

    @ApiOperation(value = "训犬活动报名列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNo", paramType = "query",value = "分页"),
            @ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "success",response = AppHandlerShow.class) })
	@RequestMapping(value = "/getHandlerShowList", method = RequestMethod.GET)
	@ResponseBody
	public void getHandlerShowList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appHandlerShowService.getCourseShowList(request,response);
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 训犬活动详情
	 */
    @ApiOperation(value = "训犬活动详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", paramType = "query",value = "活动id")})
	@RequestMapping(value = "/getHandlerShowDetail", method = RequestMethod.GET)
	@ApiResponses({ @ApiResponse(code = 0, message = "success",response = AppHandlerShowDetail.class) })
	@ResponseBody
	public void getHandlerShowDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appHandlerShowService.getCourseShowListDetail(request,response);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "我的报名")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo", paramType = "query",value = "分页"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页"),
            @ApiImplicitParam(name = "token",paramType = "query", value = "token")})
	@ApiResponses({ @ApiResponse(code = 0, message = "success",response = APPHandlerRegister.class) })
	@RequestMapping(value = "/getHandlerRegisterList", method = RequestMethod.GET)
	@ResponseBody
	public void getHandlerRegisterList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appHandlerShowService.getHandlerRegisterList(request,response);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "确定报名")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",paramType = "query", value = "活动id"),
			@ApiImplicitParam(name = "token",paramType = "query", value = "token")})
	@ApiResponses({ @ApiResponse(code = 0, message = "success",response = APPHandlerRegister.class) })
	@RequestMapping(value = "/checkHandlerRegister", method = RequestMethod.GET)
	@ResponseBody
	public void checkHandlerRegister(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appHandlerShowService.checkHandlerRegister(request,response);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "确认信息")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",paramType = "query", value = "活动id"),
			@ApiImplicitParam(name = "token",paramType = "query", value = "token"),
			@ApiImplicitParam(name = "avatar",paramType = "query", value = "头像"),
			@ApiImplicitParam(name = "anyBreed",paramType = "query", value = "犬种"),
			@ApiImplicitParam(name = "schoolNameCn",paramType = "query", value = "合作机构中文名")
	})
	@ApiResponses({ @ApiResponse(code = 0, message = "success",response = APPHandlerRegister.class) })
	@RequestMapping(value = "/confirmHandlerRegister", method = RequestMethod.POST)
	@ResponseBody
	public void confirmHandlerRegister(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = appHandlerShowService.confirmHandlerRegister(json,response);
		ServletUtils.writeResponse(response, result);
	}
}