package com.cku.restful.v1.finance.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.finance.service.RestPaymentRecordService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value = "/api/v1/finance")
public class RestPaymentRecordController extends BaseRestController {
	@Autowired
	private RestPaymentRecordService restPaymentRecordService;

	/**
	 * 充值记录
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/paymentRecord", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restPaymentRecordService.getList(request);
		ServletUtils.writeResponse(response, result);
	}
}