package com.cku.restful.v1.finance.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Controller
@RequestMapping(value = "/api/v1/finance")
public class RestPaymentCartController extends BaseRestController {
	@Autowired
	private PaymentCartService paymentCartService;

	private ObjectMapper objectMapper = new ObjectMapper();

	/**
	 * 查询我的购物车
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/cart", method = RequestMethod.GET)
	@ResponseBody
	public void cart(HttpServletRequest request, HttpServletResponse response) throws IOException {
		List<PaymentCart> carts = paymentCartService.getMyCart(false);
		JSONArray array = new JSONArray();
		for (int i = 0; i < carts.size(); i++) {
			PaymentCart cart = carts.get(i);
			JSONObject object = new JSONObject();
			object.put("addTime", DateUtils.formatDate(cart.getAddTime(), "yyyy-MM-dd HH:mm:ss"));
			object.put("chargingItemId", cart.getChargingItemId());
			object.put("chargingItemName", cart.getChargingItemName());
			object.put("price", cart.getPrice());
			object.put("num", cart.getNum());
			object.put("totalPrice", cart.getTotalPrice());
			object.put("id", cart.getId());
			object.put("businessTable", cart.getBusinessTable());
			object.put("businessIds", cart.getBusinessIds());
			array.add(object);
		}
		RESTResponse result = new RESTResponse("items", array);
		ServletUtils.writeResponse(response, result);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping(value = "/coupons", method = RequestMethod.POST)
	@ResponseBody
	public void coupons(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		JSONArray carts = object.getJSONArray("carts");// 购物车记录的ID
		List<String> ids = Arrays.asList(carts.toArray());
		// 根据购物车ID得到可用券列表
		RESTResponse result = new RESTResponse("data",
				objectMapper.writeValueAsString(paymentCartService.getcoupons(ids)));
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/calculate", method = RequestMethod.POST)
	@ResponseBody
	public void calculate(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		JSONArray carts = object.getJSONArray("carts");// 购物车记录的ID
		
		List<String> ids = Arrays.asList(carts.toArray());
		String couponId = null;
		if (object.get("couponId") != null) {
			couponId = object.getString("couponId");
		}
		
		// 计算总价
		RESTResponse result = new RESTResponse("data", paymentCartService.totalPrice(ids, couponId).getTotalPrice());
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据购物车ids获取登录人购物车中对应id的记录
	 * @author: zhuoHeng
	 * @version: 2016年12月16日 下午4:34:45
	 */
	@ApiOperation(value = "查询购物车", tags = { "通用支付" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "cartIds", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "source", paramType = "query", value = "cooperator")})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\r\n" + "    \"rc\": 0,\r\n" + "    \"msg\": \"OK\",\r\n"
			+ "    \"items\": [\r\n" + "        {\r\n" + "            \"addTime\": \"2020-07-15 14:43:44\",\r\n"
			+ "            \"chargingItemId\": \"14\",\r\n" + "            \"chargingItemName\": \"纯种犬鉴定服务费\",\r\n"
			+ "            \"price\": \"300.00\",\r\n" + "            \"num\": \"1\",\r\n"
			+ "            \"totalPrice\": \"300.00\",\r\n"
			+ "            \"id\": \"6b7e3bdad8e34da8ab52bc2bb02c0bf9\",\r\n"
			+ "            \"businessTable\": \"dog_appraisal\",\r\n"
			+ "            \"businessIds\": \"592fc5fb46214f6fbed955d7c21834fc\"\r\n" + "        },\r\n"
			+ "        {\r\n" + "            \"addTime\": \"2020-07-15 14:43:44\",\r\n"
			+ "            \"chargingItemId\": \"000191001\",\r\n" + "            \"chargingItemName\": \"视频鉴定费用\",\r\n"
			+ "            \"price\": \"288.00\",\r\n" + "            \"num\": \"1\",\r\n"
			+ "            \"totalPrice\": \"288.00\",\r\n"
			+ "            \"id\": \"f3406b92e4f740e78e11fb9f8e44de16\",\r\n"
			+ "            \"businessTable\": \"dog_video_appraisal\",\r\n"
			+ "            \"businessIds\": \"592fc5fb46214f6fbed955d7c21834fc\"\r\n" + "        }\r\n" + "    ]\r\n"
			+ "}") })
	@RequestMapping(value = "/cart/getCartByIds", method = RequestMethod.GET)
	@ResponseBody
	public void getCartByIds(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String cartIds = request.getParameter("cartIds");
		String source = request.getParameter("source");
		if (StringUtils.isBlank(cartIds)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
		}
		String[] ids = cartIds.split(",");
		List<PaymentCart> carts = null;
		if(StringUtils.isEmpty(source)) {
			carts = paymentCartService.getMyCart(false);
		}
		if(!StringUtils.isEmpty(source) && "cooperator".equals(source)) {
			carts = paymentCartService.getCooperatorCart(false);
		}
		
		List<PaymentCart> cartList = new ArrayList<>();
		for (PaymentCart model : carts) {
			for (String id : ids) {
				if (model.getId().equals(id)) {
					cartList.add(model);
				}
			}
		}
		
		JSONObject jsonObject = new JSONObject();
		JSONArray array = new JSONArray();
		for (int i = 0; i < cartList.size(); i++) {
			PaymentCart cart = cartList.get(i);
			JSONObject object = new JSONObject();
			object.put("addTime", DateUtils.formatDate(cart.getAddTime(), "yyyy-MM-dd HH:mm:ss"));
			object.put("chargingItemId", cart.getChargingItemId());
			object.put("chargingItemName", cart.getChargingItemName());
			object.put("price", cart.getPrice());
			object.put("num", cart.getNum());
			object.put("totalPrice", cart.getTotalPrice());
			object.put("id", cart.getId());
			object.put("businessTable", cart.getBusinessTable());
			object.put("businessIds", cart.getBusinessIds());
			array.add(object);
		}
		RESTResponse result = new RESTResponse("items", array);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 删除购物车中的一个商品
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/cart/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void removeCart(@PathVariable String id, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		paymentCartService.removeCart(id, true);

		List<PaymentCart> carts = paymentCartService.getMyCart(false);
		JSONArray array = new JSONArray();
		for (int i = 0; i < carts.size(); i++) {
			PaymentCart cart = carts.get(i);
			JSONObject object = new JSONObject();
			object.put("addTime", DateUtils.formatDate(cart.getAddTime(), "yyyy-MM-dd HH:mm:ss"));
			object.put("chargingItemId", cart.getChargingItemId());
			object.put("chargingItemName", cart.getChargingItemName());
			object.put("price", cart.getPrice());
			object.put("num", cart.getNum());
			object.put("totalPrice", cart.getTotalPrice());
			object.put("id", cart.getId());
			array.add(object);
		}
		RESTResponse result = new RESTResponse("items", array);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：删除购物车中的多个商品（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月15日 下午3:13:34
	 */
	@RequestMapping(value = "/cart/delete", method = RequestMethod.DELETE)
	@ResponseBody
	public void removeCart(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 这里获取member，如果token失效，会抛出-30，用户信息验证失败的异常
		UserUtils.getLoginMember();
		String ids = request.getParameter("ids");
		String[] paymentCartId = ids.split(",");
		for (String id : paymentCartId) {
			paymentCartService.removeCart(id, true);
		}
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：删除购物车中的全部商品（宠爱王国使用） @author: zhangjunwu
	 */
	@RequestMapping(value = "/cart/delete/all", method = RequestMethod.DELETE)
	@ResponseBody
	public void removeCartAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 这里获取member，如果token失效，会抛出-30，用户信息验证失败的异常
		UserUtils.getLoginMember();
		List<PaymentCart> carts = paymentCartService.getMyCart(false);
		for (PaymentCart card : carts) {
			paymentCartService.removeCart(card.getId(), true);
		}
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}
}
