package com.cku.restful.v1.ckudc.web;


import com.cku.core.RESTResponse;
import com.cku.restful.v1.ckudc.service.RestCkudcService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/ckudc/v1")
public class RestCkudcController extends BaseRestController {

	@Autowired
	private RestCkudcService restCkudcService;
	/**
	 *
	 * @description: CKUDC查询犬只信息接口
	 * @author: lyy
	 */
	@RequestMapping(value = "/dog", method = RequestMethod.GET)
	@ResponseBody
	public void getDogInfo(HttpServletRequest request,HttpServletResponse response) throws IOException {
		RESTResponse result = restCkudcService.getDogInfo(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @description: CKUDC查询犬舍信息接口
	 * @author: lyy
	 */
	@RequestMapping(value = "/kennel", method = RequestMethod.GET)
	@ResponseBody
	public void getKennel(HttpServletRequest request,HttpServletResponse response) throws IOException {
		RESTResponse result = restCkudcService.getKennel(request);
		ServletUtils.writeResponse(response, result);
	}


	/**
	 *
	 * @description: CKUDC犬只交配查询接口
	 * @author: lyy
	 */
	@RequestMapping(value = "/bloodline", method = RequestMethod.GET)
	@ResponseBody
	public void bloodline(HttpServletRequest request,HttpServletResponse response) throws IOException {
		RESTResponse result = restCkudcService.bloodline(request);
		ServletUtils.writeResponse(response, result);
	}
	/**
	 *
	 * @description: CKUDC种犬配犬信息查询接口
	 * @author: lyy
	 */
	@RequestMapping(value = "/getDogNewBornByMale", method = RequestMethod.GET)
	@ResponseBody
	public void get(HttpServletRequest request,HttpServletResponse response) throws IOException {
		RESTResponse result = restCkudcService.getDogNewBornByMale(request);
		ServletUtils.writeResponse(response, result);
	}
}