package com.cku.partner.club.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.clubdog.dao.TcbDogChipDao;
import com.cku.oa.clubdog.entity.TcbDogChip;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogChipChangeService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 *user chaixueteng
 *2016年10月10日
 */
@Service
@Transactional(readOnly = true)
public class TcbDogService {
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private RestDogChipService restDogChipService;
	@Autowired
	private DogChipChangeDao dogChipChangeDao;
	@Autowired
	private DogChipChangeService dogChipChangeService;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	public TcbDogChipDao tcbDogChipDao;
	
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	/**
	 * 新生犬芯片录入(旧出生纸)
	 * @Author chaixueteng
	 * @2016年10月14日下午3:27:04
	 */
	@Transactional(readOnly = false)
	public void add(String birthCerRegCode,String identificationFlag,String memberCode,String dna,String parent) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		Member member = memberService.getByMemberCode(memberCode);
		if(member!=null&&!MemberUtil.isActiveMember(member)){
			throw new ZAException(-1,"新犬主会员无效！");
		}else if(member==null){
			throw new ZAException(-1,"找到不到该会员号！");
		}
		//出生纸信息变更
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		birth.setIdentificationFlag(identificationFlag);
		birth.setAddUser(loginName);
		birth.setChipInjectDate(new Date());//芯片录入时间
		birth.setTempMemberCode(memberCode);
		birth.setTempUserName(member.getName());
		dogBirthCertificateService.updateByBirth(birth);
		//芯片变更记录
		DogChipChange dogChipChange = new DogChipChange();
		PaymentChargingItem paymentChargingItem = restDogChipService.getChipItem();//芯片钱
		//修改配种证明表
		dogChipChange.preInsert();
		dogChipChange.setBirthCode(birthCerRegCode);
		dogChipChange.setChipCodeNew(identificationFlag);
		dogChipChange.setPaymentMemberCode(memberCode);
		dogChipChange.setPrice(paymentChargingItem.getPrice());
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setPaymentState("2");
		dogChipChange.setRemarks("淘宠宝登记");
		dogChipChange.setProcessState("1");
		dogChipChange.setProcessTime(new Date());
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeDao.insert(dogChipChange);
		//生成新生犬记录
		buildDogChip(birth,dogChipChange.getId());
		//生成新生犬操作记录表
		bulidTcbDogChip(birth);
		}
	private void bulidTcbDogChip(DogBirthCertificate birth) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		TcbDogChip tcbDogChip = new TcbDogChip();
		tcbDogChip.preInsert();
		tcbDogChip.setBirthCode(birth.getBirthCerRegCode());
		tcbDogChip.setChipCode(birth.getIdentificationFlag());
		tcbDogChip.setOrgCode(org.getMemberCode());
		tcbDogChip.setOrgId(org.getId());
		PaymentChargingItem saveInfoItem = null;
		if (isInXMounth(birth.getDogBirthday(),12)) {//一岁内
			saveInfoItem = restDogChipService.getSaveInfoItem(birth.getBirthCerRegCode());
		}else if(isInXMounth(birth.getDogBirthday(),24)){//两岁至一岁内
			saveInfoItem = restDogChipService.getSaveInfoYoungItem();
		}else{
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬年龄已超过2岁，不允许办理新生犬登记");
		}
		tcbDogChip.setPrice(saveInfoItem.getPrice());
		tcbDogChip.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		tcbDogChipDao.insert(tcbDogChip);
	}
	/**
	 * 新生犬芯片录入(新出生纸)
	 * @Author chaixueteng
	 * @2016年10月14日下午3:27:04
	 */
	@Transactional(readOnly = false)
	public void newDogAdd(String birthCerRegCode,String identificationFlag,String memberCode,String dna,String parent) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		Member member = memberService.getByMemberCode(memberCode);
		if(member!=null&&!MemberUtil.isActiveMember(member)){
			throw new ZAException(-1,"新犬主会员无效！");
		}else if(member==null){
			throw new ZAException(-1,"找到不到该会员号！");
		}
		//出生纸信息变更
		DogBirthCertificate birth = dogBirthCertificateService.getByBirthCerRegCode(birthCerRegCode);
		birth.setIdentificationFlag(identificationFlag);
		birth.setAddUser(loginName);
		birth.setChipInjectDate(new Date());//芯片录入时间
		birth.setTempMemberCode(memberCode);
		birth.setTempUserName(member.getName());
		dogBirthCertificateService.updateByBirth(birth);
		//芯片变更记录
		DogChipChange dogChipChange = dogChipChangeService.getByIdentificationFlag(identificationFlag);
		dogChipChange.setReviewState("1");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setRemarks("淘宠宝登记犬");
		dogChipChange.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogChipChangeService.save(dogChipChange);
		//生成新生犬记录
		buildDogChip(birth,dogChipChange.getId());
		//生成新生犬操作记录表
		bulidTcbDogChip(birth);
	}
	
	
	
	/**
	 * 构造血统证书表
	 * @Author chaixueteng
	 * @2017年11月1日下午2:59:32
	 */
	private void buildDogChip(DogBirthCertificate dogBirthCertificate,String dogChipChangeId) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		// 构造持久对象
		DogChip po = new DogChip();
		po.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		po.setPaymentMemberCode(dogBirthCertificate.getTempMemberCode());
		//计算价格
		//po.setPrice(getDogChipPrice(dogBirthCertificate));
		// 合作机构
		po.setDnaSaveWay("0");
		po.setIsDnaParentsCompare("0");
		po.setHospitalName(org.getName());
		po.setHospitalCode(org.getId());
		po.setReviewState("0");
		po.setPaymentState("2");
		po.setPaymentTime(new Date());
		po.setProcessState("0");
		po.setPrintState("0");
		po.setRemarks("淘宠宝登记犬");
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-M-d");
		po.setOperator(loginName+":"+formatter.format(new Date()));
		// 业务校验
		dogChipService.validateBusiness(po,dogBirthCertificate);
		po.setDogChipChangeId(dogChipChangeId);
		// 写入业务表
		dogChipService.save(po);
		po.setReviewState("1");
		dogChipService.changeReviewStatus(po);
		dogChipService.changeProcessState(po);
	}
	
	/**
	 * 
	 * @description: 传入的时间是否在当前时间x个月内
	 * 1要求传入的日期都是yyyy-MM-dd的格式，时分秒都得是0
	 * 2x必须为大于0的正整数
	 * 3假设传入的参数为2016-11-14 00：00：00，只要当前时间小于2016-12-14 23：59：59都返回true
	 * @author: laiguanglong
	 * @date: 2016年12月14日 下午6:05:38
	 */
	public static boolean isInXMounth(Date date,int x){
		if(date==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"日期为空");
		}
		if(x<1){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"月份数必须为大于1的正整数");
		}
		try {
			date = sdf.parse(sdf.format(date));
		} catch (ParseException e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"日期有误");
		}
		Calendar dateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		dateCalendar.add(Calendar.MONTH, x); //月份加x  
		dateCalendar.add(Calendar.DATE, 1); //日期加1
		if(new Date().getTime()<dateCalendar.getTimeInMillis()){
			return true;
		}else{
			return false;
		}
	}
}