package com.cku.partner.club.service;

import com.cku.oa.dog.dao.*;
import com.cku.oa.dog.entity.*;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.sampling.service.SamplingService;
import com.thinkgem.jeesite.common.utils.DateUtils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * Created by laiguanglong on 2016/12/20.
 */
@Service
@Transactional(readOnly = true)
public class ClubDogChipDeleteService {
    private Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private DogBirthCertificateDao dogBirthCertificateDao;
    @Autowired
    public DogChipChangeDao dogChipChangeDao;
    @Autowired
    public DogDao dogDao;
    @Autowired
    public DogChipDao dogChipDao;
    @Autowired
    public DogBloodSaveDao dogBloodSaveDao;
    @Autowired
    private DogDnaArchiveDao dogDnaArchiveDao;
    @Autowired
    private DogDnaParentsCompareDao dogDnaParentsCompareDao;
	@Autowired
	private SamplingService samplingService;

    /**
     * @description: 地方俱乐部新生犬登记业务记录删除逻辑（未生成订单）
     * @author: laiguanglong
     * @date: 2016/12/20 17:01
     */
    @Transactional(readOnly = false)
    public void deleteUnpayDogChipBusiness(String birthCode){
        //位点分析记录出生纸号为空的情况
        if(StringUtils.isBlank(birthCode)){
            return;
        }
        DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(birthCode);
        //删除DogChipChange和还原DogBirthCertificate
        undoDogChipChangeAndDogBirthCertificate(dogBirthCertificate);
        //4删除dog_chip表
        DogChip dogChip = dogChipDao.getByBirthCodeAndNullRunningNumber(dogBirthCertificate.getBirthCerRegCode());
        if(dogChip!=null&&StringUtils.isBlank(dogChip.getRunningNumber())){
            dogChipDao.deleteYes(dogChip);
            String isDnaParentsCompare = dogChip.getIsDnaParentsCompare();
            String dnaSaveWay = dogChip.getDnaSaveWay();
            //6删除dog_dna_archive表
            if(StringUtils.isNotBlank(dnaSaveWay)&&"1".equals(dnaSaveWay)){//删除位点分析
                DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByBirthCodeAndNullRunningNumber(dogBirthCertificate.getBirthCerRegCode());
                if(dogDnaArchive!=null&&StringUtils.isBlank(dogDnaArchive.getRunningNumber())){
                    dogDnaArchiveDao.deleteYes(dogDnaArchive);
                }
                if(StringUtils.isNotBlank(dogDnaArchive.getSamplingCode())) {
                	samplingService.unbindDogInfoBySamplingCode(dogDnaArchive.getSamplingCode());
                }
            }
            //7删除dog_dna_parents_compare表
            if(StringUtils.isNotBlank(isDnaParentsCompare)&&"1".equals(isDnaParentsCompare)){
                DogDnaParentsCompare dogDnaParentsCompare = dogDnaParentsCompareDao.getByBirthCodeAndNullRunningNumber(dogBirthCertificate.getBirthCerRegCode());
                if(dogDnaParentsCompare!=null&&StringUtils.isBlank(dogDnaParentsCompare.getRunningNumber())){
                    dogDnaParentsCompareDao.deleteYes(dogDnaParentsCompare);
                }
            }
        }
        //5删除dog_blood_save表
        DogBloodSave dogBloodSave = dogBloodSaveDao.getByBirthCodeAndNullRunningNumber(dogBirthCertificate.getBirthCerRegCode());
        if(dogBloodSave!=null&&StringUtils.isBlank(dogBloodSave.getRunningNumber())){
            dogBloodSaveDao.deleteYes(dogBloodSave);
        }
    }

    /**
     * @description: 删除DogChipChange和还原DogBirthCertificate
     * @author: laiguanglong
     * @date: 2016/12/21 11:25
     */
    public void undoDogChipChangeAndDogBirthCertificate(DogBirthCertificate dogBirthCertificate){
        if(StringUtils.isNotBlank(dogBirthCertificate.getIdentificationFlag())){
            //2删除dog_chip_change表
            DogChipChange dogChipChange = dogChipChangeDao.getByIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
            if(dogChipChange!=null&&StringUtils.isBlank(dogChipChange.getRunningNumber())){
                dogChipChangeDao.deleteYes(dogChipChange);
                String dogId = dogChipChange.getDogId();
                String chipCodeOld = dogChipChange.getChipCodeOld();
                //3如果dog_chip_change表记录已有犬只记录和旧芯片号，还原犬只表芯片号记录
                if (StringUtils.isNotBlank(dogId)&&StringUtils.isNotBlank(chipCodeOld)) {
                    Dog dog= dogDao.get(dogId);
                    dog.setIdentificationFlag(chipCodeOld);
                    dogDao.update(dog);
                }
            }
            
            DogChip dogChip = dogChipDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
			boolean clearFlag = Boolean.TRUE;
			if (Objects.nonNull(dogChip) || StringUtils.isNotBlank(dogBirthCertificate.getPedigreeCertified())) {
				clearFlag = Boolean.FALSE;
			}
			
            if(dogBirthCertificate.getCreateDate().getTime()>DogBirthCertificateService.newBusinessTimeMillis){//新出生纸未缴费删除不清空芯片
            	if (StringUtils.isNotBlank(dogBirthCertificate.getAddUser()) && clearFlag) {
            		dogBirthCertificate.setAddUser(null);
    			}
            }else{//1还原出生纸表的identificationFlag和addUser字段为null
            	dogBirthCertificate.setIdentificationFlag(null);
            	dogBirthCertificate.setAddUser(null);
            }
            dogBirthCertificate.setTempMemberCode(null);
            dogBirthCertificate.setTempUserName(null);
            dogBirthCertificateDao.update(dogBirthCertificate);
        }
    }

    /**
     * @description: 删除地方俱乐部提交的新生犬登记未缴费订单
     * @author: laiguanglong
     * @date: 2016/12/21 13:59
     */
    public void removeDogChipChangeOrder(String businessIds){
        DogChipChange dogChipChange = dogChipChangeDao.get(businessIds);
        if(dogChipChange!=null){
            //查看该业务记录是否有其他已缴费的订单
            if(dogChipChangeDao.getPayedDogChipChangeOrderCount(dogChipChange.getId())<1){
                if(StringUtils.isBlank(dogChipChange.getChipCodeNew())){
                    return;
                }
                DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(dogChipChange.getChipCodeNew());
                if(dogBirthCertificate!=null){
                    undoDogChipChangeAndDogBirthCertificate(dogBirthCertificate);
                }
            }
        }
    }

    /**
     * @description: 删除地方俱乐部提交的新生犬登记，未生成订单的记录
     * @author: laiguanglong
     * @date: 2016/12/21 14:27
     */
    @Transactional(readOnly = false)
    public int removeDogChipChangeNoOrder(){
        int count = 0;
        //1查出符合的记录
        Date date = new Date();
        try {
            //设置时间为当前日期0时0分0秒
            date = new SimpleDateFormat("yyyy-MM-dd").parse(DateUtils.getDate());
        } catch (ParseException e1) {
            e1.printStackTrace();
        }
        List<DogChipChange> dogChipChangeList = dogChipChangeDao.getDogChipChangeNoOrder(date);
        //2删除
        for(DogChipChange dogChipChange:dogChipChangeList){
            if(StringUtils.isBlank(dogChipChange.getChipCodeNew())){
                continue;
            }
            try {
                DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(dogChipChange.getChipCodeNew());
                if(dogBirthCertificate!=null){
                    deleteUnpayDogChipBusiness(dogBirthCertificate.getBirthCerRegCode());
                    count++;
                    logger.info("删除地方俱乐部提交的出生纸编号为"+dogBirthCertificate.getBirthCerRegCode()+"的新生犬登记，未生成订单的记录成功");
                }
            } catch (Exception e) {
                logger.warn("删除地方俱乐部提交的新生犬登记，未生成订单的记录失败",e);
            }
        }
        return count;
    }
}
