package com.cku.oa.sys.util;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
/**
 * 工具类，用于犬只的基本校验
 * @author fanhuibin
 *
 */
public class DogUtil {
	
	/**
	 * @Description : 根据当前登录端判断犬种
	 * @param member
	 * @return
	 */
	public static void validDogType(Dog dog){
		Member po = UserUtils.getLoginMember();
		if("4".equals(po.getUser().getUserType())){//杜高会员端登录
			if(!"292".equals(dog.getDogBreed())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号!");
			}
		}else if("2".equals(po.getUser().getUserType())){//CKU会员登录
			if("292".equals(dog.getDogBreed())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号!");
			}
		}
	}
	
	/**
	 * @Description : 根据当前登录端及登记卡判断犬种类型
	 * @param cuihuaiyu
	 * @return
	 */
	public static void validBirthDogType(DogBirthCertificate dogBirthCertificate){
		Member po = UserUtils.getLoginMember();
		if("4".equals(po.getUser().getUserType())){//杜高会员端登录
			if(!"292".equals(dogBirthCertificate.getDogBreed())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的登记卡编号!");
			}
		}else if("2".equals(po.getUser().getUserType())){//CKU会员登录
			if("292".equals(dogBirthCertificate.getDogBreed())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的登记卡编号!");
			}
		}
	}
}
