package com.cku.oa.sys.service;

import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.ZtSmsUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

@Service
@Transactional(readOnly = true)
public class MemberRemindService {

    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private KennelDao kennelDao;
    @Autowired
    private MemberDao memberDao;

    /**
     * @description: 会员快过期提醒
     * @author: laiguanglong
     * @date: 2017/8/17 18:01
     */
    public int memberRemind() {
        int count = 0;
        //犬舍10天后过期提醒
        count += kennelCloseExpireRemind();
        //会员10天后过期提醒
        count += memberTenDayExpireRemind();
        //会员5天后过期提醒
        count += memberFiveDayExpireRemind();
        return count;
    }

    /**
     * @description: 犬舍10天后过期提醒
     * @author: laiguanglong
     * @date: 2017/8/21 10:10
     */
    private int kennelCloseExpireRemind() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        int count = 0;
        List<Kennel> kennelList = kennelDao.getCloseExpireKennel();
        logger.info("犬舍10天后过期提醒数量为" + kennelList.size());
        for (Kennel kennel : kennelList) {
            Member member = memberDao.getByMemberCode(kennel.getMemberCode());
            if (member == null) {
                continue;
            }
            String content = "尊敬的" + member.getName() + "会员您好，您的犬舍将于" + sdf.format(kennel.getEndTime()) + "截止，为了不影响您的业务办理，请及时续费。续费期为有效期截止后一个月内，如超期续费，将按照新注册犬舍标准收费。";
            if(null != member.getSafeMobile() && !"".equals(member.getSafeMobile())){
                if (sendRemind(member.getMemberCode(), member.getSafeMobile(), content)) {
                    count++;
                }
            }else{
                if (sendRemind(member.getMemberCode(), member.getMobile(), content)) {
                    count++;
                }
            }
        }
        return count;
    }

    /**
     * @description: 会员10天后过期提醒
     * @author: laiguanglong
     * @date: 2017/8/21 10:10
     */
    private int memberTenDayExpireRemind() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        int count = 0;
        List<Member> memberlList = memberDao.getTenDayExpireMember();
        logger.info("会员10天后过期提醒数量为" + memberlList.size());
        for (Member member : memberlList) {
            String memberType = "";
            if ("basic".equals(member.getMemberType())) {
                memberType = "基础";
            } else if ("professional".equals(member.getMemberType())) {
                memberType = "专业";
            }
            String content = "尊敬的" + member.getName() + "会员您好，您的" + memberType + "会员将于" + sdf.format(member.getMemberEndDate()) + "截止，为了不影响您的业务办理，请及时续费。续费期为有效期截止后一个月内，如超期续费，将按照新注册会员标准收费。";
            if(null != member.getSafeMobile() && !"".equals(member.getSafeMobile())){
            	if (sendRemind(member.getMemberCode(), member.getSafeMobile(), content)) {
            		count++;
            	}
            }else{
            	if (sendRemind(member.getMemberCode(), member.getMobile(), content)) {
            		count++;
            	}
			}
        }
        return count;
    }

    /**
     * @description: 会员5天后过期提醒
     * @author: laiguanglong
     * @date: 2017/8/21 10:10
     */
    private int memberFiveDayExpireRemind() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
        int count = 0;
        List<Member> memberlList = memberDao.getFiveDayExpireMember();
        logger.info("会员5天后过期提醒数量为" + memberlList.size());
        for (Member member : memberlList) {
            String memberType = "";
            if ("basic".equals(member.getMemberType())) {
                memberType = "基础";
            } else if ("professional".equals(member.getMemberType())) {
                memberType = "专业";
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(member.getMemberEndDate());
            calendar.add(Calendar.DATE, 1);
            String content = "尊敬的" + member.getName() + "会员您好，您的" + memberType + "会员将于" + sdf.format(member.getMemberEndDate()) + "截止，为了不影响您的业务办理，系统将于" + sdf.format(calendar.getTime()) + "根据您的会员类型，自动从您的账户余额内扣除相应的会员费，以完成会员续费，请确保账户余额充足。如到期后不再继续注册CKU会员，请及时联系会员部进行账户余额提现。";
            if(null != member.getSafeMobile() && !"".equals(member.getSafeMobile())){
            	if (sendRemind(member.getMemberCode(), member.getSafeMobile(), content)) {
            		count++;
            	}
            }else{
            	if (sendRemind(member.getMemberCode(), member.getMobile(), content)) {
            		count++;
            	}
			}
        }
        return count;
    }

    private boolean sendRemind(String memberCode, String mobile, String content) {
        boolean flag = false;
        try {
            logger.info(content);
            String result = ZtSmsUtil.sendNoteYX(content, mobile);
            if (StringUtils.isNotBlank(result)) {
                logger.info("给会员号为" + memberCode + ",电话为" + mobile + "的会员发送快过期提醒短信成功");
                flag = true;
            }
        } catch (Exception e) {
            logger.warn("给会员号为" + memberCode + ",电话为" + mobile + "的会员发送快过期提醒短信失败", e);
        }
        return flag;
    }
}