/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import com.cku.oa.sys.entity.OrgDogTypeLimit;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 俱乐部经营犬种DAO接口
 *
 * @author yuanshuai
 * @version 2019-10-16
 */
@MyBatisDao
public interface OrgDogTypeLimitDao extends CrudDao<OrgDogTypeLimit> {

	/**
	 * @Description： 根据俱乐部id查找犬种
	 * @author: yuanshuai
	 * @date: 2019/10/16 14:14
	 */
	List<String> findTypeByOrgId(@Param("orgId") String orgId);

	/**
	 * @Description： 校验单犬种俱乐部犬种是否可用
	 * @author: yuanshuai
	 * @date: 2019/10/21 10:28
	 */
	Integer checkSingleOrgDogType(@Param("orgId") String orgId, @Param("dogTypeId") String dogTypeId);

	/**
	 * @Description： 根据俱乐部id查找犬种中文
	 * @author: yuanshuai
	 * @date: 2019/10/16 14:14
	 */
	List<String> findTypeCnByOrgId(@Param("orgId") String orgId);
}