package com.cku.oa.sampling.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 采样包分发渠道（0会员，1俱乐部）
 */
public enum SamplingDistributionChannelEnum implements IEnum<Integer> {

	MEMBER(0, "会员"),
	ORG(1, "俱乐部");

	private Integer code;

	private String message;

	SamplingDistributionChannelEnum(Integer code, String message) {
		this.code = code;
		this.message = message;
	}

	@Override
	public Integer code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.message;
	}

}
