package com.cku.oa.org.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.org.entity.OrgSampling;
import com.cku.oa.org.service.OrgSamplingService;
import com.cku.oa.org.vo.OrgSamplingDetailListVo;
import com.cku.oa.org.vo.OrgSamplingGroupVo;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.service.OrgService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * 俱乐部采样包发放Controller
 *
 * @author yuanshuai
 * @version 2023-05-28
 */
@Controller
@RequestMapping(value = "${adminPath}/org/orgSampling")
public class OrgSamplingController extends BaseController {

    @Autowired
    private OrgSamplingService orgSamplingService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private SamplingService samplingService;

    @ModelAttribute
    public OrgSampling get(@RequestParam(required = false) String id) {
        OrgSampling entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = orgSamplingService.get(id);
        }
        if (entity == null) {
            entity = new OrgSampling();
        }
        return entity;
    }

    @RequiresPermissions("org:orgSampling:view")
    @RequestMapping(value = "groupList")
    public String group(OrgSamplingGroupVo groupVo, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<OrgSamplingGroupVo> page = orgSamplingService.findGroupPage(new Page<>(request, response), groupVo);
        model.addAttribute("orgId", groupVo.getOrgId());
        model.addAttribute("page", page);
        return "oa/org/orgSamplingGroupList";
    }

    @RequiresPermissions("org:orgSampling:view")
    @RequestMapping(value = "detailList")
    public String detailList(OrgSamplingDetailListVo listVo, HttpServletRequest request, HttpServletResponse response, Model model) {
        Org org = orgService.get(listVo.getOrgId());
        if (Objects.isNull(org) || StringUtils.isBlank(org.getId())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作机构id有误");
        }
        Page<OrgSamplingDetailListVo> page = orgSamplingService.findDetailListPage(new Page<>(request, response), listVo);
        model.addAttribute("batchNum", listVo.getBatchNum());
        model.addAttribute("org", org);
        model.addAttribute("page", page);
        return "oa/org/orgSamplingDetailList";
    }

    @RequiresPermissions("org:orgSampling:add")
    @RequestMapping(value = "addForm")
    public String addForm(OrgSampling orgSampling, Model model) {
        Org org = orgService.get(orgSampling.getOrgId());
        if (Objects.isNull(org) || StringUtils.isBlank(org.getId())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作机构id有误");
        }
        model.addAttribute("samplingList", samplingService.findUnuseList());
        model.addAttribute("org", org);
        orgSampling.setAddress(org.getAddress());
        model.addAttribute("orgSampling", orgSampling);
        return "oa/org/orgSamplingAddForm";
    }

    @RequiresPermissions("org:orgSampling:add")
    @RequestMapping(value = "add")
    @ResponseBody
    public ResultDto<String> add(OrgSampling request) {
        try {
            orgSamplingService.add(request);
        } catch (ZAException e) {
            e.printStackTrace();
            return ResultDto.error(ZAErrorCode.ZA_ERROR, "发放采样包失败：" + e.getMessage());
        }
        return ResultDto.success("发放采样包成功");
    }

    @RequiresPermissions("org:orgSampling:del")
    @RequestMapping(value = "delete")
    public String delete(OrgSampling request, RedirectAttributes redirectAttributes) {
        try {
            orgSamplingService.delete(request);
            addMessage(redirectAttributes, "删除采样包成功");
        } catch (ZAException e) {
            e.printStackTrace();
            addMessage(redirectAttributes, "删除采样包失败：" + e.getMessage());
        }
        return "redirect:" + Global.getAdminPath() + "/org/orgSampling/detailList?orgId=" + request.getOrgId() + "&batchNum=" + request.getBatchNum() + "&repage";
    }

    @RequiresPermissions("org:orgSampling:del")
    @RequestMapping(value = "batchDelete")
    public String batchDelete(OrgSampling request, RedirectAttributes redirectAttributes) {
        try {
            orgSamplingService.batchDelete(request);
            addMessage(redirectAttributes, "删除该批采样包成功");
        } catch (ZAException e) {
            e.printStackTrace();
            addMessage(redirectAttributes, "删除该批采样包失败：" + e.getMessage());
        }
        return "redirect:" + Global.getAdminPath() + "/org/orgSampling/groupList?orgId=" + request.getOrgId() + "&repage";
    }

}