package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ResultDto;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.vo.DogPedigreeCertifiedChangeVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.dao.AssociationDao;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Association;
import com.cku.oa.sys.entity.Org;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.service.AreaService;

/**
 * 证书换发Controller
 * 
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "${adminPath}/dogpedigreecertifiedchange/dogPedigreeCertifiedChange")
public class DogPedigreeCertifiedChangeController extends BaseController {

	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private AssociationDao associationDao;
	@Autowired
	private AreaService areaService;
	@Autowired
	private OrgDao orgDao;

	private final static String REPAGE = "redirect:" + Global.getAdminPath()
			+ "/dogpedigreecertifiedchange/dogPedigreeCertifiedChange/?repage";

	private final static String AUTHORITY_PRDFIX = "dogpedigreecertifiedchange:dogPedigreeCertifiedChange:";

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogPedigreeCertifiedChange",
				new DogPedigreeCertifiedChange(runningNumber, chargingItemId, memberCode));
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		model.addAttribute("associationList", associationDao.findAllList(new Association()));
		model.addAttribute("provinceList", areaService.getProvince());
		return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedChangeService.add(dogPedigreeCertifiedChange);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, Model model) {
		List<DogPedigreeCertifiedChange> list = dogPedigreeCertifiedChangeService.findList(dogPedigreeCertifiedChange);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogPedigreeCertifiedChangeVO> list2 = list.stream().map(a -> {
			DogPedigreeCertifiedChangeVO b = new DogPedigreeCertifiedChangeVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);
		return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeOrderList";
	}

	@ModelAttribute
	public DogPedigreeCertifiedChange get(@RequestParam(required = false) String id) {
		DogPedigreeCertifiedChange entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogPedigreeCertifiedChangeService.get(id);
		}
		if (entity == null) {
			entity = new DogPedigreeCertifiedChange();
		}
		return entity;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<DogPedigreeCertifiedChange> page = dogPedigreeCertifiedChangeService
				.findPage(new Page<DogPedigreeCertifiedChange>(request, response), dogPedigreeCertifiedChange);
		for (DogPedigreeCertifiedChange po : page.getList()) {
			po.setBusinessState(dogPedigreeCertifiedChangeService.getBusinessState(po));
			po.setIsCanCancel(dogPedigreeCertifiedChangeService.isCanCancel(po) == false ? "0" : "1");
		}

		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogPedigreeCertifiedChange> list = page.getList().stream().map(a -> {
			DogPedigreeCertifiedChangeVO b = new DogPedigreeCertifiedChangeVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		model.addAttribute("newBusinessTimeMillis", dogPedigreeCertifiedChangeService.newBusinessTimeMillis);
//		if ("230".equals(dogPedigreeCertifiedChange.getDogBreed())) {
//			return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeListZangao";
//		}
		return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChange);
		return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChange);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		model.addAttribute("dogColorMarkList",
				dogColorMarkService.getByDogBreedCode(dogPedigreeCertifiedChange.getDogBreed()));
		model.addAttribute("associationList", associationDao.findAllList(new Association()));
		model.addAttribute("provinceList", areaService.getProvince());
		if (StringUtils.isNotBlank(dogPedigreeCertifiedChange.getOrgId())) {
			Org org = orgDao.get(dogPedigreeCertifiedChange.getOrgId());
			if (org != null) {
				dogPedigreeCertifiedChange.setProvince(org.getProvince());
			}
		}
		return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "edit")
	public String edit(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogPedigreeCertifiedChange)) {
			return editForm(dogPedigreeCertifiedChange, model);
		}
		if (StringUtils.isNotBlank(dogPedigreeCertifiedChange.getOrgId())) {
			Org org = orgDao.get(dogPedigreeCertifiedChange.getOrgId());
			if (org != null) {
				dogPedigreeCertifiedChange.setOrgId(org.getId());
				dogPedigreeCertifiedChange.setOrgName(org.getName());
			}
		}
		dogPedigreeCertifiedChangeService.save(dogPedigreeCertifiedChange);
		addMessage(redirectAttributes, "编辑证书换发成功");
		return repage(dogPedigreeCertifiedChange);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogPedigreeCertifiedChange dogPedigreeCertifiedChange, RedirectAttributes redirectAttributes) {
		dogPedigreeCertifiedChangeService.delete(dogPedigreeCertifiedChange);
		addMessage(redirectAttributes, "删除证书换发成功");
		return repage(dogPedigreeCertifiedChange);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		model.addAttribute("dogPedigreeCertifiedChange", dogPedigreeCertifiedChangeService.get(id));
		return "oa/dog/dogpedigreecertifiedchange/dogPedigreeCertifiedChangeAuditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedChangeService.audit(dogPedigreeCertifiedChange);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resolve")
	@RequestMapping(value = "resolve")
	public String resolve(DogPedigreeCertifiedChange dogPedigreeCertifiedChange,
			RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "处理证书换发成功");
		try {
			dogPedigreeCertifiedChangeService.resolve(dogPedigreeCertifiedChange);
		} catch (Exception e) {
			addMessage(redirectAttributes, "处理证书换发失败:" + e.getMessage());
		}
		return repage(dogPedigreeCertifiedChange);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "print")
	public String print(DogPedigreeCertifiedChange print, Model model,HttpServletRequest request) {
		DogPedigreeCertifiedChange ogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(print.getId());
		Dog dog = dogService.getByPedigreeCertifiedEn(ogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		String path = dogService.processPrintBusiness(dog, model, Boolean.TRUE);
		// 证书换发打印后标记为已完成
		ogPedigreeCertifiedChange.setIsFinish("1");
		dogPedigreeCertifiedChangeService.save(ogPedigreeCertifiedChange);
		return path;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetPrint")
	@ResponseBody
	public ResultDto<Boolean> resetPrint(DogPedigreeCertifiedChange resetPrint, RedirectAttributes redirectAttributes) {
		DogPedigreeCertifiedChange ogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService
				.get(resetPrint.getId());
		Dog dog = dogService.getByPedigreeCertifiedEn(ogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		dogService.resetPrint(dog.getId());
		return ResultDto.success("重置打印成功", Boolean.TRUE);
	}

	/**
	 * 
	 * @description: 根据犬种判断是否跳藏獒的列表页
	 * @author: laiguanglong
	 * @date: 2016年9月3日 下午3:48:33
	 */
	private String repage(DogPedigreeCertifiedChange dogPedigreeCertifiedChange) {
//		if ("230".equals(dogPedigreeCertifiedChange.getDogBreed())) {
//			return REPAGE + "&dogBreed=230";
//		}
		return REPAGE;
	}

	/**
	 *
	 * @Description：撤销证书换发
	 * @author: zhuoHeng
	 * @version: 2016年10月29日 下午4:10:00
	 */
	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "canceled")
	public String canceled(DogPedigreeCertifiedChange dogPedigreeCertifiedChange,
			RedirectAttributes redirectAttributes) {
		if (dogPedigreeCertifiedChange == null) {
			addMessage(redirectAttributes, "id有误");
		}
		dogPedigreeCertifiedChangeService.canceled(dogPedigreeCertifiedChange);
		addMessage(redirectAttributes, "撤销证书换发成功");
		return REPAGE;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getMessageByOverseasPedigreeCertified")
	@ResponseBody
	public Object getMessageByOverseasPedigreeCertified(
			@RequestParam(required = true) String overseasPedigreeCertified) {
		HashMap<String, String> map = dogPedigreeCertifiedChangeService
				.getMessageByOverseasPedigreeCertified(overseasPedigreeCertified);
		return map;
	}

}