/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.*;
import com.cku.oa.dog.entity.*;
import com.cku.oa.dog.enums.DnaParentsCompareApplySourceEnum;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.service.SysOrgPrintService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.sys.util.ZtSmsUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.partner.club.service.ClubDogChipDeleteService;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.finance.service.OADeleteService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 新生犬登记Service
 *
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Slf4j
@Service
@Transactional(readOnly = true)
public class DogChipService extends CrudService<DogChipDao, DogChip> {

	public static Long DISCOUNTS_CHANGE_TIME_MILLIS = null;

	static {
		try {
			DISCOUNTS_CHANGE_TIME_MILLIS = new SimpleDateFormat("yyyy-MM-dd").parse("2018-06-01").getTime();
		} catch (ParseException e) {
			System.out.println("血统证书优惠变更格式化时间出错");
		}
	}

	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
	@Autowired
	public DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	public DogDao dogDao;
	@Autowired
	private DogTypeShowService dogTypeShowService;
	@Lazy
	@Autowired
	public RestDogService restDogService;
	@Autowired
	public OrgService orgService;
	@Autowired
	public DogService dogService;
	@Autowired
	private RemindService remindService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;
	@Autowired
	private OADeleteService oADeleteService;
	@Autowired
	private ClubDogChipDeleteService clubDogChipDeleteService;
	@Autowired
	private DogChipChangeDao dogChipChangeDao;
	@Autowired
	private SysOrgPrintService sysOrgPrintService;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private DogActivationDao dogActivationDao;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DogNewbornDao dogNewbornDao;
	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogChipMemberLockService dogChipMemberLockService;
	@Autowired
	private DogTypeService dogTypeService;

	public DogChip get(String id) {
		return super.get(id);
	}

	public static Long breedTimeMillis = null;

	static {
		try {
			breedTimeMillis = new SimpleDateFormat("yyyy-MM-dd").parse("2018-06-01").getTime();
		} catch (ParseException e) {
			System.out.println("杜高犬只6月后禁止繁殖判断格式化时间出错");
		}
	}

	public List<DogChip> findList(DogChip dogChip) {
		if (StringUtils.isBlank(dogChip.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogChip.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogChip.getSqlMap().put("dogBreedMap", " ='" + dogChip.getDogBreed() + "'");
		}
		return super.findList(dogChip);
	}

	public Page<DogChip> findPage(Page<DogChip> page, DogChip dogChip) {
		if (StringUtils.isBlank(dogChip.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogChip.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogChip.getSqlMap().put("dogBreedMap", " ='" + dogChip.getDogBreed() + "'");
		}
		return super.findPage(page, dogChip);
	}

	@Transactional(readOnly = false)
	public void save(DogChip dogChip) {
		super.save(dogChip);
	}

	@Transactional(readOnly = false)
	public void updateBusinessPrice(DogChip dogChip) {
		dao.updateBusinessPrice(dogChip);
	}

	@Transactional(readOnly = false)
	public void delete(DogChip dogChip) {
		// 已缴费的订单不允许删除
		if ("2".equals(dogChip.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已缴费，不允许删除");
		}
		// OA删除订单
		oADeleteService.deleteUnpay(dogChip.getPaymentState(), "dog_chip", dogChip.getId(), dogChip.getRunningNumber());
		// 如果是oa报名的话，没有订单，故没走上面的删除，所以需要再次删除
		super.delete(dogChip);
		// 地方俱乐部未交费订单删除
		clubDogChipDeleteService.deleteUnpayDogChipBusiness(dogChip.getBirthCode());
	}

	/**
	 * @Description：更改新生犬登记申请审核状态
	 * @author: zhuoHeng
	 * @version: 2016年8月9日 下午2:25:17
	 */
	@Transactional(readOnly = false)
	public void changeReviewStatus(DogChip dogChip) throws ZAException {

		DogChip chip = super.get(dogChip.getId());
		SysContext sysContext = new SysContext(chip.getPaymentState(), chip.getReviewState(), chip.getProcessState());
		if ("1".equals(dogChip.getReviewState())) {
			sysContext.confirmSuccess(sysContext, "新生犬登记", chip.getPaymentMemberCode(), "dog_chip", chip.getId(),
					chip.getRunningNumber(), (str) -> {

					});
		} else if ("2".equals(dogChip.getReviewState())) {
			sysContext.confirmFail(sysContext, "新生犬登记", dogChip.getReviewRemarks(), chip.getPaymentMemberCode(),
					"dog_chip", chip.getId(), chip.getRunningNumber(), (str) -> {

					});
		}
		dao.changeStatus(dogChip);
		//如果是注销，则重置出生纸数据
		if ("3".equals(dogChip.getReviewState())) {
			processDogBirthCertificateForCancel(chip.getBirthCode());
		}
		sendMsg(dogChip);
	}

	/**
	 * 删除血统证书重复办理记录
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void removeRepeatRecord(String birthCode, List<String> repeatDogIds) throws ZAException {
		if (StringUtils.isBlank(birthCode) || CollectionUtils.isEmpty(repeatDogIds)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请选择要删除的重复记录后重试！");
		}
		Dog dog = new Dog();
		dog.setBirthCertificateLevelCode(birthCode);
		List<Dog> dogList = dogService.findList(dog);
		if (CollectionUtils.isEmpty(dogList)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只记录不存在，请刷新后重试！");
		}
		List<String> dbDogIdList = dogList.stream().map(Dog::getId).collect(Collectors.toList());
		if (!dbDogIdList.containsAll(repeatDogIds)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "包含非同一出生纸的犬只记录，无法处理");
		}
		if (repeatDogIds.size() >= dbDogIdList.size()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "删除的记录数量应小于总记录数");
		}
		dogService.deleteDogByIds(repeatDogIds);
		// 检测是否有重复的鼻纹数据，有则删除重复数据
		dogNoseService.deleteRepeatByDogIds(repeatDogIds);
	}

	/**
	 * @Description：更改处理状态并生成犬只信息
	 * @author: zhuoHeng
	 * @version: 2016年8月9日 下午4:35:06
	 */
	@Transactional(readOnly = false)
	public void changeProcessStateByDogNose(DogChip dogChip) throws ZAException {
		DogChip chip = super.get(dogChip.getId());
		chip.setPaymentState("2");
		chip.setReviewState("1");
		SysContext sysContext = new SysContext(chip.getPaymentState(), chip.getReviewState(), chip.getProcessState());
		sysContext.updateData(sysContext, "新生犬登记", chip.getPaymentMemberCode(), "dog_chip", chip.getId(),
				chip.getRunningNumber(), (str) -> {
					// 保证数据为已支付、审核通过、医院已上传了犬只芯片号，才可进行处理操作
					if ("2".equals(chip.getPaymentState()) && "1".equals(chip.getReviewState())) {
						if (chip != null && "0".equals(chip.getProcessState())) {
							dogChip.setProcessState("1");
							dogChip.setProcessTime(new Date());
							dogChip.setPrintState("0");
							if (chip.getDogBirthCertificate().getDogBreed() != null
									&& !"".equals(chip.getDogBirthCertificate().getDogBreed())) {
								String pedigreeCertified = SysCodeUtil
										.getPedigreeCertifiedCode(chip.getDogBirthCertificate().getDogBreed());
								dogBirthCertificateDao.createPedigreeCertified(pedigreeCertified, chip.getBirthCode());
								// 查找芯片变更表
								DogChipChange dogChipChange = dogChipChangeDao
										.getByIdentificationFlag(chip.getDogBirthCertificate().getIdentificationFlag());
								// 查新生犬登记表
								DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
										.getByBirthCerRegCode(chip.getBirthCode());
								// 更新dogChip表的芯片表id 来限制会员中心的撤销操作
								dogChip.setDogChipChangeId(dogChipChange != null ? dogChipChange.getId() : null);
								dao.changeProcessState(dogChip);
								Dog dog = new Dog();
								dog.preInsert();
								dog.setEcertFlag(dogChip.getEcertFlag());
								dog.setBirthCertificateLevelCode(chip.getBirthCode());
								dog.setPedigreeCertifiedCode(pedigreeCertified);
								dog.setDogOwner(chip.getDogBirthCertificate().getDogOwenr());
								dog.setMemberCode(chip.getDogBirthCertificate().getMemberCode());
								// 修改犬表的主人信息
								if (StringUtils.isNotBlank(dogBirthCertificate.getTempMemberCode())) {
									dog.setDogOwner(dogBirthCertificate.getTempUserName());
									dog.setMemberCode(dogBirthCertificate.getTempMemberCode());
									dogBirthCertificateDao.updateDogOwner(chip.getBirthCode(),
											dogBirthCertificate.getTempMemberCode(),
											dogBirthCertificate.getTempUserName());
								}
								dog.setSecondDogOwner(chip.getDogBirthCertificate().getSecondDogOwner());
								dog.setSecondOwnerMemberNum(chip.getDogBirthCertificate().getSecondOwnerMemberCode());
								dog.setBreeder(chip.getDogBirthCertificate().getBreeder());
								dog.setSecondBreeder(chip.getDogBirthCertificate().getSecondBreeder());
								dog.setNameCn("");
								dog.setNameEn(chip.getDogBirthCertificate().getDogEnName());
								dog.setGender(chip.getDogBirthCertificate().getDogGender());
								dog.setBirthdate(chip.getDogBirthCertificate().getDogBirthday());
								dog.setDogBreed(chip.getDogBirthCertificate().getDogBreed());
								// 设置FCi赛事编码
								List<DogTypeShow> dogTypeShowList = dogTypeShowService
										.findListByDogBreed(dog.getDogBreed());
								if (dogTypeShowList != null && dogTypeShowList.size() == 1) {
									dog.setShowDogBreed(dogTypeShowList.get(0).getDogShowCode());
								}
								dog.setIdentificationFlag(chip.getDogBirthCertificate().getIdentificationFlag());
								dog.setColorFlag(chip.getDogBirthCertificate().getColorFlag());
								dog.setSpecialFlag("");// 特殊标记
								dog.setFdogPedigreeCertified(chip.getDogBirthCertificate().getFdogPedigreeCertified());
								dog.setMdogPedigreeCertified(chip.getDogBirthCertificate().getMdogPedigreeCertified());
								dog.setFmdogBreedCertifiedCode(
										chip.getDogBirthCertificate().getFmdogBreedCertifiedCode());
								dog.setPrintState("2");// 血统证书打印
								dog.setDnaPayState("0");
								dog.setBreedPayState("0");
								User u = UserUtils.getLoginUser();
								if (u != null) {
									dog.setOperator(u.getName() + ":" + DateUtils.formatDate(new Date(), "yyyy-MM-dd"));// 操作人
								}
								dog.setBreederMemberCode(chip.getDogBirthCertificate().getBreederMemberCode());
								dog.setDogGeneration(String.valueOf(restDogService.getDogGeneration(
										chip.getDogBirthCertificate().getFdogPedigreeCertified(),
										chip.getDogBirthCertificate().getMdogPedigreeCertified())));
								dog.setDogState("0");// 犬只状态正常
								dog.setCreateDate(new Date());
								dog.setUpdateDate(new Date());
								dog.setDnaSaveWay(dogChip.getDnaSaveWay());
								dog.setIsDnaParentsCompare(dogChip.getIsDnaParentsCompare());
								// 取出生纸的业务禁止字段
								dog.setBusinessBan(chip.getDogBirthCertificate().getBusinessBan());
								// 取出生纸的赛事禁止字段
								dog.setShowBan(chip.getDogBirthCertificate().getShowBan());
								// 增加标记 只有FCI正式认可可以申请出口
								DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
								if (dogType != null) {
									dog.setChangeBan(!"formal".equals(dogType.getBreedClass()) ? "1" : null);
								}
								// 设置犬只呼名 20180306chai
								dog.setCallName(chip.getCallName());
								dog.setCabPassport(dogBirthCertificate.getCabPassport());
								dogDao.insert(dog);
								// 根据出生证明编号查询位点分析表是否有相关记录，有则更新dogId和pedigreeCertified字段
								DogDnaArchive dogDnaArchive = dogDnaArchiveService
										.getByBirthCode(dog.getBirthCertificateLevelCode());
								if (dogDnaArchive != null) {
									dogDnaArchive.setDogId(dog.getId());
									dogDnaArchive.setPedigreeCertified(dog.getPedigreeCertifiedCode());
									dogDnaArchive.setTypeYes("2");
									dogDnaArchiveService.save(dogDnaArchive);
								}
								// 根据出生证明编号查询血样留存表是否有相关记录，有则更新pedigreeCertified字段
								DogBloodSave dogBloodSave = dogBloodSaveService
										.getByBirthCode(dog.getBirthCertificateLevelCode());
								if (dogBloodSave != null) {
									dogBloodSave.setOrgId(chip.getHospitalCode());
									dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
									dogBloodSave.setTypeYes("2");
									dogBloodSaveService.save(dogBloodSave);
								}
								if (dogChipChange != null) {
									// 根据芯片号找到新生犬登记时相关的芯片变更记录，并更新dog_id字段和出生纸号字段
									dogChipChange.setDogId(dog.getId());
									dogChipChange.setBirthCode(dog.getBirthCertificateLevelCode());
									dogChipChangeDao.update(dogChipChange);
								}
								// 判断俱乐部新生犬业务是否满足重置打印次数
								if (StringUtils.isNotBlank(dogChip.getHospitalCode())) {
									Org org = orgService.get(dogChip.getHospitalCode());
									if (org != null) {
										int countByClub = dao.countByClub(dogChip.getHospitalCode());
										if (countByClub != 0 && countByClub % 60 == 0) {// 满足60笔及60的倍数重置打印次数为三次
											sysOrgPrintService.updateRestPrint(dogChip.getHospitalCode());
										}
									}
								}

								// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
								// 等级贴纸业务
//								if ("1".equals(chip.getStickerFlag())) {
//									if (StringUtils.isNotBlank(dogChip.getIsAll()) && "1".equals(dogChip.getIsAll())) {
//										dogStickerApplyService.applyAllNestSticker(dog, chip.getPaymentMemberCode(),
//												chip.getRunningNumber(), null);
//									} else {
//										dogStickerApplyService.applySticker(dog, chip.getPaymentMemberCode(),
//												chip.getRunningNumber());
//									}
//								}

								// 每张出生纸成功转换血统证书后，赠送给“犬主”一张价值280元的“CAC赛事免费参赛卷”
								Calendar calendar = Calendar.getInstance();
								calendar.setTime(new Date());
								calendar.add(Calendar.YEAR, 1);
								sysCouponService.saveCoupon(dogBirthCertificate.getTempMemberCode(), "CAC犬展免费参展券",
										"280", calendar.getTime(), new Date(), "dogChip", pedigreeCertified,
										"参展券限CKU血统证书为：" + pedigreeCertified + "的犬只使用", 1, "3");
								// TODO 财务收入确认时点
								// saPaymentDetailTotalService.financeConfirmTime(dogChip.getId(), "dog_chip");
							} else {
								throw new ZAException(-1, "犬种类代码不正确！");
							}
						} else {
							throw new ZAException(-1, "当前处理状态不正确！");
						}
					} else {
						throw new ZAException(-1, "数据为[已缴费][审核通过][已完成芯片上传]才可进行此操作");
					}
				});
	}

	/**
	 * @Description：更改处理状态并生成犬只信息
	 * @author: zhuoHeng
	 * @version: 2016年8月9日 下午4:35:06
	 */
	@Transactional(readOnly = false)
	public void changeProcessState(DogChip dogChip) throws ZAException {
		DogChip chip = super.get(dogChip.getId());
		SysContext sysContext = new SysContext(chip.getPaymentState(), chip.getReviewState(), chip.getProcessState());
		sysContext.updateData(sysContext, "新生犬登记", chip.getPaymentMemberCode(), "dog_chip", chip.getId(),
				chip.getRunningNumber(), (str) -> {
					// 保证数据为已支付、审核通过、医院已上传了犬只芯片号，才可进行处理操作
					if ("2".equals(chip.getPaymentState()) && "1".equals(chip.getReviewState())
							&& chip.getDogBirthCertificate().getIdentificationFlag() != null
							&& !"".equals(chip.getDogBirthCertificate().getIdentificationFlag())) {
						// 血样留存为未采集不允许处理
						// if (!"1".equals(chip.getBloodSaveFlag())) {
						// throw new ZAException(-1, "该记录没有进行采血，不能进行处理");
						// }
						if (chip != null && "0".equals(chip.getProcessState())) {
							dogChip.setProcessState("1");
							dogChip.setProcessTime(new Date());
							dogChip.setPrintState("0");
							if (chip.getDogBirthCertificate().getDogBreed() != null
									&& !"".equals(chip.getDogBirthCertificate().getDogBreed())) {
								String pedigreeCertified = SysCodeUtil
										.getPedigreeCertifiedCode(chip.getDogBirthCertificate().getDogBreed());
								dogBirthCertificateDao.createPedigreeCertified(pedigreeCertified, chip.getBirthCode());
								// 查找芯片变更表
								DogChipChange dogChipChange = dogChipChangeDao
										.getByIdentificationFlag(chip.getDogBirthCertificate().getIdentificationFlag());
								// 查新生犬登记表
								DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
										.getByBirthCerRegCode(chip.getBirthCode());
								// 更新dogChip表的芯片表id 来限制会员中心的撤销操作
								dogChip.setDogChipChangeId(dogChipChange.getId());
								dao.changeProcessState(dogChip);
								Dog dog = new Dog();
								dog.preInsert();
								dog.setEcertFlag(dogChip.getEcertFlag());
								dog.setBirthCertificateLevelCode(chip.getBirthCode());
								dog.setPedigreeCertifiedCode(pedigreeCertified);
								dog.setDogOwner(chip.getDogBirthCertificate().getDogOwenr());
								dog.setMemberCode(chip.getDogBirthCertificate().getMemberCode());
								// 修改犬表的主人信息
								if (StringUtils.isNotBlank(dogBirthCertificate.getTempMemberCode())) {
									dog.setDogOwner(dogBirthCertificate.getTempUserName());
									dog.setMemberCode(dogBirthCertificate.getTempMemberCode());
									dogBirthCertificateDao.updateDogOwner(chip.getBirthCode(),
											dogBirthCertificate.getTempMemberCode(),
											dogBirthCertificate.getTempUserName());
								}
								dog.setSecondDogOwner(chip.getDogBirthCertificate().getSecondDogOwner());
								dog.setSecondOwnerMemberNum(chip.getDogBirthCertificate().getSecondOwnerMemberCode());
								dog.setBreeder(chip.getDogBirthCertificate().getBreeder());
								dog.setSecondBreeder(chip.getDogBirthCertificate().getSecondBreeder());
								dog.setNameCn("");
								dog.setNameEn(chip.getDogBirthCertificate().getDogEnName());
								dog.setGender(chip.getDogBirthCertificate().getDogGender());
								dog.setBirthdate(chip.getDogBirthCertificate().getDogBirthday());
								dog.setDogBreed(chip.getDogBirthCertificate().getDogBreed());
								// 设置FCi赛事编码
								List<DogTypeShow> dogTypeShowList = dogTypeShowService
										.findListByDogBreed(dog.getDogBreed());
								if (dogTypeShowList != null && dogTypeShowList.size() == 1) {
									dog.setShowDogBreed(dogTypeShowList.get(0).getDogShowCode());
								}
								dog.setIdentificationFlag(chip.getDogBirthCertificate().getIdentificationFlag());
								dog.setColorFlag(chip.getDogBirthCertificate().getColorFlag());
								dog.setSpecialFlag("");// 特殊标记
								dog.setFdogPedigreeCertified(chip.getDogBirthCertificate().getFdogPedigreeCertified());
								dog.setMdogPedigreeCertified(chip.getDogBirthCertificate().getMdogPedigreeCertified());
								dog.setFmdogBreedCertifiedCode(
										chip.getDogBirthCertificate().getFmdogBreedCertifiedCode());
								dog.setPrintState("2");// 血统证书打印
								dog.setDnaPayState("0");
								dog.setBreedPayState("0");
								User u = UserUtils.getLoginUser();
								if (u != null) {
									dog.setOperator(u.getName() + ":" + DateUtils.formatDate(new Date(), "yyyy-MM-dd"));// 操作人
								}
								dog.setBreederMemberCode(chip.getDogBirthCertificate().getBreederMemberCode());
								dog.setDogGeneration(String.valueOf(restDogService.getDogGeneration(
										chip.getDogBirthCertificate().getFdogPedigreeCertified(),
										chip.getDogBirthCertificate().getMdogPedigreeCertified())));
								dog.setDogState("0");// 犬只状态正常
								dog.setCreateDate(new Date());
								dog.setUpdateDate(new Date());
								dog.setDnaSaveWay(dogChip.getDnaSaveWay());
								dog.setIsDnaParentsCompare(dogChip.getIsDnaParentsCompare());
								// 取出生纸的业务禁止字段
								dog.setBusinessBan(chip.getDogBirthCertificate().getBusinessBan());
								// 取出生纸的赛事禁止字段
								dog.setShowBan(chip.getDogBirthCertificate().getShowBan());
								// 设置犬只呼名 20180306chai
								dog.setCallName(chip.getCallName());
								dog.setCabPassport(dogBirthCertificate.getCabPassport());
								dog.setSecondBreeder(dogBirthCertificate.getSecondBreeder());
								// 查询犬种信息
								DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
								if (dogType != null) {
									// 增加标记 只有FCI正式认可可以申请出口
									dog.setChangeBan(!"formal".equals(dogType.getBreedClass()) ? "1" : null);
								}
								dogDao.insert(dog);
								// 根据出生证明编号查询位点分析表是否有相关记录，有则更新dogId和pedigreeCertified字段
								DogDnaArchive dogDnaArchive = dogDnaArchiveService
										.getByBirthCode(dog.getBirthCertificateLevelCode());
								if (dogDnaArchive != null) {
									dogDnaArchive.setDogId(dog.getId());
									dogDnaArchive.setPedigreeCertified(dog.getPedigreeCertifiedCode());
									dogDnaArchive.setFinishTime(new Date());
									dogDnaArchive.setTypeYes("2");
									dogDnaArchiveService.save(dogDnaArchive);
								}
								//判断是否为金质证书申请
								DogDnaParentsCompare dnaParentsCompare = dogDnaParentsCompareService.getByBirthCode(chip.getBirthCode());
								if (Objects.nonNull(dnaParentsCompare)
										&& !DnaParentsCompareApplySourceEnum.COMPARE.code().equals(dnaParentsCompare.getApplySource())) {
									List<DogDnaArchive> dnaArchiveList = dogDnaArchiveService.findListByOrderCode(dnaParentsCompare.getRunningNumber());
									//如果是金质证书申请则需要dna存档是否未审核
									if (dnaArchiveList.stream().anyMatch(d -> !"1".equals(d.getReviewState()))) {
										throw new ZAException(ZAErrorCode.ZA_ERROR, "金质证书提示：该犬只或其父母DNA存档未通过，无法生成证书号");
									}
								}
								// 根据出生证明编号查询血样留存表是否有相关记录，有则更新pedigreeCertified字段
								DogBloodSave dogBloodSave = dogBloodSaveService
										.getByBirthCode(dog.getBirthCertificateLevelCode());
								if (dogBloodSave != null) {
									dogBloodSave.setOrgId(chip.getHospitalCode());
									dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
									dogBloodSave.setFinishTime(new Date());
									dogBloodSave.setTypeYes("2");
									dogBloodSaveService.save(dogBloodSave);
								}
								// 根据芯片号找到新生犬登记时相关的芯片变更记录，并更新dog_id字段和出生纸号字段
								dogChipChange.setDogId(dog.getId());
								dogChipChange.setBirthCode(dog.getBirthCertificateLevelCode());
								dogChipChangeDao.update(dogChipChange);
								// 判断俱乐部新生犬业务是否满足重置打印次数
								if (StringUtils.isNotBlank(dogChip.getHospitalCode())) {
									Org org = orgService.get(dogChip.getHospitalCode());
									if (org != null) {
										int countByClub = dao.countByClub(dogChip.getHospitalCode());
										if (countByClub != 0 && countByClub % 60 == 0) {// 满足60笔及60的倍数重置打印次数为三次
											sysOrgPrintService.updateRestPrint(dogChip.getHospitalCode());
										}
									}
								}
								// 等级贴纸业务
								// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//								if ("1".equals(chip.getStickerFlag())) {
//									if (StringUtils.isNotBlank(dogChip.getIsAll()) && "1".equals(dogChip.getIsAll())) {
//										// 2020年7月8日后申请缴费的整窝办理犬只，等级申请时取消是否需求新护照，变更为否
//										String needNewPassport = null;
//										try {
//											if (dogChipChange.getPaymentTime().after(sdf.parse("2020-07-08"))) {
//												needNewPassport = "0";
//											}
//										} catch (ParseException e) {
//											throw new ZAException(-1, "代码内部错误！");
//										}
//										dogStickerApplyService.applyAllNestSticker(dog, chip.getPaymentMemberCode(),
//												chip.getRunningNumber(), needNewPassport);
//									} else {
//										dogStickerApplyService.applySticker(dog, chip.getPaymentMemberCode(),
//												chip.getRunningNumber());
//									}
//								}
								// 每张出生纸成功转换血统证书后，赠送给“犬主”一张价值280元的“CAC赛事免费参赛卷”
								Calendar calendar = Calendar.getInstance();
								calendar.setTime(new Date());
								calendar.add(Calendar.YEAR, 1);
								sysCouponService.saveCoupon(dogBirthCertificate.getTempMemberCode(), "CAC犬展免费参展券",
										"280", calendar.getTime(), new Date(), "dogChip", pedigreeCertified,
										"参展券限CKU血统证书为：" + pedigreeCertified + "的犬只使用", 1, "3");
								// TODO 财务收入确认时点
								// saPaymentDetailTotalService.financeConfirmTime(dogChip.getId(), "dog_chip");
							} else {
								throw new ZAException(-1, "犬种类代码不正确！");
							}
						} else {
							throw new ZAException(-1, "当前处理状态不正确！");
						}
					} else {
						throw new ZAException(-1, "数据为[已缴费][审核通过][已完成芯片上传]才可进行此操作");
					}
				});
	}

	/**
	 * @description: 获取已付款待审核的新生犬芯片埋置申请记录数
	 * @author: laiguanglong
	 * @date: 2016年8月29日 下午4:52:58
	 */
	public int getAuditCount() {
		DogChip dogChip = new DogChip();
		// 已付款
		dogChip.setPaymentState("2");
		// 审核通过
		dogChip.setReviewState("1");
		// 鼻纹已采集
		dogChip.setNoseState("1");
		// 未撤销
		dogChip.setIsCanceled("0");
		// 芯片不为空
		dogChip.setIdentificationFlagState("1");
		// 未处理
		dogChip.setProcessState("0");
		return dao.listCount(dogChip);
	}

	/**
	 * @Description：给用户发送消息，根据审核状态和缴费状态来判断发送内容
	 * @author: zhuoHeng
	 * @version: 2016年9月1日 下午3:32:44
	 */
	public void sendMsg(DogChip dogChip) {
		String reviewState = dogChip.getReviewState();
		if ("0".equals(reviewState) || "1".equals(reviewState) || "2".equals(reviewState)) {
			String content = "";
			// 未审核
			if ("0".equals(reviewState)) {
				// 已提交
				if ("9".equals(dogChip.getPaymentState())) {
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy年MM月dd日HH时mm分");
					String dateString = formatter.format(new Date());
					content = "您于" + dateString + "提交了出生证明编号为“" + dogChip.getBirthCode()
							+ "”新生犬芯片埋植申请，请您务必于当日24时前完成缴费，过期订单失效哦。";
				}
			} else if ("1".equals(reviewState)) {
				content = "您提交的出生证明编号为“" + dogChip.getBirthCode() + "”的新生犬登记审核通过。";
			} else if ("2".equals(reviewState)) {
				content = "您提交的出生证明编号为“" + dogChip.getBirthCode() + "”的新生犬登记审核未通过，请进入会员中心查看未通过原因，修改后重新提交。";
			}
			remindService.addRemind(content, dogChip.getPaymentMemberCode());
		}
	}

	/**
	 * @description: 根据出生证明编号查询
	 * @author: laiguanglong
	 * @date: 2016年9月2日 下午5:22:03
	 */
	public DogChip getByBirthCode(String birthCode) {
		return dao.getByBirthCode(birthCode);
	}

	/**
	 * 根据 配种编查询血统证书取一条，判断是否整窝办理
	 *
	 * @param fmdogBreedCertifiedCode
	 * @return
	 */
	public DogChip getByFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		return dao.getByFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
	}

	/**
	 * 根据 配种编查询血统证书，判断是否整窝办理
	 *
	 * @param fmdogBreedCertifiedCode
	 * @return
	 */
	public List<DogChip> getByFmdogBreedCertifiedCodes(String fmdogBreedCertifiedCode) {
		return dao.getByFmdogBreedCertifiedCodes(fmdogBreedCertifiedCode);
	}

	/**
	 * @description: 新生犬登记业务校验
	 * @author: laiguanglong
	 * @date: 2016年8月17日 下午6:29:59
	 */
	public void validateBusiness(DogChip po, DogBirthCertificate dogBirthCertificate) {
		// 新生犬登记业务检验出生纸
		checkDogBirthCertificate(dogBirthCertificate);
		// 该出生纸配种证明标记“近亲繁殖取DNA”不为空时,DNA留存方式必须为位点分析
		DogNewborn dogNewborn = dogNewbornService
				.getBybreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
		if ("1".equals(dogNewborn.getKinGetDna()) && !"1".equals(po.getDnaSaveWay())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该出生纸配种证明标记“近亲繁殖取DNA”为近亲繁殖，DNA留存方式必须为位点分析");
		}
		// 由冷冻精子进行配种的需要位点分析且双亲比对
		if (StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
			if (!"1".equals(po.getDnaSaveWay())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只由冷冻精子进行配种而生，必须选位点分析");
			}
			if (!"1".equals(po.getIsDnaParentsCompare())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只由冷冻精子进行配种而生，必须选双亲比对");
			}
		}
		// 一岁到两岁之前的犬只申请时,DNA留存方式默认为位点分析（不能修改）
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(dogBirthCertificate.getDogBirthday());
		calendar.add(Calendar.YEAR, 1);
		calendar.add(Calendar.DATE, 1);
		if (System.currentTimeMillis() > calendar.getTimeInMillis() && !"1".equals(po.getDnaSaveWay())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄已超过1岁，DNA留存方式必须为位点分析");
		}
		// DNA位点分析的情况下才能选择DNA双亲比对
		if (!"1".equals(po.getDnaSaveWay()) && "1".equals(po.getIsDnaParentsCompare())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有选择DNA位点分析的情况下才能选择DNA双亲比对");
		}

		// 校验会员是否为犬只芯片绑定会员
		dogChipMemberLockService.checkDogLocked(dogBirthCertificate.getTempMemberCode(),
				dogBirthCertificate.getIdentificationFlag());

		// 校验重复订单
		DogChip example = new DogChip();
		example.setBirthCode(po.getBirthCode());
		// 已撤销的不校验
		example.setIsCanceled("0");
		example.setReviewStateExclud("3");
		List<DogChip> findList = super.findList(example);
		if (findList.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬登记卡已申请血统证书业务，请勿重复申请业务");
		}
		if (dogBloodSaveService.getByBirthCode(po.getBirthCode()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬登记卡已有血样留存业务记录");
		}
		if (dogDnaArchiveService.getByBirthCode(po.getBirthCode()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬登记卡已有DNA位点分析业务记录");
		}
		if (dogDnaParentsCompareService.getByBirthCode(po.getBirthCode()) != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬登记卡已有DNA双亲比对业务记录");
		}
	}

	/**
	 * @description: 新生犬登记业务检验出生纸
	 * @author: laiguanglong
	 * @date: 2017/6/1 15:49
	 */
	public void checkDogBirthCertificate(DogBirthCertificate dogBirthCertificate) {
		String result = checkDogBirthCertificateString(dogBirthCertificate);
		if (StringUtils.isNotBlank(result)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, result);
		}
	}

	public String checkDogBirthCertificateString(DogBirthCertificate dogBirthCertificate) {
		// 出生证明必须通过审核
		if (!"1".equals(dogBirthCertificate.getReviewState())) {
			return "该新生犬登记卡未通过审核";
		}
		// 申请日期与出生日期时间差超过二年，不能提交
		Date dogBirthday = dogBirthCertificate.getDogBirthday();
		Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.YEAR, -2); // 年份减2
		ca.add(Calendar.DATE, -1); // 日期加1
		Date lastMonth = ca.getTime();
		if (dogBirthday.getTime() < lastMonth.getTime()) {
			return "犬只年龄已超过2岁，请联系CKU繁殖部办理此业务！！！";
		}
		// 出生证明必须已经打印,但是现在没有状态记录出生证明是否打印
		if ("0".equals(dogBirthCertificate.getEcertFlag()) && !"9".equals(dogBirthCertificate.getPrintType())) {
			// return "该犬只新生犬登记卡未打印，不允许申请血统证书";
		}
		// 藏獒不可办理‘新生犬登记业务’
		if ("230".equals(dogBirthCertificate.getDogBreed())) {
			return "藏獒不可办理血统证书业务";
		}
		// 校验是否办理犬只激活
		if (dogBirthCertificate.getCreateDate().getTime() > DogBirthCertificateService.DOG_ACTIVATION_MILLIS
				&& !"1".equals(dogBirthCertificate.getActivitionState())) {
			// return "该犬只登记卡尚未激活,请前往登记卡列表传图激活.";
		}

		if (StringUtils.isEmpty(dogBirthCertificate.getIdentificationFlag())) {
			return "该犬只芯片号不能为空";
		}

		return null;
	}

	/**
	 * @Description： 订单录入保存业务信息
	 *
	 * @author: zhuoHeng
	 * @version: 2016年10月24日 下午8:28:10
	 */
	@Transactional(readOnly = false)
	public void orderSave(DogChip dogChip, String hidDogOwenrName) {
		// 校验重复订单
		DogChip example = new DogChip();
		example.setBirthCode(dogChip.getBirthCode());
		// 已撤销的不校验
		example.setIsCanceled("0");
		List<DogChip> dogChipList = super.findList(example);
		if (dogChipList.stream().filter(dog -> !dog.getReviewState().equals("3")).count() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬登记订单已提交，请勿重复提交");
		}
		// start-20810202-chaixueteng 新犬主必须有效
		Member member = memberService.getByMemberCode(dogChip.getDogBirthCertificate().getMemberCode());
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主会员号有误");
		}
		if (!MemberUtil.isActiveMember(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主为无效会员，请新犬主缴费后再进行新生犬登记");
		}
		// end

		// 校验会员是否为犬只芯片绑定会员
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(dogChip.getBirthCode());
		dogChipMemberLockService.checkDogLocked(member.getMemberCode(), dogBirthCertificate.getIdentificationFlag());

		// 订单录入，默认为已采血
		dogChip.setBloodSaveFlag("1");
		// 订单录入，默认为已采血
		dogChip.setBloodSaveFlag("1");
		dogChip.setDnaSaveWay("");
		dogChip.setIsDnaParentsCompare("");
		dogChip.setReviewState("0");
		dogChip.setPaymentState("2");
		PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(dogChip.getRunningNumber());
		// start 20180205 校验申请人有效
		Member member2 = memberService.getByMemberCode(paymentOrder.getMemberCode());
		if (!MemberUtil.isActiveMember(member2)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请人为无效会员");
		}
		// end
		// 校验呼名
		if (StringUtils.isNotBlank(dogChip.getCallName())) {
			demandSensitiveWordService.validCallName(dogChip.getCallName());
		}
		dogChip.setPaymentTime(paymentOrder.getCreateDate());
		dogChip.setProcessState("0");
		dogChip.setIsNewRecord(false);
		dogChip.preInsert();
		dao.insert(dogChip);

		Org org = orgService.get(dogChip.getHospitalCode());
		// 更新出生纸的临时会员信息及addUser字段
		dogBirthCertificateDao.updateTempDogOwnerAndAddUser(dogChip.getBirthCode(),
				dogChip.getDogBirthCertificate().getMemberCode(), hidDogOwenrName,
				org == null ? "" : org.getUser().getLoginName());
	}

	/**
	 * @Description：新生犬的登记撤销操作
	 * @author: zhuoHeng
	 * @version: 2016年10月25日 上午12:01:29
	 */
	@Transactional(readOnly = false)
	public void canceled(DogChip po) {
		if (!dogChipCanCanceled(po)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该记录不符合撤销条件，不允许撤销");
		}
		if (StringUtils.isNotBlank(po.getIsAll()) && "1".equals(po.getIsAll())) {
			// 整窝撤销
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(po.getBirthCode());
			// 删除整窝出生纸
			dogBirthCertificateDao.updateALLByFmdogBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode(),
					"血统证书整窝办理撤销");
			// 撤销血统证书
			List<DogChip> dogChipList = dogChipDao
					.findByFmdogBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
			for (DogChip data : dogChipList) {
				data.setIsCanceled("1");
				data.setDelTime(new Date());
				dao.canceled(data);
				// 同时撤销血样留存、位点分析、双亲比对
				DogBloodSave dogBloodSave = dogBloodSaveService.getByBirthCode(data.getBirthCode());
				if (dogBloodSave != null) {
					dogBloodSave.setIsCanceled("1");
					dogBloodSaveService.save(dogBloodSave);
				}
				DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByBirthCode(data.getBirthCode());
				if (dogDnaArchive != null) {
					dogDnaArchive.setIsCanceled("1");
					dogDnaArchiveService.save(dogDnaArchive);
				}
				DogDnaParentsCompare dogDnaParentsCompare = dogDnaParentsCompareService
						.getByBirthCode(data.getBirthCode());
				if (dogDnaParentsCompare != null) {
					dogDnaParentsCompare.setIsCanceled("1");
					dogDnaParentsCompareService.save(dogDnaParentsCompare);
				}
				// 修改配种证明
				DogNewborn dogNewborn = dogNewbornDao
						.getByBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
				dogNewborn.setBirthday(null);
				dogNewborn.setDogRegisterNum("");// CKU登记数
				dogNewborn.setPuppyBirthNum("");// 出生数（几公几母）
				dogNewborn.setPuppyRegisterNum("");// 登记数（几公几母）
				if (UserUtils.getUser().getId() != null) {
					dogNewborn.preUpdate();
				} else {
					// 定时任务无法获取当前登录用户，需要手动设置
					User updateBy = new User();
					updateBy.setId("1");
					updateBy.setUpdateDate(new Date());
					dogNewborn.setUpdateBy(updateBy);
				}
				dogNewbornDao.update(dogNewborn);
				// 清除激活记录
				DogActivation dogActivation = dogActivationDao.getByBirthCode(data.getBirthCode());
				if (dogActivation != null) {
					dogActivationDao.delete(dogActivation);
				}
			}

		} else {
			processDogBirthCertificateForCancel(po.getBirthCode());
			// 更新新生犬登记业务表撤销标记位
			po.setIsCanceled("1");// 撤销标识
			po.setDelTime(new Date());
			dao.canceled(po);
			// 同时撤销血样留存、位点分析、双亲比对
			DogBloodSave dogBloodSave = dogBloodSaveService.getByBirthCode(po.getBirthCode());
			if (dogBloodSave != null) {
				dogBloodSave.setIsCanceled("1");
				dogBloodSaveService.save(dogBloodSave);
			}
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByBirthCode(po.getBirthCode());
			if (dogDnaArchive != null) {
				dogDnaArchive.setIsCanceled("1");
				dogDnaArchiveService.save(dogDnaArchive);
			}
			DogDnaParentsCompare dogDnaParentsCompare = dogDnaParentsCompareService.getByBirthCode(po.getBirthCode());
			if (dogDnaParentsCompare != null) {
				dogDnaParentsCompare.setIsCanceled("1");
				dogDnaParentsCompareService.save(dogDnaParentsCompare);
			}
		}
	}

	/**
	 * 处理注销时出生纸数据
	 *
	 * @author yuanshuai
	 * @since 2024/4/23 15:30
	 */
	@Transactional(readOnly = false)
	private void processDogBirthCertificateForCancel(String birthCode) {
		// 撤销后还原出生纸
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(birthCode);
		dogBirthCertificate.setAddUser(null);
		dogBirthCertificate.setPedigreeCertified(null);
		dogBirthCertificate.setDogOwenr(dogBirthCertificate.getBreeder());
		dogBirthCertificate.setMemberCode(dogBirthCertificate.getBreederMemberCode());
		dogBirthCertificate.setTempUserName(dogBirthCertificate.getBreeder());
		dogBirthCertificate.setTempMemberCode(dogBirthCertificate.getBreederMemberCode());
		dogBirthCertificate.preUpdate();
		dogBirthCertificateDao.update(dogBirthCertificate);
		//清空证书号
		dogBirthCertificateDao.createPedigreeCertified(null, birthCode);
	}

	/**
	 * @description: 获取业务状态
	 *               1、业务状态显示按时间划分，登记卡和血统证书列表页的业务状态显示做区分，2017年6月1日0：00分以后的数据显示业务状态；
	 *               2017年5月31日23:59:59秒前的数据不显示业务状态
	 * @author: laiguanglong
	 * @date: 2017/5/17 19:11
	 */
	public String getBusinessState(DogChip po) {
		if (po.getCreateDate().getTime() < DogBirthCertificateService.newBusinessTimeMillis) {
			return "";
		}
		if ("1".equals(po.getIsCanceled())) {
			return "已撤销";
		} else if ("3".equals(po.getReviewState())) {
			return "已注销";
		} else if ("2".equals(po.getReviewState())) {
			return "未通过";
		} else if ("1".equals(po.getReviewState())) {
			if ("0".equals(po.getProcessState())) {
				return "已通过";
			} else if ("1".equals(po.getProcessState())) {
				Dog dog = dogDao.getByBirthCertificateLevelCode(po.getBirthCode());
				if (dog != null)
					if ("0".equals(po.getEcertFlag())) {
						if ("2".equals(dog.getPrintState())) {
							return "待打印";
						} else if ("02".equals(dog.getPrintState())) {
							if ("1".equals(po.getPrintSource())) {
								return "已领取";
							} else {
								if (po.getSendDate() != null
										&& System.currentTimeMillis() > po.getSendDate().getTime()) {
									return "已寄出";
								} else {
									return "待邮寄";
								}
							}
						}
					} else if ("1".equals(po.getEcertFlag())) {
						return "已生成";
					}
			}
		} else if ("0".equals(po.getReviewState())) {
			if ("1".equals(po.getPaymentState())) {
				return "待支付";
			} else if ("2".equals(po.getPaymentState())) {
				return "待审核";
			}
		}
		return "";
	}

	/**
	 * 合作机构新生犬埋置缴费后处理
	 *
	 * @param businessIds
	 */
	public void afterPay(String businessIds) {
		DogChip dogChip = dao.get(businessIds);
		if (StringUtils.isNotBlank(dogChip.getOperator())) {
			changeProcessState(dogChip);
		}
	}

	/**
	 * @description: 判断是否能撤销，返回true表示可以撤销
	 * @author: laiguanglong
	 * @date: 2017/6/6 16:56
	 */
	public boolean dogChipCanCanceled(DogChip po) {
		boolean flag = false;
		if (!"1".equals(po.getIsCanceled())) {
			if ("1".equals(po.getReviewState())) {// 血统证书在已通过，且合作机构未办理的状态下可以撤销
				// 血样留存为已采集不允许撤销
				if ("1".equals(po.getBloodSaveFlag())) {
					return false;
				}
				if (StringUtils.isNotBlank(po.getIsAll()) && "1".equals(po.getIsAll())) {
					DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
							.getByBirthCerRegCode(po.getBirthCode());
					if (dogBirthCertificate != null) {
						List<DogChip> list = dogChipDao
								.findByFmdogBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
						if (!Collections3.isEmpty(list)) {
							for (DogChip data : list) {
								if ("1".equals(data.getProcessState())) {
									return false;
								}
							}
						}
					}
				}
				if (po.getCreateDate().getTime() >= DogBirthCertificateService.newBusinessTimeMillis) {
					// 新出生纸
					if (StringUtils.isBlank(po.getDogChipChangeId())) {
						flag = true;
					}
				} else {
					// 旧出生纸
					if (StringUtils.isBlank(po.getDogBirthCertificate().getIdentificationFlag())) {
						flag = true;
					}
				}
			}
		}
		return flag;
	}

	public boolean dogChipCanRefund(DogChip po) {
		boolean flag = false;
		if (!"1".equals(po.getIsCanceled())) {
			if ("1".equals(po.getReviewState())) {// 血统证书在已通过，且合作机构未办理的状态下可以撤销
				// 血样留存为已采集不允许撤销
				if ("1".equals(po.getBloodSaveFlag())) {
					return false;
				}
				if ("1".equals(po.getProcessState())) {
					return false;
				}
				if (StringUtils.isNotBlank(po.getIsAll()) && "1".equals(po.getIsAll())) {
					DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
							.getByBirthCerRegCode(po.getBirthCode());
					if (dogBirthCertificate != null) {
						List<DogChip> list = dogChipDao
								.findByFmdogBreedCertifiedCode(dogBirthCertificate.getFmdogBreedCertifiedCode());
						if (!Collections3.isEmpty(list)) {
							for (DogChip data : list) {
								if ("1".equals(data.getProcessState())) {
									return false;
								}
							}
						}
					}
				}
				if (po.getCreateDate().getTime() >= DogBirthCertificateService.newBusinessTimeMillis) {
					// 新出生纸
					if (StringUtils.isBlank(po.getDogChipChangeId())) {
						flag = true;
					}
				} else {
					// 旧出生纸
					if (StringUtils.isBlank(po.getDogBirthCertificate().getIdentificationFlag())) {
						flag = true;
					}
				}
			} else if ("0".equals(po.getReviewState())) {
				return true;
			}
		}
		return flag;
	}

	/**
	 * @description: 标记为已采血
	 * @author: laiguanglong
	 * @date: 2017/12/7 13:59
	 */
	@Transactional(readOnly = false, rollbackFor = RuntimeException.class)
	public void setBloodSaveFlag(String birthCode) {
		DogChip po = dao.getByBirthCode(birthCode);
		if (po != null) {
			po.setBloodSaveFlag("1");
			save(po);
		}
	}

	@Value("${DogBirthCertificateTransferLaunchDate}")
	private String DogBirthCertificateTransferLaunchDate;

	public void sendSmsForBreeder(String id) {
		DogChip dogChip = this.get(id);
		if (dogChip == null) {
			return;
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(dogChip.getBirthCode());
		if (!dogBirthCertificate.getTempMemberCode().equals(dogBirthCertificate.getBreederMemberCode())) {
			String content = "您的登记卡编号为" + dogChip.getBirthCode() + "的犬只，于" + LocalDate.now() + "日"
					+ LocalDateTime.now().getHour() + "时" + LocalDateTime.now().getMinute() + "分办理新生犬证书业务，犬主由"
					+ dogBirthCertificate.getBreeder() + "变更为" + dogBirthCertificate.getTempUserName()
					+ "，如对该业务办理有任何疑问，请致电协会客服400-660-7000";
			log.info(content);
			Member member = memberService.getByMemberCode(dogBirthCertificate.getBreederMemberCode());
			ZtSmsUtil.sendNote(content, member.getMobile());
		}
	}

	@Transactional(readOnly = false)
	public void createBirthCode(String id) {
		DogChip dogChip = this.get(id);
		if (dogChip == null) {
			return;
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(dogChip.getBirthCode());
		// 未支付不生成血统证书号
		if (dogChip.getPaymentState() == null || !"2".equals(dogChip.getPaymentState())) {
			return;
		}
		// 审核不通过不生成 撤销不生成
		if (!"1".equals(dogChip.getReviewState()) || "1".equals(dogChip.getIsCanceled())) {
			return;
		}
		// 血统证书已存在
		if (dogBirthCertificate != null && !StringUtils.isEmpty(dogBirthCertificate.getPedigreeCertified())) {
			return;
		}
		// 芯片号为空
		if (StringUtils.isEmpty(dogBirthCertificate.getIdentificationFlag())) {
			return;
		}
		// 金质证书不生成证书号
		DogDnaParentsCompare dnaParentsCompare = dogDnaParentsCompareService
				.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (Objects.nonNull(dnaParentsCompare)
				&& !DnaParentsCompareApplySourceEnum.COMPARE.code().equals(dnaParentsCompare.getApplySource())) {
			return;
		}

		String[] temps = DogBirthCertificateTransferLaunchDate.split("-");
		Integer y = Integer.valueOf(temps[0]);
		Integer m = Integer.valueOf(temps[1]);
		Integer d = Integer.valueOf(temps[2]);
		Date TRANSFER_LAUNCH_DATE = new Date(y - 1900, m - 1, d + 1, 0, 0);
		// 老数据不做处理
		if (TRANSFER_LAUNCH_DATE.after(dogChip.getPaymentTime())) {
			return;
		}

		if ("1".equals(dogChip.getHaddleWay()) && StringUtils.isBlank(dogChip.getHospitalCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "办理方式为合作机构办理时，合作机构不能为空");
		}
		// 余额支付能拿到org 支付宝微信拿不到org
		// 改为从dogChip.getCreateBy()判断是谁申请的血统证书；预约到合作机构办理的个人申请不能直接生成证书号，合作机构自行申请的可以直接生成证书号
		boolean isOrg = false;
		if (dogChip.getCreateBy() != null && StringUtils.isNotBlank(dogChip.getCreateBy().getId())) {
			User createBy = UserUtils.get(dogChip.getCreateBy().getId());
			if (createBy != null && "3".equals(createBy.getUserType())) {
				isOrg = true;
			}
		}

		DogNose dogNose = new DogNose();
		dogNose.setDelFlag("0");
		dogNose.setDogBirthCertificateId(dogBirthCertificate.getId());
		List<DogNose> noseList = dogNoseService.findList(dogNose);
		if ((isOrg || StringUtils.isBlank(dogChip.getHospitalCode())) && !CollectionUtils.isEmpty(noseList)) {
			this.changeProcessStateByDogNose(dogChip);
		}
	}

	@Transactional(readOnly = false)
	public Map<String, String> saveOrg(DogChip dogChip, Map<String, String> map) {
		if (dogChip.getHaddleWay().equals("1")) {
			// 变更为合作机构办理
			Org org = orgService.get(dogChip.getHospitalCode());
			dogChip.setHospitalName(org.getName());
			String loginName = memberService.getLoginNameByUserId(org.getUserId());
			dogBirthCertificateDao.updateAddUser(dogChip.getBirthCode(), loginName);
			// 选择血样留存/位点分析的，更新机构同时更新血样留存表和DNA存档表的合作机构，如果已有血样或DNA完成的，对完成的数据禁止跟新，仅对未完成的数据更换未新机构
			if ("1".equals(dogChip.getHaddleWay()) && !"2".equals(dogChip.getDnaSaveWay())) {
				dogBloodSaveService.updateOrg(dogChip.getBirthCode(), org.getId());
				dogDnaArchiveService.updateOrg(dogChip.getBirthCode(), org.getId());
			}

		} else {
			// 如果dna存档为自检
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByBirthCode(dogChip.getBirthCode());
			if ((Objects.isNull(dogDnaArchive) || 1 != dogDnaArchive.getApplyChannel())
					&& "1".equals(dogChip.getOldHaddleWay()) && !"2".equals(dogChip.getDnaSaveWay())) {
				map.put("rc", "1");
				map.put("msg", "已选择血样留存/位点分析,不能更换自主办理");
				return map;
			}
			// 变更为自主办理
			dogChip.setHospitalCode("");
			dogChip.setHospitalName("");
			dogBirthCertificateDao.updateAddUser(dogChip.getBirthCode(), "");
		}
		dao.saveOrg(dogChip);
		return map;
	}

}