package com.cku.oa.dog.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * Created by laiguanglong on 2017/1/10.
 */
@Service
@Transactional(readOnly = true)
public class BusinessBanService {

    /**
     * @description: 根据犬种号和犬毛色返回业务禁止字段的值
     * @author: laiguanglong
     * @date: 2017/1/9 18:26
     */
    public String getBusinessBan(String dogBreed,String colorFlag, Date birthday){
        //出生日期为空默认禁止
        if (birthday == null){
            return "1";
        }
        String businessBan = "0";
        //白色柴犬时自动更新繁育资格字段为禁止繁殖
        if ("257".equals(dogBreed) && "WH".equals(colorFlag)) {
            businessBan = "1";
        }
        //杜高犬时更新繁育字段为禁止繁殖,此规则于2020-4-23由赛事部提出修改
//        if ("292".equals(dogBreed) && birthday.getTime() >= DogChipService.breedTimeMillis) {
//            businessBan = "1";
//        }
        return businessBan;
    }
    /**
     * @description: 根据犬种号和犬毛色返回赛事禁止字段的值
     * @author: zhangxiang
     * @date: 2019/1/2 09:26
     */
    public String getShowBan(String dogBreed,String colorFlag, Date birthday){
        //出生日期为空默认禁止
        if (birthday == null){
            return "1";
        }
        String showBan = "0";
        //白色柴犬时自动更新赛事资格字段为禁止赛事
        if("257".equals(dogBreed)&&"WH".equals(colorFlag)){
        	showBan = "1";
        }
        return showBan;
    }
    /**
     * @description: 业务禁止校验
     * @author: laiguanglong
     * @date: 2017/1/10 16:21
     */
    public void validateBusinessBan(Dog dog,String errorMsg){
        if("1".equals(dog.getBusinessBan())){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,errorMsg+"，无法办理该业务");
        }
    }
    /**
     * @description: 赛事禁止校验
     * @author: laiguanglong
     * @date: 2018/12/28 10:21
     */
    public void validateShowBan(Dog dog,String errorMsg){
        if("1".equals(dog.getShowBan())){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,errorMsg+"，无法办理该业务");
        }
    }
}
