package com.cku.oa.dog.enums;

import com.cku.oa.sys.entity.user.IEnum;

/**
 * 亲子关系
 */
public enum ParenthoodTypeEnum implements IEnum<Integer> {

	/**
	 * 亲子关系 1:未鉴定,2:父亲已鉴定,3:母亲已鉴定,4:已鉴定,5:鉴定失败
	 */

	UNCONFIRMED(1, "未鉴定"),

	MALE_CONFIRMED(2, "父亲已鉴定"),

	FEMALE_CONFIRMED(3, "母亲已鉴定"),

	BOTH_CONFIRMED(4, "已鉴定"),
    FAILED(5, "鉴定失败");

    private Integer code;

    private String message;

    ParenthoodTypeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public Integer code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.message;
    }

}