/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事犬种Entity
 * @author yuanshuai
 * @version 2018-03-27
 */
public class DogTypeShow extends DataEntity<DogTypeShow> {
	
	private static final long serialVersionUID = 1L;
	private String dogBreedCode;		// 犬种代码
	private String dogShowCode;		// 赛事犬种代码
	private String showCnName;		// 赛事犬种中文名称
	private String showEnName;		// 赛事犬种英文名称
	private String typeGroup;		// 组
	
	public DogTypeShow() {
		super();
	}

	public DogTypeShow(String id){
		super(id);
	}

	@Length(min=0, max=64, message="犬种代码长度必须介于 0 和 64 之间")
	public String getDogBreedCode() {
		return dogBreedCode;
	}

	public void setDogBreedCode(String dogBreedCode) {
		this.dogBreedCode = dogBreedCode;
	}
	
	@Length(min=1, max=64, message="赛事犬种代码长度必须介于 1 和 64 之间")
	public String getDogShowCode() {
		return dogShowCode;
	}

	public void setDogShowCode(String dogShowCode) {
		this.dogShowCode = dogShowCode;
	}
	
	@Length(min=1, max=255, message="赛事犬种中文名称长度必须介于 1 和 255 之间")
	public String getShowCnName() {
		return showCnName;
	}

	public void setShowCnName(String showCnName) {
		this.showCnName = showCnName;
	}
	
	@Length(min=1, max=255, message="赛事犬种英文名称长度必须介于 1 和 255 之间")
	public String getShowEnName() {
		return showEnName;
	}

	public void setShowEnName(String showEnName) {
		this.showEnName = showEnName;
	}
	
	@Length(min=0, max=50, message="组长度必须介于 0 和 50 之间")
	public String getTypeGroup() {
		return typeGroup;
	}

	public void setTypeGroup(String typeGroup) {
		this.typeGroup = typeGroup;
	}
	
}