/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;
import java.util.Set;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.dog.entity.DogDnaArchive;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 犬只DNA存档DAO接口
 * 
 * @author lgl
 * @version 2016-08-08
 */
@MyBatisDao
public interface DogDnaArchiveDao extends CrudDao<DogDnaArchive> {
	int listCount(DogDnaArchive dogDnaArchive);

	// 更改打印状态
	int updatePrintFlay(@Param("id") String id, @Param("printState") String printState);

	DogDnaArchive getByDogId(@Param("dogId") String dogId);

	DogDnaArchive getByBirthCode(@Param("birthCode") String birthCode);

	DogDnaArchive getByOverseasPedigreeCertified(@Param("overseasPedigreeCertified") String overseasPedigreeCertified);

	DogDnaArchive getByBirthCodeAndNullRunningNumber(@Param("birthCode") String birthCode);

	// 根据犬只id 查找已缴费记录
	DogDnaArchive getDnaMsg(@Param("dogId") String dogId);

	/**
	 * @description: 根据id进行物理删除
	 * @author: laiguanglong
	 * @date: 2016/12/20 17:44
	 */
	int deleteYes(DogDnaArchive dogDnaArchive);

	/**
	 * 根据国外证书号查询dna存档记录
	 * 
	 * @param overseasPedigreeCertified
	 * @author chaixueteng
	 * @date 2017-05-18
	 */
	DogDnaArchive getByUnPayPedigreeCertified(@Param("overseasPedigreeCertified") String overseasPedigreeCertified);

	// 根据血统证书号/芯片号查询留存记录
	DogDnaArchive getByPediCodeOrChipCode(@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode);

	// 根据国外证书号/出生纸编号/血统证书号查询存档记录
	DogDnaArchive getByOverseasPedigreeCertifiedOrBirthCode(@Param("keyword") String keyword);

	DogDnaArchive getByParams(@Param("vo") DogDnaArchive s, @Param("isCheckUnpaid") Boolean isCheckUnpaid);

	List<DogDnaArchive> getBirthCodeAndPed(DogDnaArchive dogDnaArchive);

	DogDnaArchive getByPedigreeCertifiedCode(@Param("pedigreeCertifiedCode") String pedigreeCertifiedCode);

	public int updateOrg(@Param("birthCode") String birthCode, @Param("orgId") String orgId);

	/**
	 * 更新采样包信息
	 *
	 * @author yuanshuai
	 * @date 2023/5/26 16:13
	 */
	void updateSamplingInfo(DogDnaArchive dogDnaArchive);

	void updateApplyChannel(DogDnaArchive dogDnaArchive);

	DogDnaArchive getByRunningNumber(@Param("runningNumber") String runningNumber);

	/**
	 * 根据采样包编号更新遗传疾病
	 * 
	 * @author yuanshuai
	 * @date 2023/8/8 17:03
	 */
	void updateGeneticDiseaseBySamplingCode(@Param("samplingCode") String samplingCode,
			@Param("geneticDisease") String geneticDisease);

	/**
	 * 查找已经处理且没有遗传疾病信息的dna存档数据
	 *
	 * @author yuanshuai
	 * @date 2023/8/8 14:45
	 */
	List<DogDnaArchive> findNoGeneticDiseaseList();

	/**
	 * 修改采集方式
	 *
	 * @author yuanshuai
	 * @since 2024/1/11 15:07
	 */
	void updateIsOec(DogDnaArchive dogDnaArchive);

	/**
	 * 获取已邮寄但未绑定采样包的记录
	 * 
	 * @return
	 */
	List<DogDnaArchive> getUnboundSampling(@Param("memberCode") String memberCode);

	/**
	 * 获取已绑定但未寄回采样包的记录
	 * 
	 * @return
	 */
	List<DogDnaArchive> getNotReturnedSampling(@Param("memberCode") String memberCode);

	/**
	 * 根据订单号查询dna存单列表
	 *
	 * @author yuanshuai
	 * @since 2024/3/29 17:57
	 */
	List<DogDnaArchive> findListByOrderCode(@Param("orderCode") String orderCode);

	void refundDogDnaArchive(@Param("vo") DogDnaArchive vo, @Param("ids") Set<String> ids,
			@Param("businessTable") String businessTable);

}