/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛场犬种补充Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestBreedXref extends DataEntity<ContestBreedXref> {
	
	private static final long serialVersionUID = 1L;
	private String breedNo;		// 代码
	private String name;		// 名称
	
	public ContestBreedXref() {
		super();
	}

	public ContestBreedXref(String id){
		super(id);
	}

	@Length(min=1, max=11, message="代码长度必须介于 1 和 11 之间")
	public String getBreedNo() {
		return breedNo;
	}

	public void setBreedNo(String breedNo) {
		this.breedNo = breedNo;
	}
	
	@Length(min=1, max=255, message="名称长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
}