/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.appreciation.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鉴赏课Entity
 * @author xx
 * @version 2022-02-17
 */
public class AppreciationCourses extends DataEntity<AppreciationCourses> {
	
	private static final long serialVersionUID = 1L;
	private String courseCode;		// 课程编号
	private String courseName;		// 课程名称
	private Date startDate;		// 开始时间
	private Date endDate;		// 结束时间
	private String teacher;		// 授课教师
	private Integer maxNum;		// 人数上线
	private String courseLocation;		// 地点
	private String coursePartner;		// 合作方
	private String states;		// 课程状态（appreciation_courses_state）

	//列表用
	// 开始 开始时间
	private Date beginStartDate;
	// 结束 开始时间
	private Date endStartDate;
	//报名人数
	private Integer courseApplyCount;
	//课程资料
	private String courseCourseware;
	
	private Date lastCoursewareUpdateDate;

	public AppreciationCourses() {
		super();
	}

	public AppreciationCourses(String id){
		super(id);
	}

	@Length(min=8, max=8, message="编号只能为8位数字或字母")
	public String getCourseCode() {
		return courseCode;
	}

	public void setCourseCode(String courseCode) {
		this.courseCode = courseCode;
	}
	
	@Length(min=1, max=50, message="名称需为50字以内")
	public String getCourseName() {
		return courseName;
	}

	public void setCourseName(String courseName) {
		this.courseName = courseName;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
	
	@Length(min=1, max=50, message="讲师长度必须介于 1 和 100 之间")
	public String getTeacher() {
		return teacher;
	}

	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}
	
	public Integer getMaxNum() {
		return maxNum;
	}

	public void setMaxNum(Integer maxNum) {
		this.maxNum = maxNum;
	}
	
	@Length(min=1, max=100, message="地点必须介于 1 和 100 之间")
	public String getCourseLocation() {
		return courseLocation;
	}

	public void setCourseLocation(String courseLocation) {
		this.courseLocation = courseLocation;
	}
	
	@Length(min=1, max=100, message="合作方长度必须介于 1 和 100 之间")
	public String getCoursePartner() {
		return coursePartner;
	}

	public void setCoursePartner(String coursePartner) {
		this.coursePartner = coursePartner;
	}
	
	@Length(min=0, max=1, message="课程状态长度必须介于 0 和 1 之间")
	public String getStates() {
		return states;
	}

	public void setStates(String states) {
		this.states = states;
	}
	
	public Date getBeginStartDate() {
		return beginStartDate;
	}

	public void setBeginStartDate(Date beginStartDate) {
		this.beginStartDate = beginStartDate;
	}
	
	public Date getEndStartDate() {
		return endStartDate;
	}

	public void setEndStartDate(Date endStartDate) {
		this.endStartDate = endStartDate;
	}

	public Integer getCourseApplyCount() {
		return courseApplyCount;
	}

	public void setCourseApplyCount(Integer courseApplyCount) {
		this.courseApplyCount = courseApplyCount;
	}

	public String getCourseCourseware() {
		return courseCourseware;
	}

	public void setCourseCourseware(String courseCourseware) {
		this.courseCourseware = courseCourseware;
	}

	public Date getLastCoursewareUpdateDate() {
		return lastCoursewareUpdateDate;
	}

	public void setLastCoursewareUpdateDate(Date lastCoursewareUpdateDate) {
		this.lastCoursewareUpdateDate = lastCoursewareUpdateDate;
	}

}