<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/layer/layer.js"> </script>
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/jquery-uploadify/css/uploadify.css">
	<script src="<%=request.getContextPath() %>/js/jquery-uploadify/jquery.uploadify.min.js" type="text/javascript"></script>
	<script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery.twbsPagination/jquery.twbsPagination.js"></script>
</head>
<body>
<div class="container-fluid">
<div class="col-md-6" style="padding: 0px;">
	<div class="panel panel-default" style="margin-bottom: 0px;">
	  <div class="panel-heading">
	    <h3 class="panel-title" style="text-align: center;">赛事列表</h3>
	  </div>
	  <div class="panel-body">
			<div class="input-group">
			  <span class="input-group-addon">名称</span>
			  <input type="text" class="form-control" id="keyword" placeholder="名称" aria-describedby="basic-addon1">
			  <span class="input-group-addon" onclick="resend()">发送</span>
			</div>
				<table class="table">
			      <thead>
			        <tr>
			          <th>ID</th>
			          <th>名称</th>
			          <th>操作</th>
			        </tr>
			      </thead>
			      <tbody id="showcontent">
			      </tbody>
			    </table>
		  <%--分页--%>
		  <nav id="pagination_box"><ul class="pagination" id="pagercontent"></ul></nav>
		  <span id="pageval" style="display:none;">1</span>
		  <span id="pagetotal" style="display:none;">0</span>
	  </div>
	</div>
</div>
<input type="hidden" id="addDetailId" value="-1"/>
<div class="col-md-6" style="padding: 0px;">
	<div class="panel panel-default" style="margin-bottom: 0px;">
	  <div class="panel-heading">
	    <h3 class="panel-title" style="text-align: center;padding:0px;" id="showDetailTitle">详细列表</h3>
	  </div>
	  <div class="panel-body">
		<table class="table table-striped">
	      <thead>
	        <tr>
	          <th>Id</th>
	          <th>名称</th>
	          <th>说明</th>
	          <th>操作</th>
	        </tr>
	      </thead>
	      <tbody  id="showDetailContent">
	      </tbody>
	    </table>
	  </div>
	</div>
</div>
</div>
<script>
$(function(){
	send();
})
//重新发送请求
function resend(){
	$("#pageval").html(1);
	send();
}
//发送请求
function send(){
	var keyword = $("#keyword").val();
	var page = $("#pageval").html();
	$.ajax({
		type:"get",
		url:"matchList.do",
		data:{keyword:keyword,page:page,limit:10},
			dataType: 'json',
        timeout: 30000,
        success: function(json){
        	console.log(json);
        	buildHtml(page,json)
        },
        error: function(xhr, type){
            
        }
	});
}
//发送各个详细请求
function sendDetail(type,id){
	var detailTitle = "";
	if(type==0){
		detailTitle = "赛事酒店";
	}else if(type==1){
		detailTitle = "赛事场馆";
	}else if(type==2){
		detailTitle = "赛事裁判";
	};
	var matchName = $("#matchName"+id).html();
	var btn = "<button type=\"button\" class=\"btn btn-success\" onclick=\"addDetail("+type+","+id+")\">添加</button>";
	$("#showDetailTitle").html(detailTitle+"-"+matchName+btn);
	$.ajax({
		type:"get",
		url:"getDetail.do",
		data:{type:type,matchId:id},
		dataType: 'json',
        timeout: 30000,
        success: function(json){
				if(json.rc==0){
				var list = json.items;
				if(list.length>0){
					var html = "";
					$.each(list, function(index,item) {
						html+="<tr><td>"+item.id+"</td><td>"+item.name+"</td><td>"+item.content+"</td>"+
						"<td><button class=\"btn btn-default\" onclick=\"delDetail("+type+","+id+","+item.id+")\" type=\"button\">删除</button></td>"+
						"</tr>";
					});
					$("#showDetailContent").html(html);
				}else{
					$("#showDetailContent").html("没有数据");
				}
			}else{
				$("#showDetailContent").html("请求出错！");
			}
        },
        error: function(xhr, type){
            
        }
	});
}
function addDetail(type,id){
	$('#addDetailId').val(-1);
	var content = "";
	var title = "";
	if(type==0){
		content = '<%=request.getContextPath() %>/admin/ckuMatchHotel/matchHotelModal.jsp';
		title = "添加赛事酒店";
	}else if(type==1){
		content = '<%=request.getContextPath() %>/admin/ckuMatchVenue/matchVenueModal.jsp';
		title = "添加赛事场馆";
	}else if(type==2){
		content = '<%=request.getContextPath() %>/admin/ckuCaiPan/caiPanModal.jsp';
		title = "添加赛事裁判";
	}
    layer.open({
 	      type: 2,
 	      title: title,
 	      shadeClose: true,
 	      shade: [0.8, '#393D49'],
 	      maxmin: false, //开启最大化最小化按钮
 	      area: ['800px', '700px'],
 	      content: content,
	   	  end: function(){
	   		var detailId = $('#addDetailId').val();
	   		if(detailId == -1){
	   			return;
	   		}
	   		$.ajax({
	   			type:"get",
	   			url:"addDetail.do",
	   			data:{type:type,matchId:id,detailId:detailId},
	   			dataType: 'json',
	   	        timeout: 30000,
	   	        success: function(json){
	   	        	if(json.rc==0){
	   					if(json.items>0){
	   						alert("添加成功！");
	   						sendDetail(type,id);
	   					};
	   	        	}
	   	        },
	   	        error: function(xhr, type){
	   	            
	   	        }
	   		}); 
	   	  }
 	    }); 
}
function delDetail(type,id,detailId){
	$.ajax({
		type:"get",
		url:"delDetail.do",
		data:{type:type,matchId:id,detailId:detailId},
		dataType: 'json',
        timeout: 30000,
        success: function(json){
          	if(json.rc==0){
					if(json.items>0){
						alert("删除成功！");
						sendDetail(type,id);
					};
	        	}
        },
        error: function(xhr, type){
            
        }
	});
}
//重构页面
function buildHtml(page,json){
	$("#showcontent").html("");
	if(json.rc==0){
		var list = json.items;
		if(list.length>0){
			var html = "";
			$.each(list, function(index,item) {
				html+="<tr><td>"+item.id+"</td><td id=\"matchName"+item.id+"\">"+item.showLocation+"</td>"+
				"<td>";
				if(item.isTop==1){
					html+="<a onclick=\"updateIsTop("+item.isTop+","+item.id+")\">取消推荐</a>|";
				}else{
					html+="<a onclick=\"updateIsTop("+item.isTop+","+item.id+")\">推荐</a>|";
				}

				html+="<a onclick=\"sendDetail(0,"+item.id+")\">酒店</a>| "+
				"<a onclick=\"sendDetail(1,"+item.id+")\">场馆</a>| "+
				"<a onclick=\"sendDetail(2,"+item.id+")\">裁判</a></td>"+
				"</tr>";
			});
			$("#showcontent").html(html);
		}else{
			$("#showcontent").html("没有数据");
		}
		//分页代码
		var page_size = $("#pagetotal").html();
		page_size = parseInt(page_size);
		if(page_size!=json.total){
			$("#pagination_box").html('<ul id="pagercontent" class="pagination"></ul>');
		}
		$('#pagercontent').twbsPagination({
			startPage: page,
			initiateStartPageClick: false,
			totalPages: json.total==0?1:Math.ceil(json.total/10),
			onPageClick: function (event, page) {
				$('#pageval').html(page);
				send();
			}
		});
		$("#pagetotal").html(json.total);
	}else{
		$("#showcontent").html("请求出错！");
	}
}
	function updateIsTop(isTop,id){
		isTop = isTop==0?1:0;
		//type=1 为推荐赛事
		$.ajax({
			type:"get",
			url:"<%=request.getContextPath() %>/CkuTopMatch/updateMatchToTop.do",
			data:{isTop:isTop,id:id},
			dataType: 'json',
			timeout: 30000,
			success: function(json){
				if(json.rc==0){
					send();
				}
			},
			error: function(xhr, type){

			}
		});
	}
</script>
</body>
</html>
