package com.cku.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.core.ExecResultModel;
import com.cku.dao.CkuMatchSignMapper;
import com.cku.dao.CkuMyMatchMapper;
import com.cku.dao.CkuTabGradeMapper;
import com.cku.dao.EventRelatedMapper;
import com.cku.model.CkuMatchSign;
import com.cku.model.CkuMyMatchModel;
import com.cku.model.CkuTabGrade;
import com.cku.model.EventRelatedModel;
import com.cku.model.FrequentlyUsersModel;

@Service("ckuMyMatchServiceImpl")
public class CkuMyMatchServiceImpl{
	@Autowired
	public CkuMyMatchMapper ckuMyMatchMapper;
	@Autowired
	public CkuMatchSignMapper ckuMatchSignMapper;
	@Autowired
	public EventRelatedMapper eventRelatedMapper;
	@Autowired
	public CkuTabGradeMapper ckuTabGradeMapper;
	
	
	/**
	 * 
	 * @Description：根据登录用户会员号获取个人中心-我的赛事（近期赛事和历史赛事）和赛事下参加的犬只列表
	 * @author: zhuoHeng
	 * @version: 2016年4月2日 上午11:37:03
	 */
	public String getMyMatchByLoginUser(Integer page,Integer limit,String idNum,String flag,String hrstime){
		ExecResultModel<CkuMyMatchModel> resultModel = new ExecResultModel<CkuMyMatchModel>();
		//若客户端未传递“时间”参数，查询
		if(hrstime==null||"".equals(hrstime)){
			//根据会员号获取历史赛事中近期的数据
			List<CkuMyMatchModel> mlist = ckuMyMatchMapper.getMyMatchMonth(idNum);
			//若存在历史赛事中近期的数据
			if(mlist.size()>0 && mlist.get(0)!=null){
				//将数据中的赛事结束时间赋值给“时间”参数（返回历史赛事中存在数据的一个月的数据）
				hrstime = mlist.get(0).getGradeMonth();
			}
		}
		List<CkuMyMatchModel> list = ckuMyMatchMapper.getMyMatchByLoginUser(page,limit,idNum,flag,hrstime);
		for (int i = 0; i < list.size(); i++) {
			list.get(i).setDogList(ckuMyMatchMapper.getMatchDogByShowNum(list.get(i).getMemberNum(), list.get(i).getShow_num()));
		}
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		resultModel.setMsg("");
		return resultModel.getToJson();
	}
	/**
	 * 
	 * @Description：根据赛事编号和犬只CKU血统证书号查询犬只报名信息
	 * @author: zhuoHeng
	 * @version: 2016年4月2日 下午12:57:10
	 */
	public String getSignByStudbookNum(String showNum,String studbookNum){
		ExecResultModel<CkuMatchSign> resultModel = new ExecResultModel<CkuMatchSign>();
		List<CkuMatchSign> ckuMatchSign = ckuMatchSignMapper.getSignByStudbookNum(showNum,studbookNum);
		String[] strs = ckuMatchSign.get(0).getShowNum().split(",");
		String showNumsQqz = "";
		String showNumsDdz = "";
		List<EventRelatedModel> eventList = new ArrayList<EventRelatedModel>();
		ArrayList<FrequentlyUsersModel> frequentlyUsersModelList = new ArrayList<FrequentlyUsersModel>();
		List<CkuMatchSign> list = new ArrayList<CkuMatchSign>();
		//ckuMatchSignMapper.getGradeListByShowsNum(studbookNum, type, showNum);
		for (int i = 0; i < strs.length; i++) {
			EventRelatedModel eventRelatedModel=eventRelatedMapper.getSpecificEventByShowNum(strs[i].trim());
			eventList.add(eventRelatedModel);
			System.out.println(eventRelatedModel.getShowSystem());
			if("0".equals(eventRelatedModel.getShowSystem().trim())){
				showNumsQqz+="'"+eventRelatedModel.getShow_num()+"',";
			}else{
				showNumsDdz+="'"+eventRelatedModel.getShow_num()+"',";
			}
			
		}
		if(showNumsQqz.length()>0){
			showNumsQqz = showNumsQqz.substring(0, showNumsQqz.length()-1);
		}
		if(showNumsDdz.length()>0){
			showNumsDdz = showNumsDdz.substring(0, showNumsDdz.length()-1);
		}
		List<CkuTabGrade> GradeList =ckuTabGradeMapper.getGradeListByShowsNum(studbookNum, showNumsQqz, showNumsDdz);
		//根据cku血统证书号和赛事编号得到牵犬师信息
		if (ckuMatchSign.get(0).getSponsorDetil()!=null) {
			
			String[] sponsorDetil = ckuMatchSign.get(0).getSponsorDetil().split(",");
			if (sponsorDetil.length>0) {
				//得到牵犬师信息
				ckuMatchSign.get(0).setId_num(sponsorDetil[0].trim());
				if (sponsorDetil.length>1) {
					ckuMatchSign.get(0).setUser_name(sponsorDetil[1].trim());
				}
				if(sponsorDetil.length>2){
					ckuMatchSign.get(0).setMobile_phone(sponsorDetil[2].trim());
				}
			}
		}
		ckuMatchSign.get(0).setGradeList(GradeList);
		ckuMatchSign.get(0).setMatchList(eventList);
		list.add(ckuMatchSign.get(0));
		resultModel.setItems(list);
		resultModel.setTotal((long) list.size());
		resultModel.setRc(0);
		resultModel.setMsg("");
		return resultModel.getToJson();
	}
	
}
