package com.cku.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.model.CkuCaiPan;
import com.cku.service.CkuCaiPanServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value="ckuCaiPan")
public class CkuCaiPanController {
	private static final Logger logger = Logger.getLogger(CkuCaiPanController.class);
	@Autowired
	public CkuCaiPanServiceImpl ckuCaiPanService;
	
	//得到ModalList
	@RequestMapping(value="/getListModal")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getListModal(HttpServletResponse response,HttpServletRequest request) throws IOException {
		RESTResponse result = null;
		try{
			String name = ServletUtils.getParameter(request, "name",null);
			PageBean pb = ServletUtils.getParameterBean(request);
			PageBeanResult<CkuCaiPan> list = ckuCaiPanService.getList(name,null,pb);
			result = new RESTResponse("items", list);
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);

	}
	
	/**
	 * 裁判查询所有
	 * @param response
	 * @param request
	 * @throws IOException
	 */
	@RequestMapping(value="/getList")
	public ModelAndView getList(HttpServletResponse response,HttpServletRequest request, ModelMap modelMap) throws IOException {
		String ckuTitle = ServletUtils.getParameter(request, "ckuTitle",null);
		String ckuPosition = ServletUtils.getParameter(request, "ckuPosition",null);
		PageBean pb = ServletUtils.getParameterBean(request);
		PageBeanResult<CkuCaiPan> s = ckuCaiPanService.getList(ckuTitle,ckuPosition,pb);
		modelMap.addAttribute("pageList",s);
		ModelAndView mv = new ModelAndView("admin/ckuCaiPan/caiPanList",modelMap);
		return mv;
	
	}
	/**
	 * 跳转修改页面
	 * @param response
	 * @param request
	 * @param ckuCaiPan
	 * @throws IOException
	 */
	@RequestMapping(value="/toUpdate")
	public ModelAndView toUpdate(HttpServletResponse response,HttpServletRequest request, ModelMap modelMap) throws IOException{
		 String type = ServletUtils.getParameter(request, "type","add");
		 if("edit".equals(type)){
			 long id = ServletUtils.getParameterLong(request, "id",null);
			 CkuCaiPan cp = ckuCaiPanService.getModelById(id);
			 modelMap.addAttribute("caiPan",cp);
		 }else{
			 modelMap.addAttribute("caiPan",null);
		 }
		ModelAndView mv = new ModelAndView("admin/ckuCaiPan/updateCaiPan",modelMap);
		return mv;
	}
	/**
	 * 添加赛事裁判
	 * @param response
	 * @param request
	 * @param ckuCaiPan
	 * @throws IOException
	 */
	@RequestMapping(value="/addCaiPan")
	public ModelAndView addCaiPan(HttpServletResponse response,HttpServletRequest request,CkuCaiPan ckuCaiPan, ModelMap modelMap) throws IOException{
		int i = ckuCaiPanService.addCaiPan(ckuCaiPan);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuCaiPan/getList.do");
		modelMap.addAttribute("message",i>0?"添加裁判成功!":"添加裁判失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	
	/**
	 * 修改赛事裁判
	 */
	@RequestMapping(value="/updateCaiPan")
	public ModelAndView updateCaiPan(HttpServletResponse response,HttpServletRequest request,CkuCaiPan ckuCaiPan, ModelMap modelMap)throws IOException{
		int i = ckuCaiPanService.updateCaiPan(ckuCaiPan);
		String result = i>0?"success":"error";
		modelMap.addAttribute("toPage","ckuCaiPan/getList.do");
		modelMap.addAttribute("message",i>0?"修改裁判成功!":"修改裁判失败!");
		ModelAndView mv = new ModelAndView(result,modelMap);
		return mv;
	}
	/**
	 * 删除赛事裁判
	 */
	@RequestMapping(value="/deleteCaiPan")
	@ResponseBody
	public void deleteCaiPan(HttpServletResponse response,HttpServletRequest request, ModelMap modelMap)throws IOException{
		RESTResponse result = null;
		try{
			long id = ServletUtils.getParameterLong(request, "id",null);
			int i = ckuCaiPanService.deleteCaiPan(id);
			if(i>0){
				result = new RESTResponse(0,"删除裁判成功！");
			}else{
				result = new RESTResponse(1,"删除裁判失败！");
			}
		}catch (Exception e){
			result = new RESTResponse(e);
			logger.error(e);
		}
		ServletUtils.writeResponse(response, result);
	}
}
