package com.cab.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.model.PointsDetail;
import com.cab.model.PointsType;
import com.cab.service.PointsDetailServiceImpl;
import com.cab.service.UserService;
import com.cku.core.RESTResponse;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

@Controller
@RequestMapping(value = "points")
public class PointsDetailController {

	@Autowired
	private PointsDetailServiceImpl PointsDetailService;
	
	/**
	 * 
	 * @Description：按天分组查询用户积分明细
	 * @author: zhuoHeng
	 * @version: 2016年6月20日 下午3:10:51
	 */
	@RequestMapping(value = "/getPointsDetail")
	public void getPointsDetail(HttpServletRequest request,HttpServletResponse response) throws IOException{
		
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			PageBean pb = ServletUtils.getParameterBean(request);
			List<PointsDetail> list = PointsDetailService.getPointsDetail(userId,pb);
			result = new RESTResponse("items",list);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：获取今日积分及任务进度
	 * @author: zhuoHeng
	 * @version: 2016年6月20日 下午3:46:20
	 */
	@RequestMapping(value = "/getTodayPoints")
	public void getTodayPoints(HttpServletRequest request,HttpServletResponse response) throws IOException{
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			List<PointsDetail> list = PointsDetailService.getTodayPoints(userId);
			result = new RESTResponse("items",list);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：微信分享回调接口
	 * @author: zhuoHeng
	 * @version: 2016年6月21日 下午2:56:26
	 */
	@RequestMapping(value = "/weCharCallbacks")
	public void partookCallbacks (HttpServletRequest request,HttpServletResponse response) throws IOException{
		RESTResponse result = null;
		try {
			String userId = UserService.verifyUserId(request);
			PointsDetailService.addPartookPoints(userId);
			result = new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 
	 * @Description：查询所有积分类型信息
	 * @author: zhuoHeng
	 * @version: 2016年6月21日 下午6:01:33
	 */
	@RequestMapping(value = "/selectAllPointsType")
	public void selectAllPointsType(HttpServletRequest request,HttpServletResponse response) throws IOException{
		RESTResponse result = null;
		try {
			List<PointsType> list = PointsDetailService.selectAllPointsType();
			result = new RESTResponse("items",list);
		} catch (Exception e) {
			result = new RESTResponse(e);
		}
		ServletUtils.writeResponse(response, result);
	}
	

    /**
     * 
     * @Description：获取登录用户总积分
     * @author: zhuoHeng
     * @version: 2016年6月23日 上午11:23:22
     */
    @RequestMapping(value = "/getPointsCount")
    public void getPointsCount(HttpServletRequest request,HttpServletResponse response) throws IOException{
        RESTResponse result = null;
        try {
        	String userId = UserService.verifyUserId(request);
            Integer pointsCount = PointsDetailService.selectPointsCount(userId);
            result = new RESTResponse("items",pointsCount);
        } catch (Exception e) {
            result = new RESTResponse(e);
        }
        ServletUtils.writeResponse(response, result);
    }
}
