<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/layer/layer.js"> </script>
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/jquery-uploadify/css/uploadify.css">
	<script src="<%=request.getContextPath() %>/js/jquery-uploadify/jquery.uploadify.min.js" type="text/javascript"></script>
</head>
<body>
<div class="container-fluid">
<div class="col-md-6" style="padding: 0px;">
	<div class="panel panel-default" style="margin-bottom: 0px;">
	  <div class="panel-heading">
	    <h3 class="panel-title" style="text-align: center;">修改赛事列表</h3>
	  </div>
	  <div class="panel-body">
			<div class="input-group">
			  <span class="input-group-addon">名称</span>
			  <input type="text" class="form-control" id="keyword" placeholder="名称" aria-describedby="basic-addon1">
			  <span class="input-group-addon" onclick="resend()">发送</span>
			</div>
				<table class="table">
			      <thead>
			        <tr>
			          <th>ID</th>
			          <th>名称</th>
			          <th>操作</th>
			        </tr>
			      </thead>
			      <tbody id="showcontent">
			      </tbody>
			    </table>
				 <nav>
				  <ul class="pagination">
				    <li>
				      <a  onclick="prePage()" aria-label="Previous">
				        <span aria-hidden="true" >&laquo;</span>
				      </a>
				    </li>
				    <li><span id="nowPage">当前页1</span></li>
				    <li><span id="countPage">总页数1</span></li>
				    <li>
				      <a onclick="nextPage()" aria-label="Next">
				        <span aria-hidden="true">&raquo;</span>
				      </a>
				    </li>
				    <li>
				    	<div class="input-group">
					      <input type="text" id="pageTo" class="form-control" placeholder="jumpto">
					      <span class="input-group-btn">
					        <button class="btn btn-default" onclick="goPage()" type="button">Go!</button>
					      </span>
					    </div>
				    </li>
				  </ul>
				 </nav>
	  </div>
	</div>
</div>
<input type="hidden" id="addDetailId" value="-1"/>
<div class="col-md-6" style="padding: 0px;">
	<div class="panel panel-default" style="margin-bottom: 0px;">
	  <div class="panel-heading">
	    <h3 class="panel-title" style="text-align: center;" id="showDetailTitle">推荐赛事列表</h3>
	  </div>
	  <div class="panel-body">
		<table class="table table-striped">
	      <thead>
	        <tr>
	          <th>Id</th>
	          <th>名称</th>
	          <th>操作</th>
	        </tr>
	      </thead>
	      <tbody  id="showDetailContent">
	      </tbody>
	    </table>
	  </div>
	</div>
</div>
</div>
<script>
var globalPage = 1;
var globalLimit = 10;
$(function(){
	send();
	send2();
})
//重新发送请求
function resend(){
	globalPage = 1;
	send();
	send2();
}
//发送请求
function send(){
	var keyword = $("#keyword").val();
	$.ajax({
		type:"get",
		url:"list.do",
		data:{keyword:keyword,table:'ckuMatch',page:globalPage,limit:globalLimit},
			dataType: 'json',
        timeout: 30000,
        success: function(json){
        	console.log(json);
        	buildHtml(json)
        },
        error: function(xhr, type){
            
        }
	});
}
function send2(){
	$.ajax({
		type:"POST",
		url:"<%=request.getContextPath() %>/CkuTopMatch/getTopMatch.do",
		dataType: 'json',
        timeout: 30000,
        success: function(json){
				if(json.rc==0){
				var list = json.items;
				if(list.length>0){
					var html = "";
					$.each(list, function(index,item) {
						html+="<tr><td>"+item.id+"</td><td>"+item.show_location+"</td>"+
						"<td><button class=\"btn btn-default\" onclick=\"sendDetail(0,"+item.id+")\" type=\"button\">取消推荐</button></td>"+
						"</tr>";
					});
					$("#showDetailContent").html(html);
				}else{
					$("#showDetailContent").html("没有数据");
				}
			}else{
				$("#showDetailContent").html("请求出错！");
			}
        },
        error: function(xhr, type){
            
        }
	});
}
//重构页面
function buildHtml(json){
	$("#showcontent").html("");
	if(json.rc==0){
		var list = json.items;
		if(list.length>0){
			var html = "";
			$.each(list, function(index,item) {
				html+="<tr><td>"+item.id+"</td><td id=\"matchName"+item.id+"\">"+item.name+"</td>"+
				"<td><button  class=\"btn btn-default\" onclick=\"sendDetail(1,"+item.id+")\" type=\"button\">推荐</button></td>"+
				"</tr>";
			});
			var perPageCount = globalPage;
			$("#nowPage").html("当前页"+perPageCount);
			$("#countPage").html("总页数"+Math.ceil(json.total/globalLimit));
			globalTotal = json.total;
			$("#showcontent").html(html);
		}else{
			$("#showcontent").html("没有数据");
			$("#nowPage").html("当前页"+1);
			$("#countPage").html("总页数"+0);
		}
	}else{
		$("#showcontent").html("请求出错！");
		$("#nowPage").html("当前页"+1);
		$("#countPage").html("总页数"+0);
	}
	
}
//修改为推荐赛事
function sendDetail(type,id){
	//type=1 为推荐赛事
	$.ajax({
		type:"get",
		url:"<%=request.getContextPath() %>/CkuTopMatch/updateMatchToTop.do",
		data:{isTop:type,id:id},
		dataType: 'json',
        timeout: 30000,
        success: function(json){
				if(json.rc==0){
					send();
					send2();
			}else{
				$("#showDetailContent").html("请求出错！");
			}
        },
        error: function(xhr, type){
            
        }
	});
}
function prePage(){
	if(globalPage==1){
		alert("当前为第一页");
	}else{
		globalPage = globalPage-1;
	}
	send();
}
function nextPage(){
	if(globalPage*globalLimit>=globalTotal){
		alert("当前为最后一页");
	}
	globalPage = globalPage+1;
	send();
}
function goPage(){
	var pageTo = $("#pageTo").val();
	if(pageTo*globalLimit>=globalTotal){
		alert("超出范围");
	}
	globalPage = parseInt(pageTo);
	send();
}
</script>
</body>
</html>
