package com.sys.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.dao.CkuDvUserMapper;
import com.cku.dao.CkuMemberBalanMapper;
import com.cku.dao.CkuUserPayListMapper;
import com.cku.model.CkuDvUserModel;
import com.cku.model.CkuMemberBalance;
import com.cku.model.CkuUserPayList;

@Service("alipayService")
public class AlipayServiceImpl {

	@Autowired
	public CkuUserPayListMapper ckuUserPayListMapper;	
	@Autowired
	public CkuDvUserMapper ckuDvUserMapper;
	@Autowired
	public CkuMemberBalanMapper ckuMemberBalanMapper;
	
	/**
	 * 
	 * @Description：验证CKU会员身份是否存在
	 * @author: zhuoHeng
	 * @version: 2016年9月13日 下午7:29:08
	 */
	public boolean getOrder(String thirdUserId){
		String ckuUserId = "";
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
		if(ckuDvUserModel != null){
			ckuUserId = ckuDvUserModel.getCkuId();
		}else{
			return false;
		}
		return true;
	}
	/**
	 * 更改余额
	 * @param userId
	 * @param money
	 * @return
	 */
	@Transactional
	public boolean rechargeBanlance(String thirdUserId,String order ,String money){
		boolean result = false;
		String ckuUserId = "-1";
		//根据CKU账号id查询出CKU账号信息
		CkuDvUserModel ckuDvUserModel = ckuDvUserMapper.getckuMemberByUserId(thirdUserId);
		if(ckuDvUserModel != null){
			ckuUserId = ckuDvUserModel.getCkuId();
		}else{
			return false;
		}
		//根据CKU会员号查询出对应用户的余额信息
		CkuMemberBalance ckuMemberBalance = ckuMemberBalanMapper.getCkuMemberBalance(ckuUserId);
		//根据CKU会员号查询出对应用户的余额信息
		CkuUserPayList ckuUserPayList = new CkuUserPayList();
		String uuid = UUID.randomUUID().toString().replaceAll("-", "");
		ckuUserPayList.setId(uuid);
		ckuUserPayList.setUserId(ckuUserId);
		ckuUserPayList.setMoneyType("0");
		ckuUserPayList.setMoneyDate(new Date());
		ckuUserPayList.setMoneyAmount(new BigDecimal(money));
		ckuUserPayList.setMoneyWay("1");
		ckuUserPayList.setRunningNumber(order);
		ckuUserPayList.setPayState("2");
		ckuUserPayList.setOutTradeNo(order);
		ckuUserPayList.setAlipayS("caib");
		ckuUserPayList.setAddTime(new Date());
		ckuUserPayList.setOperater(ckuUserId);
		ckuUserPayList.setDelTag("0");
		ckuUserPayList.setCreateBy(ckuUserId);
		ckuUserPayList.setUpdateBy(ckuUserId);
		ckuUserPayListMapper.insertSelective(ckuUserPayList);
		
		if(ckuMemberBalance!=null){
			String dbMoney = ckuMemberBalance.getMoneyAmount();
			BigDecimal bigDbMoney = new BigDecimal(dbMoney);
			BigDecimal lastMoney = bigDbMoney.add(new BigDecimal(money));
			if(ckuMemberBalanMapper.updateMemberBalance(lastMoney, ckuUserId)>0){
				result = true;
			};
		}
		
		return result;
	
	}
}
