package com.cab.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.cab.model.zxbUserModel;
import com.cab.service.LoginServiceImpl;



/**
 * 
 * <p>Title:loginController </p>
 * <p>Description: 用户登录控制层</p>
 * <p>Company: </p> 
 * @author zhuoHeng
 * @date 2016年5月11日 下午3:52:20
 */
@Controller
@RequestMapping(value="login")
public class loginController {
	
	@Autowired
	public LoginServiceImpl loginService;
	
	/**
	 * 
	 * @Description：异步请求验证用户登录
	 * @author: zhuoHeng
	 * @version: 2016年5月11日 下午3:52:42
	 * @throws IOException 
	 */
	@RequestMapping(value="/userLogin.do")
	public void userLogin(HttpServletRequest request,HttpServletResponse response) throws IOException{
		
		String userName = request.getParameter("userName");
		String passWord = request.getParameter("passWord");
		
		
		String message = loginService.getLoginUser(userName, passWord,request);
		
		try {
			response.getWriter().write(message);
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			response.getWriter().close();
		}
		
	}
	
	/**
	 * 
	 * @Description：登录到欢迎页面
	 * @author: zhuoHeng
	 * @version: 2016年5月11日 下午7:01:30
	 */
	@RequestMapping(value="/toWelcomePage")
	public ModelAndView toWelcomePage(HttpServletRequest request,HttpServletResponse response){
		
		HttpSession session = request.getSession();
		Map<String, Object> map = new HashMap<String, Object>();
		String userName = (String)session.getAttribute("userName");
		zxbUserModel zxbUserModel = loginService.getUserMessage(userName);
		map.put("userName", zxbUserModel.getUserName());
		
		return new ModelAndView("index",map);
	}
	
	/**
	 * 
	 * @Description：用户退出系统
	 * @author: zhuoHeng
	 * @version: 2016年5月12日 上午10:31:56
	 */
	@RequestMapping(value="/userLogout")
	public String userLogout(HttpServletRequest request){
		HttpSession session = request.getSession();
		session.invalidate();
		return "redirect:/login.jsp";
	}

}
