package com.cab.controller;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cab.service.UserService;
import com.cab.service.UserServiceImpl;
import com.cku.core.RESTResponse;
import com.cku.util.ServletUtils;
import com.sys.model.MultiUserProfile;

@Controller
@RequestMapping(value = "user")
public class UserController {

	private static final Logger logger = LoggerFactory.getLogger(UserController.class);
	
	@Autowired
	public UserServiceImpl userService;

	/**
	 * 
	 * @Description：验证token有效性，并返回token对应的cku用户id
	 * @author: zhuoHeng
	 * @version: 2016年11月8日 下午2:37:47
	 */
	@RequestMapping(value = "/validate")
	public void validate(HttpServletResponse response,HttpServletRequest request)throws Exception {
		RESTResponse result = null;
		logger.debug("跟踪/user/validate.do日志：开始");
		try {
			MultiUserProfile userProfile = UserService.verifyTokenObj(request);
			logger.info("解析用户信息==="+userProfile.toString());
			String ckuUserId = userService.validate(userProfile.getUserId(),userProfile.getClub());
			logger.info("验证用户信息，用户ID==="+ckuUserId);
			Map<String, String> map = new HashMap<String, String>();
			map.put("ckuUserId", ckuUserId);
			map.put("loginType", userProfile.getLoginType());
			result = new RESTResponse("token", map);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			result = new RESTResponse(e);
		}
		logger.debug("跟踪/user/validate.do日志：结束");
		ServletUtils.writeResponse(response, result);
	}
	
}
