<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ page isELIgnored="false" %>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <style>
        *{padding:0;margin:0;}
        body img {
            width: 100%;
        }
        body{margin:0;}
        h3{margin:0;}
        .clearfix:before,.clearfix:after {content: "";display: table;}
        .clearfix:after {clear: both;}
        .clearfix {*zoom:1;}
        .comment .title{line-height:40px;padding-left:12px;}
        .comment ul{margin:0;padding:0;}
        .comment li{padding:0;margin:0;list-style:none;border-top:1px solid #555;padding:12px;}
        .comment .logo{float:left;height:56px;width:56px;border:1px solid #555;border-radius:50%;-webkit-border-radius:50%;overflow:hidden;}
        .comment .right{margin-left:25%;position:relative;}
        .comment .right h3{line-height:1em;color:#54B5BE;}
        .comment .right p{margin:0;line-height:40px;}
        .comment .right .num{position:absolute;top:0;right:0;}
        .comment .num em,.comment .num span{display:inline-block;vertical-align: middle;}
        .comment .num em{font-style:normal;color:#101010;}
        .comment .num span{height:18px;width:20px;background-color:red;margin-right:7px;}
        .comment .content{line-height:35px;}
        .comment .reply{line-height:40px;background-color:#F5F5F5;padding-left:10px;color:#54B5BE;}
        .comment .reply span{color:#444;}

        .topbar{height:50px;background:#f9f9f9;border-top:1px solid #dfdfdf;border-bottom-style: solid;border-bottom-color: #d6d6d6;border-bottom-width: 1px;}
        .topbar .logo{height: 30px;width: 30px;padding-left: 20px;padding-top: 8px;}
        .topbar .desc{height: 30px;width: 51px;padding-left: 8px;padding-top: 9px;}
        /*.topbar .logolf{height:50px;float:left;width:160px;background:url(/caibmobile/img/logo.png) left top no-repeat;background-size:100%;text-indent:-99999em;}*/
        .topbar span{display:block;height:50px;line-height:50px;color:#9b9b9b;font-size:16px;float:right;padding-right:20px;}
        .sharetitle{height:auto;padding:10px 20px}
        .sharetitle h2{line-height:1.5;font-size:20px;font-weight:bold;color:#000000;width: 60%;}
        .pd10{padding:20px;}

        .person{padding:10px 20px}
        .person dl{height:auto;overflow:hidden;zoom:1;padding:0 0 0 10px;margin:0}
        .person dl dt{display:block;float:left;width:58px;height:58px;overflow:hidden;zoom:1;background:#d8d8d8;border-radius:100%;}
        .person dl dd{padding:0;margin:0}
        .person dl dd strong{font-weight:normal;font-size:20px;color:#2dcded;height:30px;line-height:30px;display:block;}
        .person dl dd span{font-weight:normal;font-size:15px;color:#000000;height:20px;line-height:20px;}
        .pos{position: relative;}
        .code{position: absolute;top:5px;right:5px;width: 40%;text-align: center;}
        .code p{font-size: 12px;}
        .xz{display: inline-block;}
    </style>
    <script src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.js"></script>
    <scirpt src="<%=request.getContextPath() %>/js/util.js"></scirpt>
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/videojs/video-js.min.css">
    <script src="<%=request.getContextPath() %>/js/videojs/video.min.js"></script>
    <script src="http://res.wx.qq.com/open/js/jweixin-1.0.0.js"></script>
    <title id="titleHtml">${items.title}</title>
</head>
<body>
    <div class="topbar">
        <img src="<%=request.getContextPath() %>/img/logo.png" class="logo" alt=""><img src="<%=request.getContextPath() %>/img/desc.png" class="desc" alt="">
        <%--<div class="logolf">宠爱王国</div>--%>
        <span id="type">
            <c:if test="${items.contentType=='020000'}">
                视频
            </c:if>
            <c:if test="${items.contentType=='010000'}">
                图文
            </c:if>
        </span>
    </div>
    <div class="pos">
        <div class="sharetitle">
            <h2 id="showTitle">${items.title}</h2>
        </div>
        <div class="person">
            <dl>
                <dd>
                    <span id="time"><fmt:formatDate value="${items.createTime}" pattern="yyyy-MM-dd HH:mm:ss" ></fmt:formatDate></span>
                </dd>
            </dl>

        </div>
        <div class="code">
            <img style="width:70%;" src="<%=request.getContextPath() %>/img/wechat2.png">
            <p>长按关注“宠爱club”</p>
        </div>
    </div>
    <c:if test="${items.videoUrl!=null && items.videoUrl!=''}">
            <video id="really-cool-video" class="video-js vjs-default-skin vjs-big-play-centered" controls preload="auto" width="400" height="264" poster="${items.thumb}" data-setup='{}'>
                <source src="${items.videoUrl }" type="video/mp4">
            </video>
    </c:if>

    <div class="pd10" id="frameHtml">
        ${items.htmlStr}
    </div>
    <div style="margin-bottom:10px">
        <img style="width: 50%;margin-left: 25%;" src="<%=request.getContextPath() %>/img/code.jpg">
        <p style="text-align:center;line-height: 40px;">宠爱王国APP</p>
    </div>
</body>
<script>
    $(function(){
//        var targetUrl = location.href.split('#')[0];
//        targetUrl = targetUrl.replace('&', '%26');
        var targetUrl = encodeURIComponent(window.location.href);
        //alert(targetUrl);
        getjstoken(targetUrl);
    })
    function getjstoken(targetUrl){
        $.ajax({
            url: '<%=request.getContextPath() %>/wechat/getjssdktoken.do',
            type: 'post',
            dataType : 'json',
            data:{url:targetUrl},
            success: function(data){
                token = data.token;
                wx.config({
                    debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
                    appId: token.appid, // 必填，公众号的唯一标识
                    timestamp: token.timestamp, // 必填，生成签名的时间戳
                    nonceStr: token.nocestr, // 必填，生成签名的随机串
                    signature: token.signature,// 必填，签名，见附录1
                    jsApiList: ['onMenuShareTimeline',
                        'onMenuShareAppMessage'] // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
                });

                wx.ready(function(){
                    // config信息验证后会执行ready方法，所有接口调用都必须在config接口获得结果之后，config是一个客户端的异步操作，
                    // 所以如果需要在页面加载时就调用相关接口，则须把相关接口放在ready函数中调用来确保正确执行。对于用户触发时才调用的接口，则可以直接调用，不需要放在ready函数中。
                    //alert(window.location.href);


                    // 1 判断当前版本是否支持指定 JS 接口，支持批量判断
                    wx.checkJsApi({
                        jsApiList: [
                            'onMenuShareTimeline',
                            'onMenuShareAppMessage'
                        ],
                        success: function (res) {
                            //alert("zhichi");
                            //console.log(res);
                        },
                        fail:function(){
                            //alert("buzhichi");
                        },
                        complete: function(){
                          //alert("checkJsApi complete");
                        }
                    });

                    //朋友圈
                    wx.onMenuShareTimeline({
                        title: '${items.title}', // 分享标题
                        link: location.href.split('&')[0], // 分享链接
                        imgUrl: '${items.thumbMin}', // 分享图标
                        success: function () {
                            // 用户确认分享后执行的回调函数
                            //alert("分享给朋友圈 success");
                        },
                        cancel: function () {
                            // 用户取消分享后执行的回调函数
                            //alert("分享给朋友圈 cancel");
                        }
                    });
                    //朋友
                    wx.onMenuShareAppMessage({
                        title: '${items.title}', // 分享标题
                        desc: '${items.contentBrief}', // 分享描述
                        link: location.href.split('&')[0], // 分享链接
                        imgUrl: '${items.thumbMin}', // 分享图标
                        type: 'link', // 分享类型,music、video或link，不填默认为link
                        dataUrl: '', // 如果type是music或video，则要提供数据链接，默认为空
                        success: function () {
                            // 用户确认分享后执行的回调函数
                            //alert("分享给朋友 success");
                        },
                        fail: function(){
                            //alert("分享给朋友 fail");
                        },
                        cancel: function () {
                            // 用户取消分享后执行的回调函数
                            //alert("分享给朋友 cancel");
                        }
                    });


                });
                wx.error(function(res){
                    // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
                    //alert("error");
                });

            },
            error:function(){
                alert(error);
            }
        });
    }
</script>
</html>
