<%@ page language="java" contentType="text/html;charset=UTF-8" %> 
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page isELIgnored="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title>内容管理编辑</title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
	<link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/ueditor.config.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/ueditor.all.js"> </script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/layer/layer.js"> </script>
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/jquery-uploadify/css/uploadify.css">
	<script src="<%=request.getContextPath() %>/js/jquery-uploadify/jquery.uploadify.min.js" type="text/javascript"></script>
    <!--建议手动加在语言，避免在ie下有时因为加载语言失败导致编辑器加载失败-->
    <!--这里加载的语言文件会覆盖你在配置项目里添加的语言类型，比如你在配置项目里配置的是英文，这里加载的中文，那最后就是中文-->
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/lang/zh-cn/zh-cn.js"></script>
    <script type="text/javascript">
    	var typeList1 = [
		<c:forEach var="type" items="${contentTypeList1}">
			{ 'contentTypeId': '${type.id}', 'name': '${type.name}', 'level': ${type.level} }, 
		</c:forEach>
		];
    	var typeList2 = [
		<c:forEach var="type" items="${contentTypeList2}">
			{ 'contentTypeId': '${type.id}', 'name': '${type.name}', 'level': ${type.level}, 'parentTypeId': '${type.parentTypeId}' }, 
		</c:forEach>
		];
    	var typeList3 = [
		<c:forEach var="type" items="${contentTypeList3}">
			{ 'contentTypeId': '${type.id}', 'name': '${type.name}', 'level': ${type.level}, 'parentTypeId': '${type.parentTypeId}' }, 
		</c:forEach>
		];
    	var sel1, sel2, sel3;
    	function build_option_htm(type, selected)
    	{
    		var htm = "<option value='" + type.contentTypeId + "'";
    		if (selected)
    		{
    			htm += " selected='selected'";
    		}
    		htm += ">" + type.name + "</option>";
    		return htm;    		
    	}
    	function build_select()
    	{
    		sel1 = $("#sel1");
    		sel2 = $("#sel2");
    		sel3 = $("#sel3");
    		
    		var first = true;
    		for (var i = 0; i < typeList1.length; ++i)
    		{
    			var type = typeList1[i];
				var htm = build_option_htm(type, first);
				sel1.append(htm);
				first = false;    			
    		}
    		
    		change_select1(typeList1[0].contentTypeId);    		
    		
    		sel1.change(function() {
    			change_select1(sel1.val());
    		});

    		sel2.change(function() {
    			change_select2(sel2.val());
    		});
    		
    	}
    	function change_select1(val)
    	{
    		sel2.empty();    		
    		var first = true;
    		
    		for (var i = 0; i < typeList2.length; ++i)
    		{
    			var type = typeList2[i];
    			if (type.parentTypeId == parseInt(val))
    			{
    				var htm = build_option_htm(type, first);
    				sel2.append(htm);
    				if (first)
    				{
    					change_select2(type.contentTypeId);
    					first = false;
    				}
    			}
    		}
    	}
    	function change_select2(val)
    	{
    		sel3.empty();    		
    		var first = true;
    		
    		for (var i = 0; i < typeList3.length; ++i)
    		{
    			var type = typeList3[i];
    			if (type.parentTypeId == parseInt(val) || type.contentTypeId == -1)
    			{
    				var htm = build_option_htm(type, first);
    				sel3.append(htm);
    				first = false;
    			}
    		}
    	}
    </script>
    <style type="text/css">
        div{
            width:100%;
        }
        .uploadify{
        	margin:auto;
        }
    </style>
</head>
<body>
<div class="container">
<div class="row">
	<div class="alert alert-success" style="text-align: center;" role="alert">添加图文</div>
	<div class="col-md-6">
		<div class="input-group">
			<span class="input-group-addon" id="basic-addon1">分类</span>
			<select id="sel1"  class="form-control"></select>	
			<select id="sel2"  class="form-control"></select>	
			<select id="sel3"  class="form-control"></select>
		</div>
	</div>
	<div class="col-md-6">
		<div class="input-group">
		  <span class="input-group-addon">主标题</span>
		  <input type="text" id="idTitle" class="form-control" placeholder="主标题" aria-describedby="basic-addon1">
		</div>
		<div class="input-group">
		  <span class="input-group-addon">副标题</span>
		  <input type="text" id="idSubTitle" class="form-control" placeholder="副标题" aria-describedby="basic-addon1">
		</div>
		<div class="input-group">
		  <span class="input-group-addon">简述</span>
		  <input type="text" id="contentBrief" class="form-control" placeholder="简述" aria-describedby="basic-addon1">
		</div>
	</div>
	<div class="col-md-6">
	<div class="input-group">
		<span class="input-group-addon">今日推荐</span>
		<select id="isFirst"  class="form-control">
		<option value="0" selected="selected">否</option><option value="1">是</option>
		</select>	
	</div>
	</div>
	<div class="col-md-6">
	<div class="input-group">
		<span class="input-group-addon">置顶</span>
		<select id="isTop"  class="form-control">
		<option value="0" selected="selected">否</option><option value="1">是</option>
		</select>
	</div>
	</div>
	<div class="col-md-6">
		<div class="input-group">
			<span class="input-group-addon">原创</span>
			<select id="isCreate"  class="form-control">
				<option value="0" selected="selected">否</option><option value="1">是</option>
			</select>
		</div>
	</div>
	<div class="input-group">
		<span class="input-group-addon">缩略图(210x200)</span>
		<input type="text" id="thumbMin" class="form-control" style="height: 45px;" readonly="readonly"  placeholder="列表展现图" aria-describedby="basic-addon1">
		<span class="input-group-addon" style="padding: inherit;"><div><span id="myImage0"></span></div></span>
	</div>
	<div class="input-group">
	  <span class="input-group-addon">缩略图(750X294)</span>
	  <input type="text" id="thumb" class="form-control" style="height: 45px;" readonly="readonly"  placeholder="缩略图" aria-describedby="basic-addon1">
	  <span class="input-group-addon" style="padding: inherit;"><div><span id="myImage1"></span></div></span>
	</div>
	<div class="input-group">
	  <span class="input-group-addon">banner滚动图片集</span>
	  <input type="text" id="headerBanner" readonly="readonly" style="height: 45px;" class="form-control" placeholder="banner滚动图片集" aria-describedby="basic-addon1">
	  <span class="input-group-addon" style="padding: inherit;"><div><span id="myImage2"></span></div></span>
	  
	</div>
	<div class="input-group">
	  <span class="input-group-addon">视频</span>
	  <input type="text" id="videoUrl" style="height: 45px;" class="form-control" placeholder="视频" aria-describedby="basic-addon1">
	  <span class="input-group-addon" style="padding: inherit;"><div><span id="myImage3"></span></div></span>
	</div>
</div>
    <script type="text/javascript">
    	build_select();
    </script>
	
    <script id="editor" type="text/plain" style="height:500px;"></script>
    <div class="alert alert-info" role="alert" style="text-align: center;">
    	<button type="button" onclick="showHtml()" class="btn btn-info">预览</button>
    	<button type="button" onclick="commitContent()" class="btn btn-info">提交</button>
    	<a type="button" href="<%=request.getContextPath() %>/publish/list.do" class="btn btn-info">返回</a>
    </div>
</div>

<!-- <div id="btns">
    <div>
        <button onclick="getAllHtml()">获得整个html的内容</button>
        <button onclick="getContent()">获得内容</button>
        <button onclick="setContent()">写入内容</button>
        <button onclick="setContent(true)">追加内容</button>
        <button onclick="getContentTxt()">获得纯文本</button>
        <button onclick="getPlainTxt()">获得带格式的纯文本</button>
        <button onclick="hasContent()">判断是否有内容</button>
        <button onclick="setFocus()">使编辑器获得焦点</button>
        <button onmousedown="isFocus(event)">编辑器是否获得焦点</button>
        <button onmousedown="setblur(event)" >编辑器失去焦点</button>

    </div>
    <div>
        <button onclick="getText()">获得当前选中的文本</button>
        <button onclick="insertHtml()">插入给定的内容</button>
        <button id="enable" onclick="setEnabled()">可以编辑</button>
        <button onclick="setDisabled()">不可编辑</button>
        <button onclick=" UE.getEditor('editor').setHide()">隐藏编辑器</button>
        <button onclick=" UE.getEditor('editor').setShow()">显示编辑器</button>
        <button onclick=" UE.getEditor('editor').setHeight(300)">设置高度为300默认关闭了自动长高</button>
    </div>

    <div>
        <button onclick="getLocalData()" >获取草稿箱内容</button>
        <button onclick="clearLocalData()" >清空草稿箱</button>
    </div>

</div> -->
<!-- <div>
     <button onclick="createEditor()">
    创建编辑器</button>
    <button onclick="deleteEditor()">
    删除编辑器</button> 
    <button onclick="commitContent()">提交</button>
</div> -->
<script type="text/javascript">
    //实例化编辑器
    //建议使用工厂方法getEditor创建和引用编辑器实例，如果在某个闭包下引用该编辑器，直接调用UE.getEditor('editor')就能拿到相关的实例
    var ue = UE.getEditor('editor',{
        catchRemoteImageEnable:false
    });
	//上传列表展现图
	$('#myImage0').uploadify({
		'swf'      : '<%=request.getContextPath() %>/js/jquery-uploadify/uploadify.swf',
		'uploader' : '<%=request.getContextPath() %>/publish/uploadFile.do?type=image',
		'height': 30,
		'width' :100,
		'auto'  : true,
		'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
		'buttonText' : '选择',
		'fileTypeExts' : '*.gif; *.jpg; *.png',
		'multi'    : false,
		'method'   :'post',
		'successTimeout' : 300,
		'debug':false,
		'onInit': function () {     //载入时触发，将flash设置到最小
			//$("#myImage").hide();
			///$("#myImage1-queue").hide();
		},
		'onUploadSuccess' : function(file, data, response) {
			var json = eval("(" + data + ")");
			if(json.rc==0){
				$("#thumbMin").val(json.items);
			}
		},
		'onUploadError' : function(file, errorCode, errorMsg, errorString) {
			alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
		}

	});
    //上传缩略图
    $('#myImage1').uploadify({
		'swf'      : '<%=request.getContextPath() %>/js/jquery-uploadify/uploadify.swf',
		<%-- 'uploader' : '<%=request.getContextPath() %>/js/jsp/controller.jsp?action=uploadimage', --%>
		'uploader' : '<%=request.getContextPath() %>/publish/uploadFile.do?type=image',
		'height': 30,
		'width' :100,
		'auto'  : true,
		'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
		'buttonText' : '选择',
		'fileTypeExts' : '*.gif; *.jpg; *.png',
		'multi'    : false,
		'method'   :'post',
		'successTimeout' : 300,
		'debug':false,
		'onInit': function () {     //载入时触发，将flash设置到最小
			//$("#myImage").hide();
			///$("#myImage1-queue").hide();
		},
		'onUploadSuccess' : function(file, data, response) {
			/* console.log(data);
			console.log(typeof data);
			var json = eval("(" + data + ")");
			//{"state": "SUCCESS","original": "cq3.png","title": "27_6_1458811079263.jpg","type": ".png","url": "http://chongaibao.b0.upaiyun.com/cab_test/image/image/27_6_1458811079263.jpg"}
			 if(json.state =="SUCCESS"){
				 $("#thumb").val(json.url);
			}  */
			var json = eval("(" + data + ")");
			if(json.rc==0){
				$("#thumb").val(json.items);
			}
		},
		'onUploadError' : function(file, errorCode, errorMsg, errorString) {
			alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
		}

	});
    //上传banner滚动图片集
    $('#myImage2').uploadify({
		'swf'      : '<%=request.getContextPath() %>/js/jquery-uploadify/uploadify.swf',
		<%-- 'uploader' : '<%=request.getContextPath() %>/js/jsp/controller.jsp?action=uploadimage', --%>
		'uploader' : '<%=request.getContextPath() %>/publish/uploadFile.do?type=image',
		'height': 30,
		'width' :100,
		'auto'  : true,
		'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
		'buttonText' : '选择',
		'fileTypeExts' : '*.gif; *.jpg; *.png',
		'multi'    : true,
		'method'   :'post',
		'successTimeout' : 300,
		'debug':false,
		'onInit': function () {     //载入时触发，将flash设置到最小
			//$("#myImage").hide();
			//$("#myImage2-queue").hide();
		},
		'onUploadSuccess' : function(file, data, response) {
			var json = eval("(" + data + ")");
			if(json.rc==0){
				 var inStr = $("#headerBanner").val();
				 if(inStr=="" || inStr ==null){
					 $("#headerBanner").val(json.items);
				 }else{
					 $("#headerBanner").val(json.items+","+inStr);
				 }
			}
			/* console.log(data);
			console.log(typeof data);
			var json = eval("(" + data + ")");
			//{"state": "SUCCESS","original": "cq3.png","title": "27_6_1458811079263.jpg","type": ".png","url": "http://chongaibao.b0.upaiyun.com/cab_test/image/image/27_6_1458811079263.jpg"}
			 if(json.state =="SUCCESS"){
				 var inStr = $("#headerBanner").val();
				 if(inStr=="" || inStr ==null){
					 $("#headerBanner").val(json.url);
				 }else{
					 $("#headerBanner").val(json.url+","+inStr);
				 }
			}  */
		},
		'onUploadError' : function(file, errorCode, errorMsg, errorString) {
			alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
		}

	});
    //上传视频
    $('#myImage3').uploadify({
		'swf'      : '<%=request.getContextPath() %>/js/jquery-uploadify/uploadify.swf',
		<%-- 'uploader' : '<%=request.getContextPath() %>/js/jsp/controller.jsp?action=uploadvideo&encode=utf-8', --%>
		'uploader' : '<%=request.getContextPath() %>/publish/uploadFile.do?type=video',
		'height': 30,
		'width' :100,
		'auto'  : true,
		'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
		'buttonText' : '选择',
		'fileTypeExts' : '*.mp4; *.avi',
		'multi'    : false,
		'method'   :'post',
		'successTimeout' : 3000,
		'debug':false,
		'onInit': function () {     //载入时触发，将flash设置到最小
			//$("#myImage").hide();
			//$("#myImage3-queue").hide();
		},
		'onUploadSuccess' : function(file, data, response) {
			var json = eval("(" + data + ")");
			if(json.rc==0){
				$("#videoUrl").val(json.items);
			}
			/* console.log(data);
			console.log(typeof data);
			var json = eval("(" + data + ")");
			//{"state": "SUCCESS","original": "cq3.png","title": "27_6_1458811079263.jpg","type": ".png","url": "http://chongaibao.b0.upaiyun.com/cab_test/image/image/27_6_1458811079263.jpg"}
			 if(json.state =="SUCCESS"){
				$("#videoUrl").val(json.url);
			}  */
		},
		'onUploadError' : function(file, errorCode, errorMsg, errorString) {
			alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
		}

	});
    function commitContent(){
    	var html = UE.getEditor('editor').getContent();
    	var title = $("#idTitle").val();
    	var idSubTitle = $("#idSubTitle").val();
    	var contentBrief = $("#contentBrief").val();
    	var isFirst = $("#isFirst").val();
    	var isTop = $("#isTop").val();
		var isCreate = $("#isCreate").val();
    	var thumb = $("#thumb").val();
		var thumbMin = $("#thumbMin").val();
    	var headerBanner = $("#headerBanner").val();
    	var videoUrl = $("#videoUrl").val();
    	if(title==null || title==""){
    		alert("标题不能为空！");
    		return;
    	}
    	if(idSubTitle==null || idSubTitle==""){
    		alert("副标题不能为空！");
    		return;
    	}
    	if(contentBrief==null || contentBrief==""){
    		alert("简介不能为空！");
    		return;
    	}
    	if(thumb==null || thumb==""){
    		alert("缩略图不能为空！");
    		return;
    	}
    	var jsonData = { 
    			"html" : html, 
    			"title" : title,
    			"subTitle" : idSubTitle,
    			"contentBrief" : contentBrief,
    			"isFirst" : isFirst,
    			"headerBanner" : headerBanner,
    			"thumb" : thumb,
    			"videoUrl" : videoUrl,
    			"isTop" : isTop,
				"isCreate" : isCreate,
				"thumbMin" : thumbMin,
    			"contentType1" : sel1.val(), 
    			"contentType2" : sel2.val(), 
    			"contentType3" : sel3.val() 
    			};
    	
    	$.ajax( { 
    		type:"POST", 
    		url:"commit.do", 
    		contentType: "application/json", 
    		data: JSON.stringify(jsonData), 
    		async:true,
    		success: function (data) {
    			alert('提交成功');
    			location.href="<%=request.getContextPath() %>/publish/list.do";
    		}, 
    		error: function (data) {
    			alert('提交失败');
    		}    		
    	});
    }
    function showHtml(){
    	var html = UE.getEditor('editor').getContent();
    	var title = $("#idTitle").val();
    	var jsonData = {};
    	jsonData.html = html;
    	jsonData.title = title;
    	//iframe窗
    	$.ajax( { 
    		type:"POST", 
    		url:"showHtml.do", 
    		contentType: "application/json", 
    		data: JSON.stringify(jsonData), 
    		async:true,
    		success: function (data) {
        	    layer.open({
        	   	      type: 2,
        	   	      title: title,
        	   	      shadeClose: true,
        	   	      shade: [0.8, '#393D49'],
        	   	      maxmin: false, //开启最大化最小化按钮
        	   	      area: ['400px', '700px'],
        	   	      content: '<%=request.getContextPath() %>/jsp/show.html',
        		   	  success: function(layero, index){
        		   	  }
        	   	    }); 
    		}, 
    		error: function (data) {
    		}    		
    	});
/*     	OpenWindow=window.open("", title, "height=750, width=400, top=100,left=300,toolbar=no, menubar=no, scrollbars=no, resizable=no, location=no, status=no"); 
    	OpenWindow.document.write("<html><head>") 
    	OpenWindow.document.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">") 
    	OpenWindow.document.write("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no\">") 
    	OpenWindow.document.write("<style> body img {width:100%;} </style>") 
    	OpenWindow.document.write("</head><body>") 
    	OpenWindow.document.write("<title>" + title + "</title>") 
    	OpenWindow.document.write(html) 
    	OpenWindow.document.write("</body></html>") 
    	OpenWindow.document.close() */
    }

/*     function isFocus(e){
        alert(UE.getEditor('editor').isFocus());
        UE.dom.domUtils.preventDefault(e)
    }
    function setblur(e){
        UE.getEditor('editor').blur();
        UE.dom.domUtils.preventDefault(e)
    }
    function insertHtml() {
        var value = prompt('插入html代码', '');
        UE.getEditor('editor').execCommand('insertHtml', value)
    }
    function createEditor() {
        enableBtn();
        UE.getEditor('editor');
    }
    function getAllHtml() {
        alert(UE.getEditor('editor').getAllHtml())
    }
    function getContent() {
        var arr = [];
        arr.push("使用editor.getContent()方法可以获得编辑器的内容");
        arr.push("内容为：");
        arr.push(UE.getEditor('editor').getContent());
        alert(arr.join("\n"));
    }
    function getPlainTxt() {
        var arr = [];
        arr.push("使用editor.getPlainTxt()方法可以获得编辑器的带格式的纯文本内容");
        arr.push("内容为：");
        arr.push(UE.getEditor('editor').getPlainTxt());
        alert(arr.join('\n'))
    }
    function setContent(isAppendTo) {
        var arr = [];
        arr.push("使用editor.setContent('欢迎使用ueditor')方法可以设置编辑器的内容");
        UE.getEditor('editor').setContent('欢迎使用ueditor', isAppendTo);
        alert(arr.join("\n"));
    }
    function setDisabled() {
        UE.getEditor('editor').setDisabled('fullscreen');
        disableBtn("enable");
    }

    function setEnabled() {
        UE.getEditor('editor').setEnabled();
        enableBtn();
    }

    function getText() {
        //当你点击按钮时编辑区域已经失去了焦点，如果直接用getText将不会得到内容，所以要在选回来，然后取得内容
        var range = UE.getEditor('editor').selection.getRange();
        range.select();
        var txt = UE.getEditor('editor').selection.getText();
        alert(txt)
    }

    function getContentTxt() {
        var arr = [];
        arr.push("使用editor.getContentTxt()方法可以获得编辑器的纯文本内容");
        arr.push("编辑器的纯文本内容为：");
        arr.push(UE.getEditor('editor').getContentTxt());
        alert(arr.join("\n"));
    }
    function hasContent() {
        var arr = [];
        arr.push("使用editor.hasContents()方法判断编辑器里是否有内容");
        arr.push("判断结果为：");
        arr.push(UE.getEditor('editor').hasContents());
        alert(arr.join("\n"));
    }
    function setFocus() {
        UE.getEditor('editor').focus();
    }
    function deleteEditor() {
        disableBtn();
        UE.getEditor('editor').destroy();
    }
    function disableBtn(str) {
        var div = document.getElementById('btns');
        var btns = UE.dom.domUtils.getElementsByTagName(div, "button");
        for (var i = 0, btn; btn = btns[i++];) {
            if (btn.id == str) {
                UE.dom.domUtils.removeAttributes(btn, ["disabled"]);
            } else {
                btn.setAttribute("disabled", "true");
            }
        }
    }
    function enableBtn() {
        var div = document.getElementById('btns');
        var btns = UE.dom.domUtils.getElementsByTagName(div, "button");
        for (var i = 0, btn; btn = btns[i++];) {
            UE.dom.domUtils.removeAttributes(btn, ["disabled"]);
        }
    }

    function getLocalData () {
        alert(UE.getEditor('editor').execCommand( "getlocaldata" ));
    }

    function clearLocalData () {
        UE.getEditor('editor').execCommand( "clearlocaldata" );
        alert("已清空草稿箱")
    } */
</script>
</body>
</html>