<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ page isELIgnored="false" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title>栏目管理</title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap/css/bootstrap-theme.min.css">
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/bootstrap-tree/bootstrap-treeview.min.css">
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/jquery-1.11.2.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/util.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/jquery/Jquery.Query.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap/js/bootstrap.min.js"></script>
    <script type="text/javascript" charset="utf-8" src="<%=request.getContextPath() %>/js/bootstrap-tree/bootstrap-treeview.min.js"></script>
    <link rel="stylesheet" href="<%=request.getContextPath() %>/js/jquery-uploadify/css/uploadify.css">
    <script src="<%=request.getContextPath() %>/js/jquery-uploadify/jquery.uploadify.min.js" type="text/javascript"></script>
</head>
<body>
<div class="container-fluid">
    <!-- 模态框（Modal） -->
    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close"
                            data-dismiss="modal" aria-hidden="true">
                        &times;
                    </button>
                    <h4 class="modal-title" id="myModalLabel">
                        添加栏目
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="input-group">
                        <span class="input-group-addon" >父节点：</span>
                        <input type="text" id="addDetailParentId" readonly="readonly"  class="form-control" placeholder="父节点">
                    </div>
                    <div class="input-group">
                        <span class="input-group-addon" >级别：</span>
                        <input type="text" id="addDetailLevel" readonly="readonly"  class="form-control" placeholder="级别">
                    </div>
                    <div class="input-group">
                        <span class="input-group-addon" >id：</span>
                        <input type="text" id="addDetailId"  class="form-control" placeholder="编号">
                    </div>

                    <div class="input-group">
                        <span class="input-group-addon" >名称：</span>
                        <input type="text" id="addDetailName"  class="form-control" placeholder="名称">
                    </div>
                    <div class="input-group">
                        <span class="input-group-addon" >缩略图：</span>
                        <input type="text" id="addDetailImgUrl" class="form-control" placeholder="缩略图">
                        <span class="input-group-addon"><div><span id="myImage2"></span></div></span>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default"
                            data-dismiss="modal">关闭
                    </button>
                    <button type="button" id="addSaveBtn" class="btn btn-primary">
                        提交
                    </button>
                </div>
            </div><!-- /.modal-content -->
            </div>
        </div><!-- /.modal -->
    <div class="col-md-6" style="padding: 0px;">
        <div class="text-right" style="padding: 5px 0;">
            <button id="refreshBtn" type="button" class="btn btn-warning btn-sm" >刷新</button>
            <button id="addBtn" type="button" class="btn btn-primary btn-sm" >添加下级</button>
            <button id="delBtn" type="button" class="btn btn-success btn-sm" >删除</button>
        </div>
        <div class="panel panel-default" style="margin-bottom: 0px;">
            <div class="panel-heading">
                <h3 class="panel-title" style="text-align: center;">栏目列表</h3>
            </div>
            <div class="panel-body">
                <div id="treeview">

                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6" style="padding: 0px;">
        <div class="text-right" style="padding: 5px 0;">
            <button id="updateBtn" type="button" class="btn btn-success btn-sm" >保存</button>
        </div>
        <div class="panel panel-default" style="margin-bottom: 0px;">
            <div class="panel-heading">
                <h3 class="panel-title" style="text-align: center;padding:0px;" id="showDetailTitle">详细列表</h3>
            </div>
            <div class="panel-body" id="showDetail">
               <%--请选择节点！--%>
                   <div class="input-group">
                       <span class="input-group-addon" >级别：</span>
                       <input type="text" id="detailLevel"  class="form-control" readonly="readonly" placeholder="级别">
                   </div>
                   <div class="input-group">
                       <span class="input-group-addon" >id：</span>
                       <input type="text" id="detailId"  class="form-control" placeholder="编号">
                   </div>

                   <div class="input-group">
                       <span class="input-group-addon" >名称：</span>
                       <input type="text" id="detailName"  class="form-control" placeholder="名称">
                   </div>
                   <div class="input-group">
                       <span class="input-group-addon" >缩略图：</span>
                       <input type="text" id="detailImgUrl" class="form-control" placeholder="缩略图">
                       <span class="input-group-addon"><div><span id="myImage1"></span></div></span>
                   </div>
            </div>
        </div>
    </div>

</div>
<script>
    var globalNode = null;
    $(function(){
        initTree();
        //上传缩略图
        $('#myImage1').uploadify({
            'swf'      : '<%=request.getContextPath() %>/js/jquery-uploadify/uploadify.swf',
            'uploader' : '<%=request.getContextPath() %>/publish/uploadFile.do?type=image',
            'height': 30,
            'width' :100,
            'auto'  : true,
            'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
            'buttonText' : '选择',
            'fileTypeExts' : '*.gif; *.jpg; *.png',
            'multi'    : false,
            'method'   :'post',
            'successTimeout' : 300,
            'debug':false,
            'onInit': function () {     //载入时触发，将flash设置到最小
                //$("#myImage").hide();
                ///$("#myImage1-queue").hide();
            },
            'onUploadSuccess' : function(file, data, response) {
                var json = eval("(" + data + ")");
                if(json.rc==0){
                    $("#detailImgUrl").val(json.items);
                }
            },
            'onUploadError' : function(file, errorCode, errorMsg, errorString) {
                alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
            }

        });
        //上传缩略图
        $('#myImage2').uploadify({
            'swf'      : '<%=request.getContextPath() %>/js/jquery-uploadify/uploadify.swf',
            'uploader' : '<%=request.getContextPath() %>/publish/uploadFile.do?type=image',
            'height': 30,
            'width' :100,
            'auto'  : true,
            'fileObjName' : 'file',   //文件对象名称,用于后台获取文件对象时使用
            'buttonText' : '选择',
            'fileTypeExts' : '*.gif; *.jpg; *.png',
            'multi'    : false,
            'method'   :'post',
            'successTimeout' : 300,
            'debug':false,
            'onInit': function () {     //载入时触发，将flash设置到最小
                //$("#myImage").hide();
                ///$("#myImage1-queue").hide();
            },
            'onUploadSuccess' : function(file, data, response) {
                var json = eval("(" + data + ")");
                if(json.rc==0){
                    $("#addDetailImgUrl").val(json.items);
                }
            },
            'onUploadError' : function(file, errorCode, errorMsg, errorString) {
                alert('The file ' + file.name + ' could not be uploaded: ' + errorString);
            }

        });
        $("#refreshBtn").on("click",function(){
          window.location.reload();
        });
        $("#updateBtn").on("click",function(){
            var detailId = $("#detailId").val();
            var detailName = $("#detailName").val();
            var detailImgUrl = $("#detailImgUrl").val();
            if(!util.isVal(detailId.trim())   ){
                alert("编号不能为空!");
                return;
            }
            if(!util.isVal(detailName.trim())   ){
                alert("名称不能为空!");
                return;
            }
            if(!util.isVal(detailImgUrl.trim())   ){
                alert("缩略图不能为空!");
                return;
            }
            $.ajax( {
                type:"POST",
                url:"<%=request.getContextPath()%>/contentType/updateDetail.do",
                dataType: "json",
                data: {detailId:detailId.trim(),detailName:detailName.trim(),detailImgUrl:detailImgUrl.trim()},
                async:true,
                success: function (json) {
                    console.log(json.item);
                    if(json.rc==0){
                        window.location.reload();
                    }else{
                        alert(json.msg);
                    }
                },
                error: function (data) {
                    alert('提交失败');
                }
            });
        });
        $("#addSaveBtn").on("click",function(){
            var addDetailLevel = $("#addDetailLevel").val();
            var addDetailId = $("#addDetailId").val();
            var addDetailName = $("#addDetailName").val();
            var addDetailImgUrl = $("#addDetailImgUrl").val();
            var addDetailParentId = $("#addDetailParentId").val();
            if(!util.isVal(addDetailId.trim())   ){
                alert("编号不能为空!");
                return;
            }
            if(!util.isVal(addDetailName.trim())   ){
                alert("名称不能为空!");
                return;
            }
            if(!util.isVal(addDetailImgUrl.trim())   ){
                alert("缩略图不能为空!");
                return;
            }
            $.ajax( {
                type:"POST",
                url:"<%=request.getContextPath()%>/contentType/saveDetail.do",
                dataType: "json",
                data: {addDetailId:addDetailId.trim(),addDetailName:addDetailName.trim(),addDetailImgUrl:addDetailImgUrl.trim(),addDetailLevel:addDetailLevel,addDetailParentId:addDetailParentId},
                async:true,
                success: function (json) {
                    console.log(json.item);
                    if(json.rc==0){
                        window.location.reload();
                    }else{
                        alert(json.msg);
                    }

                },
                error: function (data) {
                    alert('提交失败');
                }
            });
        });
        $("#addBtn").on("click",function(){
            if(!util.isVal(globalNode)){
                if(confirm("您没有选择父节点，确认要添加根节点么？")){
                    $("#addDetailParentId").val();
                    $("#addDetailLevel").val(1);
                }else{
                    return;
                };
            }else{
               if(globalNode.level==3){
                   alert("三级节点不能添加子节点！");
                   return;
               }
                $("#addDetailParentId").val(globalNode.id);
                $("#addDetailLevel").val(globalNode.level+1);
            }
            $("#myModal").modal('show');
        })
        $("#delBtn").on("click",function(){
            if(!util.isVal(globalNode)){
                alert("请选择要删除的节点！");
                return;
            }
            $.ajax( {
                type:"POST",
                url:"<%=request.getContextPath()%>/contentType/delDetail.do",
                dataType: "json",
                data: {id:globalNode.id},
                async:true,
                success: function (json) {
                    console.log(json.item);
                    if(json.rc==0){
                        window.location.reload();
                    }
                },
                error: function (data) {
                    alert('提交失败');
                }
            });
        });
    })
    function initTree(){
        $.ajax( {
            type:"POST",
            url:"<%=request.getContextPath()%>/contentType/getTree.do",
            contentType: "application/json",
            data: {},
            async:true,
            success: function (json) {
                console.log(json.items);
                if(json.rc==0){
                    $('#treeview').treeview({
                        showTags: true,
                        data: json.items,
                        onNodeSelected:function(event, node){
                            getDetail(node.id);
                            globalNode = node;
                        }
                    });
                }
            },
            error: function (data) {
                alert('提交失败');
            }
        });
    }
    function getDetail(id){
        $.ajax( {
            type:"POST",
            url:"<%=request.getContextPath()%>/contentType/getDetail.do",
            dataType: "json",
            data: {id:id},
            async:true,
            success: function (json) {
                console.log(json.item);
                if(json.rc==0){
                    $("#detailId").val(json.item.id);
                    $("#detailName").val(json.item.name);
                    $("#detailImgUrl").val(json.item.imgUrl);
                    $("#detailLevel").val(json.item.level);
                }
            },
            error: function (data) {
                alert('提交失败');
            }
        });
    }

</script>
</body>
</html>