package com.sys.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.sys.dao.VersionMapper;
import com.sys.model.Version;

/**
 *user chaixueteng
 *2016年5月30日
 */
@Service("VersionService")
public class VersionServiceImpl {
	@Autowired
	public VersionMapper versionMapper;

	public Version getVersion(String version) {
		Version version1 = versionMapper.selectByVersion(version);
		return version1;
	}
	
	public Version selectByAndroidName(String version) {
		Version version1 = versionMapper.selectByAndroidName(version);
		return version1;
	}
	
	public Version getIOSVersion(String iosVersion) {
		Version version = versionMapper.selectByIOSVersion(iosVersion);
		return version;
	}


	/**
	 * 添加安卓版本信息
	 * @param update 
	 * @Author chaixueteng
	 * @2016年8月16日上午11:23:20
	 */
	public void insertVersion(String version, String androidName,
			String androidDownload, String update) {
		Version androidVersion = new Version();
		androidVersion.setVersion(version);
		androidVersion.setAndroidName(androidName);
		androidVersion.setAndroidDownload(androidDownload);
		update = update == null ? "0" : update;
		androidVersion.setAndroidUpdate(Integer.valueOf(update));
		androidVersion.setCreateDate(new Date());
		versionMapper.insertVersion(androidVersion);
	}

	/**
	 * 添加ios版本信息
	 * @Author chaixueteng
	 * @2016年8月16日下午1:30:49
	 */
	public void insertIOSVersion(String iosVersion, String update) {
		Version IOSVersion = new Version();
		IOSVersion.setIosVersion(iosVersion);
		update = update == null ? "0" : update;
		IOSVersion.setIosUpdate(Integer.valueOf(update));
		IOSVersion.setCreateDate(new Date());
		versionMapper.insertIOSVersion(IOSVersion);
	}

	/**
	 * 获取最新版本号(ios)
	 * @Author chaixueteng
	 * @2016年8月16日下午3:05:37
	 */
	public Version getNewVersion() {
		return versionMapper.getNewVersion();
	}
	
	
	
	/**
	 * 获取最新版本号(安卓)
	 * @Author chaixueteng
	 * @2016年8月16日下午3:14:16
	 */
	public Version getNewAndroid(){
		return versionMapper.getNewAndroid();
	}
	
	
	public List<Version> getIosList(Version version){
		return versionMapper.getIosList(version);
	}
	
	public List<Version> getAndroidList(Version version){
		return versionMapper.getAndroidList(version);
	}
	
}
