package com.cku.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAException;
import com.cku.model.EventRelatedModel;
import com.cku.service.EventRelatedServiceImpl;
import com.cku.util.PageBean;
import com.cku.util.ServletUtils;

/**
 *user chaixueteng
 *2016年5月4日
 */
@Controller
@RequestMapping("CkuTopMatch")
public class CkuTopMatchController {
	
	private static final Logger logger = Logger.getLogger(EventRelatedController.class);

	@Autowired
	private EventRelatedServiceImpl eventRelatedServiceImpl;
	//修改赛事为是否推荐赛事
	@RequestMapping("/updateMatchToTop")
	public void updateMatchToTop(HttpServletResponse response,HttpServletRequest request) throws IOException{
		RESTResponse result=null;
		try{
			//获取赛事id,根据赛事id修改是否是推荐赛事
			Integer id = ServletUtils.getParameterInt(request, "id");
			Integer isTop = ServletUtils.getParameterInt(request, "isTop");
			eventRelatedServiceImpl.updateMatchToTop(id,isTop);
			result=new RESTResponse();
		} catch (Exception e) {
			result = new RESTResponse(e);
			e.printStackTrace();
		}
		ServletUtils.writeResponse(response, result);
	}
	            
	//得到推荐赛事
	@RequestMapping("/getTopMatch")
	public void getTopMatch(HttpServletResponse response,HttpServletRequest request)throws IOException{
		try{
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String str=eventRelatedServiceImpl.getTopMatch();
			response.getWriter().write(str);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
	}
}
