package com.cab.service;

import com.cab.dao.ContentMapper;
import com.cab.model.Content;
import com.cab.model.ContentComment;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.cku.util.PageBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;

/**
 * Created by user on 2016/5/5.
 */
@Service("shareService")
public class ShareServiceImpl {
    @Autowired
    public ContentMapper contentMapper;
    @Autowired
    public ContentCommentServiceImpl contentCommentService;
    public Object getShare(Long contentId,PageBean pb){
        Content c = new Content();
        c = contentMapper.selectByPrimaryKey(contentId);
        c.setHtmlStr(parseHtml(c.getUrl()));
        List<ContentComment> commentList = contentCommentService.selectByContentId(contentId,pb);
        long count=contentCommentService.getCount(contentId);
        c.setCommentList(commentList);
        c.setCommentCount(count);

        return c;
    }
    public String parseHtml(String url){
        String htmlStr = "";
        HttpResult result= null;
        try {
            result = HttpClientUtil.get(null,url,null);
            htmlStr = result.getResponseBody();
            htmlStr = htmlStr.substring(htmlStr.indexOf("</title>")+8);
            htmlStr = htmlStr.substring(0,htmlStr.indexOf("</body>"));
            htmlStr = htmlStr.replaceAll("\"","'");
        } catch (IOException e) {
            e.printStackTrace();
        }

        return htmlStr;
    }
}
